/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.frame.client.global.EXConstructionElementTypeUnknown;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class UniqueElementRelationshipHelper {
    private static final ILogger logger = Logger.getLogger(UniqueElementRelationshipHelper.class);

    public static Tuple<List<IUniqueElement>, List<IUniqueElement>> getActiveAndPassiveSuccessorElements(String uniqueElementUID, String planUID, IUniqueElementRelationshipProvider relationshipProvider) {
        Collection<IUniqueElement> nextElements = UniqueElementRelationshipHelper.getNextUniqueElements(uniqueElementUID, planUID, relationshipProvider);
        Collection<IUniqueElement> previousElements = UniqueElementRelationshipHelper.getPreviousUniqueElements(uniqueElementUID, planUID, relationshipProvider);
        nextElements.removeAll(previousElements);
        UniqueElementRelationshipHelper.removeElementItself(nextElements, uniqueElementUID);
        return UniqueElementRelationshipHelper.separateActiveAndPassiveElements(nextElements);
    }

    public static Tuple<List<IUniqueElement>, List<IUniqueElement>> getActiveAndPassivePredecessorElements(String uniqueElementUID, String planUID, IUniqueElementRelationshipProvider relationshipProvider) {
        Collection<IUniqueElement> nextElements = UniqueElementRelationshipHelper.getNextUniqueElements(uniqueElementUID, planUID, relationshipProvider);
        Collection<IUniqueElement> previousElements = UniqueElementRelationshipHelper.getPreviousUniqueElements(uniqueElementUID, planUID, relationshipProvider);
        previousElements.removeAll(nextElements);
        UniqueElementRelationshipHelper.removeElementItself(previousElements, uniqueElementUID);
        return UniqueElementRelationshipHelper.separateActiveAndPassiveElements(previousElements);
    }

    public static Tuple<List<IUniqueElement>, List<IUniqueElement>> getActiveAndPassiveBidirectionallyRelatedElements(String uniqueElementUID, String planUID, IUniqueElementRelationshipProvider relationshipProvider) {
        Collection<IUniqueElement> nextElements = UniqueElementRelationshipHelper.getNextUniqueElements(uniqueElementUID, planUID, relationshipProvider);
        Collection<IUniqueElement> previousElements = UniqueElementRelationshipHelper.getPreviousUniqueElements(uniqueElementUID, planUID, relationshipProvider);
        nextElements.retainAll(previousElements);
        UniqueElementRelationshipHelper.removeElementItself(nextElements, uniqueElementUID);
        return UniqueElementRelationshipHelper.separateActiveAndPassiveElements(nextElements);
    }

    private static Collection<IUniqueElement> getNextUniqueElements(String uniqueElementUID, String planUID, IUniqueElementRelationshipProvider relationshipProvider) {
        return planUID == null ? relationshipProvider.getNextUniqueElements(uniqueElementUID) : relationshipProvider.getNextUniqueElementsOnPlan(uniqueElementUID, planUID);
    }

    private static Collection<IUniqueElement> getPreviousUniqueElements(String uniqueElementUID, String planUID, IUniqueElementRelationshipProvider relationshipProvider) {
        return planUID == null ? relationshipProvider.getPreviousUniqueElements(uniqueElementUID) : relationshipProvider.getPreviousUniqueElementsOnPlan(uniqueElementUID, planUID);
    }

    private static void removeElementItself(Collection<IUniqueElement> elementCollection, String uniqueElementUID) {
        Iterator<IUniqueElement> uniqueElementIterator = elementCollection.iterator();
        while (uniqueElementIterator.hasNext()) {
            IUniqueElement ueFromCollection = uniqueElementIterator.next();
            if (!uniqueElementUID.equals(ueFromCollection.getUID())) continue;
            uniqueElementIterator.remove();
        }
    }

    private static Tuple<List<IUniqueElement>, List<IUniqueElement>> separateActiveAndPassiveElements(Collection<IUniqueElement> uniqueElements) {
        ArrayList<IUniqueElement> activeElements = new ArrayList<IUniqueElement>(uniqueElements.size());
        ArrayList<IUniqueElement> passiveElements = new ArrayList<IUniqueElement>(uniqueElements.size());
        for (IUniqueElement uniqueElement : uniqueElements) {
            try {
                IConstructionElementTypeDescription typeDescription = ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForType(uniqueElement.getElementTypeID());
                int activePassive = typeDescription.getActiveOrPassiveConstructionElementType();
                if (activePassive == 1) {
                    passiveElements.add(uniqueElement);
                    continue;
                }
                if (activePassive == 0) {
                    activeElements.add(uniqueElement);
                    continue;
                }
                logger.warn("Unique element is neither active nor passive: " + uniqueElement.getElementName() + " (active/passive value is " + activePassive + ")");
            }
            catch (EXConstructionElementTypeUnknown eCETU) {
                logger.warn("Unique element with unknown type: " + uniqueElement.getElementTypeID(), (Throwable)eCETU);
            }
        }
        return new Tuple(activeElements, passiveElements);
    }
}

