/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PlanWithOccurrences {
    private final Map<String, EOUniqueElementOccurrence> occurrences;
    private final String planUID;

    protected PlanWithOccurrences(String planUID) {
        assert (planUID != null);
        this.planUID = planUID;
        this.occurrences = new HashMap<String, EOUniqueElementOccurrence>();
    }

    protected PlanWithOccurrences(PlanWithOccurrences pwo) {
        this.planUID = pwo.planUID;
        this.occurrences = new HashMap<String, EOUniqueElementOccurrence>(pwo.occurrences);
    }

    protected void addOccurrence(EOUniqueElementOccurrence occurrence) {
        assert (this.planUID.equals(occurrence.getPlanUID()));
        this.occurrences.put(occurrence.getPlanElementUID(), occurrence);
    }

    protected EOUniqueElementOccurrence removeOccurrence(String planElementUID) {
        return this.occurrences.remove(planElementUID);
    }

    protected boolean isEmpty() {
        return this.occurrences.isEmpty();
    }

    protected int size() {
        return this.occurrences.size();
    }

    protected boolean contains(String planElementUID) {
        return this.occurrences.containsKey(planElementUID);
    }

    protected Collection<EOUniqueElementOccurrence> getAllOccurrences() {
        return this.occurrences.values();
    }

    protected EOUniqueElementOccurrence getOccurrence(String planElementUID) {
        return this.occurrences.get(planElementUID);
    }
}

