/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.locking;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.cockpitlib.client.data.jpa.JPAEOCoDec;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileSetTransactionAbortedException;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.locking.ClientLockStateOutOfSyncException;
import com.arcway.cockpit.frame.client.project.core.locking.LockDBManager;
import com.arcway.cockpit.frame.client.project.core.locking.LockModificationElement;
import com.arcway.cockpit.frame.client.project.core.locking.LockTableLockInformation;
import com.arcway.cockpit.frame.client.project.core.locking.lockhasher.LockHasherByLockData;
import com.arcway.cockpit.frame.client.project.core.locking.lockhasher.LockHasherByUID;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;

public class LockAllocationTable {
    private static final ILogger logger = Logger.getLogger(LockAllocationTable.class);
    private static final String INITIAL_SERVER_LOCK_PREFIX = "initialserverlock";
    private final IMapRW_<EOLock, LockTableLockInformation> lockTable;
    private final ISetRW_<EOLock> unacknowledgedLocks;
    private final LockDBManager lockDBManager;

    public LockAllocationTable(IFrameProjectAgent projectAgent) throws EXCorruptProjectData {
        this.lockDBManager = new LockDBManager(projectAgent.getProjectSubFolder(ProjectAgent.PROJECT_SUBFOLDER_LOCKS_DB));
        this.lockTable = new HashMap_(LockHasherByLockData.INSTANCE);
        this.unacknowledgedLocks = new HashSet_(LockHasherByUID.INSTANCE);
        assert (!new File(projectAgent.getProjectRoot(), "locks.mod").exists()) : "Your Workspace uses a incompatible/old storage format. Please delete this workspace.";
        try {
            this.readPersistentLockInfo();
        }
        catch (Exception e) {
            throw new EXCorruptProjectData(e);
        }
    }

    private void readPersistentLockInfo() throws Exception {
        this.lockDBManager.executeAsTransaction(new LockDBManager.IJPATransactionBody(){

            @Override
            public void run(EntityManager em) throws Exception {
                final XMLDecoder xmlDecoder = new XMLDecoder();
                final MessageDataFactory messageDataFactory = MessageDataFactory.getInstance();
                Query dataQuery = em.createNamedQuery("LockModificationElement_readAllData");
                dataQuery.setFlushMode(FlushModeType.COMMIT);
                JPAEOCoDec.executeQueryAndProcessResultUsingCursoredStream((Query)dataQuery, (int)50, (JPAEOCoDec.ResultConsumer)new JPAEOCoDec.ResultConsumer(){

                    public void consume(Object rowData) throws EXDecoderException {
                        Object[] data = (Object[])rowData;
                        char lockType = ((Character)data[0]).charValue();
                        String xmlData = (String)data[1];
                        EOLock eoLock = (EOLock)JPAEOCoDec.convertXmlStringToNewEO((String)xmlData, (XMLDecoder)xmlDecoder, (IEncodableObjectFactory)messageDataFactory);
                        if ('a' == lockType) {
                            HashSet<String> uids = new HashSet<String>();
                            String lockUID = LockAllocationTable.INITIAL_SERVER_LOCK_PREFIX + eoLock.getUID();
                            uids.add(lockUID);
                            LockTableLockInformation lockCacheLockInformation = new LockTableLockInformation(uids, eoLock);
                            LockAllocationTable.this.lockTable.put((Object)eoLock, (Object)lockCacheLockInformation);
                        } else if ('u' == lockType) {
                            LockAllocationTable.this.unacknowledgedLocks.add((Object)eoLock);
                        } else if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"unknown lock acknowledgement type");
                        }
                    }
                });
            }
        });
    }

    private boolean checkRequestLock(EOLock lockToRequestFor) {
        boolean needServerRequest = false;
        if (!this.lockTable.containsKey((Object)lockToRequestFor)) {
            needServerRequest = true;
        }
        return needServerRequest;
    }

    public Collection<EOLock> prepareRequestOfLocks(Collection<EOLock> locksToRequestFor) throws ClientLockStateOutOfSyncException, FileSetTransactionAbortedException {
        HashSet_ alreadyCheckedLocksOfThisRequest = new HashSet_(LockHasherByLockData.INSTANCE);
        final EOList locksNeedServerRequest = new EOList();
        for (EOLock lockToCheck : locksToRequestFor) {
            if (alreadyCheckedLocksOfThisRequest.contains((Object)lockToCheck)) continue;
            if (this.checkRequestLock(lockToCheck)) {
                locksNeedServerRequest.add((EncodableObjectBase)lockToCheck);
            }
            alreadyCheckedLocksOfThisRequest.add((Object)lockToCheck);
        }
        if (!locksNeedServerRequest.isEmpty()) {
            if (!this.unacknowledgedLocks.isEmpty()) {
                throw new ClientLockStateOutOfSyncException("Previous Lock Requests were interrupted - uncertain about their result. Unable to request new locks from server until this clients lock state is in reconciled with the server.");
            }
            this.lockDBManager.executeAsTransaction(new LockDBManager.IJPATransactionBody(){

                @Override
                public void run(EntityManager em) throws Exception {
                    if (!$assertionsDisabled && (Long)em.createNamedQuery("LockModificationElement_count_unacknowleged", Long.class).getSingleResult() != 0L) {
                        throw new AssertionError();
                    }
                    for (EOLock lock : locksNeedServerRequest) {
                        em.persist((Object)new LockModificationElement('u', lock));
                    }
                }
            });
            assert (this.unacknowledgedLocks.isEmpty());
            this.unacknowledgedLocks.addAll((Collection)locksNeedServerRequest);
        }
        return locksNeedServerRequest;
    }

    public Collection<EOLock> prepareReleaseOfAllLocks() throws FileSetTransactionAbortedException, ClientLockStateOutOfSyncException {
        boolean unacknowledgedLocksExistedBeforeThisMethodCall = !this.unacknowledgedLocks.isEmpty();
        ISet_<EOLock> locksNeedServerRelease = this.getAllAllocatedServerLocks();
        HashSet_ extendedUnacknowledgedLocks = new HashSet_(LockHasherByUID.INSTANCE);
        extendedUnacknowledgedLocks.addAll(this.unacknowledgedLocks);
        extendedUnacknowledgedLocks.addAll(locksNeedServerRelease);
        if (!locksNeedServerRelease.isEmpty()) {
            this.lockDBManager.executeAsTransaction(new LockDBManager.IJPATransactionBody((ISetRW_)extendedUnacknowledgedLocks){
                private final /* synthetic */ ISetRW_ val$extendedUnacknowledgedLocks;
                {
                    this.val$extendedUnacknowledgedLocks = iSetRW_;
                }

                @Override
                public void run(EntityManager em) throws Exception {
                    if (!$assertionsDisabled && (Long)em.createNamedQuery("LockModificationElement_count_unacknowleged", Long.class).getSingleResult() != (long)LockAllocationTable.this.unacknowledgedLocks.size()) {
                        throw new AssertionError();
                    }
                    Query query = em.createNamedQuery("LockModificationElement_degrade_all_acknowleged_to_unacknowleged");
                    query.executeUpdate();
                    if (!$assertionsDisabled && (Long)em.createNamedQuery("LockModificationElement_count_unacknowleged", Long.class).getSingleResult() != (long)this.val$extendedUnacknowledgedLocks.size()) {
                        throw new AssertionError();
                    }
                }
            });
        }
        this.lockTable.clear();
        this.unacknowledgedLocks.clear();
        this.unacknowledgedLocks.addAll((ICollection_)extendedUnacknowledgedLocks);
        if (unacknowledgedLocksExistedBeforeThisMethodCall) {
            throw new ClientLockStateOutOfSyncException("Previous Lock Requests were interrupted - uncertain about their result. Will not try to send further lock requests to the server until this clients lock state is in reconciled with the server.");
        }
        return this.unacknowledgedLocks.asJavaCollection();
    }

    public Collection<EOLock> prepareReleaseOfLocks(Collection<EOLock> locksToRelease) throws FileSetTransactionAbortedException, ClientLockStateOutOfSyncException {
        boolean unacknowledgedLocksExistedBeforeThisMethodCall = !this.unacknowledgedLocks.isEmpty();
        ArrayList_ locksNeedServerRelease = new ArrayList_();
        ArrayList<EOLock> realLocksAlreadyChecked = new ArrayList<EOLock>();
        HashSet<String> uidsOfCurrentRequest = new HashSet<String>();
        for (EOLock lockToCheck : locksToRelease) {
            String lockToCheckUID = lockToCheck.getUID();
            if (uidsOfCurrentRequest.add(lockToCheckUID)) continue;
            logger.error("Two locks with same lockUID within one request. [LockMgr]");
        }
        for (EOLock lockToCheck : locksToRelease) {
            if (this.lockTable.containsKey((Object)lockToCheck)) {
                LockTableLockInformation lockCacheLockInformation = (LockTableLockInformation)this.lockTable.getByKey((Object)lockToCheck);
                EOLock realServerStoredLock = lockCacheLockInformation.getRealServerStoredLock();
                if (realLocksAlreadyChecked.contains(realServerStoredLock)) continue;
                HashSet<String> uidsInUse = lockCacheLockInformation.getUidsInUse();
                if (!uidsInUse.contains(lockToCheck.getUID())) {
                    logger.error("Lock could not be released because UID referenced in client lock cache doesn't exist in lock cache. [LockMgr]");
                }
                if (uidsOfCurrentRequest.containsAll(uidsInUse)) {
                    locksNeedServerRelease.add((Object)realServerStoredLock);
                }
                realLocksAlreadyChecked.add(realServerStoredLock);
                continue;
            }
            logger.error("Lock to release cannot be found in client lock cache. [LockMgr]");
        }
        HashSet_ extendedUnacknowledgedLocks = new HashSet_(LockHasherByUID.INSTANCE);
        extendedUnacknowledgedLocks.addAll(this.unacknowledgedLocks);
        extendedUnacknowledgedLocks.addAll((ICollection_)locksNeedServerRelease);
        if (!locksNeedServerRelease.isEmpty()) {
            this.lockDBManager.executeAsTransaction(new LockDBManager.IJPATransactionBody((ICollectionRW_)locksNeedServerRelease){
                private final /* synthetic */ ICollectionRW_ val$locksNeedServerRelease;
                {
                    this.val$locksNeedServerRelease = iCollectionRW_;
                }

                @Override
                public void run(EntityManager em) throws Exception {
                    for (EOLock lock : this.val$locksNeedServerRelease) {
                        Query query = em.createNamedQuery("LockModificationElement_degrade_acknowleged_lock_to_unacknowleged");
                        query.setParameter("uid", (Object)lock.getUID());
                        int numberOfUpdatedEntities = query.executeUpdate();
                        if (!$assertionsDisabled && numberOfUpdatedEntities != 1) {
                            throw new AssertionError();
                        }
                    }
                }
            });
        }
        boolean toBeSaved = false;
        for (EOLock releasedLockToNote : locksToRelease) {
            if (!this.noteReleasedLockWithoutSaving(releasedLockToNote)) continue;
            toBeSaved = true;
        }
        assert (toBeSaved != locksNeedServerRelease.isEmpty());
        this.unacknowledgedLocks.clear();
        this.unacknowledgedLocks.addAll((ICollection_)extendedUnacknowledgedLocks);
        if (unacknowledgedLocksExistedBeforeThisMethodCall) {
            throw new ClientLockStateOutOfSyncException("Previous Lock Requests were interrupted - uncertain about their result. Will not try to send further lock requests to the server until this clients lock state is in reconciled with the server.");
        }
        return this.unacknowledgedLocks.asJavaCollection();
    }

    public void finishRequestOfLocks(LockRequestFinishMode lockRequestFinishMode, Collection<EOLock> requestedLocksToNote) throws FileSetTransactionAbortedException {
        assert (lockRequestFinishMode == LockRequestFinishMode.REQUEST_RESPONSE_CYCLE_INTERRUPTED || lockRequestFinishMode == LockRequestFinishMode.SERVER_DENIED_LOCKS || requestedLocksToNote != null);
        if (lockRequestFinishMode == LockRequestFinishMode.NO_SERVER_REQUEST_NEEDED) {
            assert (requestedLocksToNote != null);
            for (EOLock requestedLockToNote : requestedLocksToNote) {
                if (this.noteSuccessfulRequestedLockWithoutSaving(requestedLockToNote)) assert (false);
            }
        } else if (lockRequestFinishMode == LockRequestFinishMode.SERVER_DENIED_LOCKS) {
            assert (!this.unacknowledgedLocks.isEmpty()) : "A server request should not have been issued.";
            this.lockDBManager.executeAsTransaction(new LockDBManager.IJPATransactionBody(){

                @Override
                public void run(EntityManager em) throws Exception {
                    if (!$assertionsDisabled && (Long)em.createNamedQuery("LockModificationElement_count_unacknowleged", Long.class).getSingleResult() != (long)LockAllocationTable.this.unacknowledgedLocks.size()) {
                        throw new AssertionError();
                    }
                    Query query = em.createNamedQuery("LockModificationElement_delete_all_unacknowleged");
                    query.executeUpdate();
                    if (!$assertionsDisabled && (Long)em.createNamedQuery("LockModificationElement_count_unacknowleged", Long.class).getSingleResult() != 0L) {
                        throw new AssertionError();
                    }
                }
            });
            this.unacknowledgedLocks.clear();
        } else if (lockRequestFinishMode == LockRequestFinishMode.SERVER_GRANTED_LOCKS) {
            assert (requestedLocksToNote != null);
            assert (!this.unacknowledgedLocks.isEmpty()) : "A server request should not have been issued.";
            ArrayList_ successfullyAcquiredServerLocks = new ArrayList_(this.unacknowledgedLocks);
            if (!successfullyAcquiredServerLocks.isEmpty()) {
                this.lockDBManager.executeAsTransaction(new LockDBManager.IJPATransactionBody((ICollection_)successfullyAcquiredServerLocks){
                    private final /* synthetic */ ICollection_ val$successfullyAcquiredServerLocks;
                    {
                        this.val$successfullyAcquiredServerLocks = iCollection_;
                    }

                    @Override
                    public void run(EntityManager em) throws Exception {
                        for (EOLock acquiredServerLock : this.val$successfullyAcquiredServerLocks) {
                            Query query = em.createNamedQuery("LockModificationElement_upgrade_unacknowleged_lock_to_acknowleged");
                            query.setParameter("uid", (Object)acquiredServerLock.getUID());
                            int numberOfUpdatedEntities = query.executeUpdate();
                            if (!$assertionsDisabled && numberOfUpdatedEntities != 1) {
                                throw new AssertionError();
                            }
                        }
                    }
                });
            }
            this.unacknowledgedLocks.clear();
            boolean toBeSaved = false;
            for (EOLock requestedLockToNote : requestedLocksToNote) {
                if (!this.noteSuccessfulRequestedLockWithoutSaving(requestedLockToNote)) continue;
                toBeSaved = true;
            }
            assert (toBeSaved == !successfullyAcquiredServerLocks.isEmpty());
        } else assert (lockRequestFinishMode == LockRequestFinishMode.REQUEST_RESPONSE_CYCLE_INTERRUPTED);
    }

    private boolean noteSuccessfulRequestedLockWithoutSaving(EOLock requestedLockToNote) {
        boolean isToBeSaved;
        LockTableLockInformation lockCacheLockInformation = (LockTableLockInformation)this.lockTable.getByKey((Object)requestedLockToNote);
        if (lockCacheLockInformation == null) {
            String lockUID = requestedLockToNote.getUID();
            HashSet<String> uidsInUse = new HashSet<String>();
            uidsInUse.add(lockUID);
            lockCacheLockInformation = new LockTableLockInformation(uidsInUse, requestedLockToNote);
            this.lockTable.put((Object)requestedLockToNote, (Object)lockCacheLockInformation);
            isToBeSaved = true;
        } else {
            HashSet<String> uidsInUse = lockCacheLockInformation.getUidsInUse();
            uidsInUse.add(requestedLockToNote.getUID());
            isToBeSaved = false;
        }
        return isToBeSaved;
    }

    public void finishReleaseOfLocks(Collection<EOLock> successfullyReleasedServerLocks) throws FileSetTransactionAbortedException {
        if (successfullyReleasedServerLocks != null && !successfullyReleasedServerLocks.isEmpty()) {
            assert (successfullyReleasedServerLocks.size() == this.unacknowledgedLocks.size());
            if (!this.unacknowledgedLocks.isEmpty()) {
                this.lockDBManager.executeAsTransaction(new LockDBManager.IJPATransactionBody(){

                    @Override
                    public void run(EntityManager em) throws Exception {
                        if (!$assertionsDisabled && (Long)em.createNamedQuery("LockModificationElement_count_unacknowleged", Long.class).getSingleResult() != (long)LockAllocationTable.this.unacknowledgedLocks.size()) {
                            throw new AssertionError();
                        }
                        Query query = em.createNamedQuery("LockModificationElement_delete_all_unacknowleged");
                        query.executeUpdate();
                        if (!$assertionsDisabled && (Long)em.createNamedQuery("LockModificationElement_count_unacknowleged", Long.class).getSingleResult() != 0L) {
                            throw new AssertionError();
                        }
                    }
                });
                this.unacknowledgedLocks.clear();
            }
        }
    }

    private boolean noteReleasedLockWithoutSaving(EOLock releasedLockToNote) {
        boolean toBeSaved;
        HashSet<Object> uidsInUse = new HashSet();
        if (this.lockTable.containsKey((Object)releasedLockToNote)) {
            LockTableLockInformation lockCacheLockInformation = (LockTableLockInformation)this.lockTable.getByKey((Object)releasedLockToNote);
            uidsInUse = lockCacheLockInformation.getUidsInUse();
        } else {
            logger.error("Release of lock could not be noted in client lock cache because lock doesn't exist in client cache. [LockMgr]");
        }
        if (!uidsInUse.remove(releasedLockToNote.getUID())) {
            logger.error("Release of lock could not be noted in client lock cache because referenced UID doesn't equal UID of lock to release or even is not in referenced UIDs set. [LockMgr]");
        }
        if (uidsInUse.size() == 0) {
            this.lockTable.removeAsEntry((Object)releasedLockToNote);
            toBeSaved = true;
        } else {
            toBeSaved = false;
        }
        return toBeSaved;
    }

    private ISet_<EOLock> getAllAllocatedServerLocks() {
        HashSet_ serverLocks = new HashSet_(LockHasherByUID.INSTANCE);
        for (LockTableLockInformation lockInformation : this.lockTable.values()) {
            serverLocks.add((Object)lockInformation.getRealServerStoredLock());
        }
        return serverLocks;
    }

    public ISet_<EOLock> getLocksCurrentlyAllocatedByLockAllocator() {
        return this.getAllAllocatedServerLocks();
    }

    public boolean clientAlreadyHasLock(EOLock lockToCheck) {
        return this.lockTable.containsKey((Object)lockToCheck);
    }

    public Collection<EOLock> getLocksClientAlreadyOwnsMatchingThisLocks(Collection<EOLock> locksToBeChecked) {
        ArrayList<EOLock> matchingLocks = new ArrayList<EOLock>();
        for (EOLock currentLock : locksToBeChecked) {
            matchingLocks.addAll(this.getLocksClientAlreadyOwnsMatchingThisLock(currentLock));
        }
        return matchingLocks;
    }

    public Collection<EOLock> getLocksClientAlreadyOwnsMatchingThisLock(EOLock lockToBeChecked) {
        ArrayList<EOLock> matchingLocks = new ArrayList<EOLock>();
        if (this.lockTable.containsKey((Object)lockToBeChecked)) {
            LockTableLockInformation lockCacheLockInformation = (LockTableLockInformation)this.lockTable.getByKey((Object)lockToBeChecked);
            matchingLocks.add(lockCacheLockInformation.getRealServerStoredLock());
        }
        return matchingLocks;
    }

    public Collection<EOLock> findClientLocksByLockData(String lockTypeID, String lockedItemTypeID, String lockedItemUID, IFrameProjectAgent projectAgent) {
        ArrayList<EOLock> locksToRelease = null;
        EOLock matchingLock = null;
        for (LockTableLockInformation currentLockInformation : this.lockTable.values()) {
            EOLock eoLockToCompare = currentLockInformation.getRealServerStoredLock();
            if (!eoLockToCompare.getLockTypeID().equals(lockTypeID) || !eoLockToCompare.getLockedItemType().equals(lockedItemTypeID) || !eoLockToCompare.getLockedItemUID().equals(lockedItemUID)) continue;
            matchingLock = eoLockToCompare;
        }
        if (matchingLock != null) {
            locksToRelease = new ArrayList<EOLock>();
            LockTableLockInformation lockCacheLockinformation = (LockTableLockInformation)this.lockTable.getByKey(matchingLock);
            HashSet<String> uidsInUse = lockCacheLockinformation.getUidsInUse();
            for (String lockUID : uidsInUse) {
                locksToRelease.add(new EOLock(lockUID, projectAgent.getProjectUID(), lockTypeID, lockedItemUID, lockedItemTypeID, "", "", matchingLock.getCreationTime()));
            }
        }
        return locksToRelease;
    }

    public void successfullyReleasedUnacknowledgedLocks() throws FileSetTransactionAbortedException {
        assert (!this.unacknowledgedLocks.isEmpty());
        this.lockDBManager.executeAsTransaction(new LockDBManager.IJPATransactionBody(){

            @Override
            public void run(EntityManager em) throws Exception {
                if (!$assertionsDisabled && (Long)em.createNamedQuery("LockModificationElement_count_unacknowleged", Long.class).getSingleResult() != (long)LockAllocationTable.this.unacknowledgedLocks.size()) {
                    throw new AssertionError();
                }
                Query query = em.createNamedQuery("LockModificationElement_delete_all_unacknowleged");
                query.executeUpdate();
                if (!$assertionsDisabled && (Long)em.createNamedQuery("LockModificationElement_count_unacknowleged", Long.class).getSingleResult() != 0L) {
                    throw new AssertionError();
                }
            }
        });
        this.unacknowledgedLocks.clear();
    }

    public Collection<EOLock> getUnacknowledgedLocks() {
        return new ArrayList<EOLock>(this.unacknowledgedLocks.asJavaCollection());
    }

    public void destruct() {
        this.lockDBManager.destruct();
    }

    public static enum LockRequestFinishMode {
        NO_SERVER_REQUEST_NEEDED,
        SERVER_GRANTED_LOCKS,
        SERVER_DENIED_LOCKS,
        REQUEST_RESPONSE_CYCLE_INTERRUPTED;

    }
}

