/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links;

import com.arcway.cockpit.client.base.datamanager.AbstractDifferentialModificationManager;
import com.arcway.cockpit.client.base.datamanager.AtomicModificationDataAccessor;
import com.arcway.cockpit.client.base.datamanager.IModificationEntityProvider;
import com.arcway.cockpit.cockpitlib.client.data.jpa.JPAEOCoDec;
import com.arcway.cockpit.cockpitlib.client.data.jpa.LinkModificationLink;
import com.arcway.cockpit.cockpitlib.client.data.jpa.LinkModificationLinkedItemDeletion;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkModificationContainer;
import com.arcway.cockpit.frame.shared.message.EOLinkedItemDeletion;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.java.ObjectWrapper;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DifferentialLinkModLogAccessManager {
    private final AtomicModificationDataAccessor atomicModificationDataAccessor;
    private final HashMap<String, LinkModificationLink> existingLinkElementsToDelete = new HashMap();
    private final HashMap<String, LinkEntityProvider> newLinkElementsToAdd = new HashMap();
    private final HashMap<String, LinkModificationLinkedItemDeletion> existingItemDeletionElementsToDelete = new HashMap();
    private final HashMap<String, ItemDeletionEntityProvider> newItemDeletionElementsToAdd = new HashMap();
    public final ManagedSet<EOLink> linkAdditions;
    public final ManagedSet<EOLink> linkDeletions;
    public final ManagedSet<EOLinkedItemDeletion> deletedLinkedItems;

    public DifferentialLinkModLogAccessManager(AtomicModificationDataAccessor atomicModificationDataAccessor) {
        this.atomicModificationDataAccessor = atomicModificationDataAccessor;
        final ManagedSet_EOLink _linkAdditions = new ManagedSet_EOLink('a');
        final ManagedSet_EOLink _linkDeletions = new ManagedSet_EOLink('r');
        atomicModificationDataAccessor.registerDifferentialModificationManager((AbstractDifferentialModificationManager)new AbstractDifferentialModificationManager<LinkModificationLink, String>(LinkModificationLink.class, LinkModificationLink.class){

            public void reconstructModificationElements() {
                _linkAdditions.reconstructDiskStateFromInMemoryState();
                _linkDeletions.reconstructDiskStateFromInMemoryState();
            }

            public void handOverModificationUpdates(AtomicModificationDataAccessor.ModificationUpdatesForEntityClass<LinkModificationLink, String> modificationUpdates) {
                modificationUpdates.addUpdates(DifferentialLinkModLogAccessManager.this.existingLinkElementsToDelete, DifferentialLinkModLogAccessManager.this.newLinkElementsToAdd);
                DifferentialLinkModLogAccessManager.this.existingLinkElementsToDelete.clear();
                DifferentialLinkModLogAccessManager.this.newLinkElementsToAdd.clear();
            }
        });
        this.linkAdditions = _linkAdditions;
        this.linkDeletions = _linkDeletions;
        final ManagedSet_EOLinkedItemDeletion _deletedLinkedItems = new ManagedSet_EOLinkedItemDeletion();
        atomicModificationDataAccessor.registerDifferentialModificationManager((AbstractDifferentialModificationManager)new AbstractDifferentialModificationManager<LinkModificationLinkedItemDeletion, String>(LinkModificationLinkedItemDeletion.class, LinkModificationLinkedItemDeletion.class){

            public void reconstructModificationElements() {
                _deletedLinkedItems.reconstructDiskStateFromInMemoryState();
            }

            public void handOverModificationUpdates(AtomicModificationDataAccessor.ModificationUpdatesForEntityClass<LinkModificationLinkedItemDeletion, String> modificationUpdates) {
                modificationUpdates.addUpdates(DifferentialLinkModLogAccessManager.this.existingItemDeletionElementsToDelete, DifferentialLinkModLogAccessManager.this.newItemDeletionElementsToAdd);
                DifferentialLinkModLogAccessManager.this.existingItemDeletionElementsToDelete.clear();
                DifferentialLinkModLogAccessManager.this.newItemDeletionElementsToAdd.clear();
            }
        });
        this.deletedLinkedItems = _deletedLinkedItems;
    }

    public EOLinkModificationContainer readSavedModifications(final String projectUID, final IEncodableObjectFactory messageDataFactory) throws AtomicModificationDataAccessor.ModificationBootstrapFailure {
        assert (this.existingLinkElementsToDelete.isEmpty() && this.newLinkElementsToAdd.isEmpty() && this.existingItemDeletionElementsToDelete.isEmpty() && this.newItemDeletionElementsToAdd.isEmpty()) : "might be ok but is currently not expected.";
        final ObjectWrapper result = new ObjectWrapper(null);
        this.atomicModificationDataAccessor.bootstrapModificationData(new AtomicModificationDataAccessor.IBootstrapModificationAccessor(){
            private final XMLDecoder xmlDecoder = new XMLDecoder();

            public void run(EntityManager em) throws Exception {
                EOLinkModificationContainer container = new EOLinkModificationContainer(projectUID);
                container.setInsertLinks(this.readSavedLinksOfModType(em, 'a'));
                container.setDeleteLinks(this.readSavedLinksOfModType(em, 'r'));
                container.setDeletedLinkedItems(this.readSavedLinkedItemDeletions(em));
                result.setWrappedObject((Object)container);
            }

            private List<EOLinkedItemDeletion> readSavedLinkedItemDeletions(EntityManager em) throws EXDecoderException {
                Query dataQuery = em.createNamedQuery("LinkModificationLinkedItemDeletion_readAllModificationData");
                ArrayList<EOLinkedItemDeletion> resultlist = new ArrayList<EOLinkedItemDeletion>();
                this.readEOsByIDs(dataQuery, resultlist);
                return resultlist;
            }

            private List<EOLink> readSavedLinksOfModType(EntityManager em, char modType) throws EXDecoderException {
                Query dataQuery = em.createNamedQuery("LinkModificationLink_readModificationDataByModType");
                dataQuery.setParameter("modType", (Object)Character.valueOf(modType));
                ArrayList<EOLink> resultlist = new ArrayList<EOLink>();
                this.readEOsByIDs(dataQuery, resultlist);
                return resultlist;
            }

            private <T_EO> void readEOsByIDs(Query dataQuery, final List<T_EO> resultlist) throws EXDecoderException {
                dataQuery.setFlushMode(FlushModeType.COMMIT);
                JPAEOCoDec.executeQueryAndProcessResultUsingCursoredStream((Query)dataQuery, (int)20, (JPAEOCoDec.ResultConsumer)new JPAEOCoDec.ResultConsumer(){

                    public void consume(Object rowData) throws EXDecoderException {
                        String xmlData = (String)rowData;
                        EncodableObjectBase eo = JPAEOCoDec.convertXmlStringToNewEO((String)xmlData, (XMLDecoder)xmlDecoder, (IEncodableObjectFactory)messageDataFactory);
                        resultlist.add(eo);
                    }
                });
            }
        });
        return (EOLinkModificationContainer)result.getWrappedObject();
    }

    public void deleteSavedModifications() {
        assert (this.existingLinkElementsToDelete.isEmpty() && this.newLinkElementsToAdd.isEmpty() && this.existingItemDeletionElementsToDelete.isEmpty() && this.newItemDeletionElementsToAdd.isEmpty()) : "might be ok but is currently not expected.";
        this.atomicModificationDataAccessor.prepareModificationDataUpdate(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

            public void run(EntityManager em) throws Exception {
                char[] cArray = new char[]{'a', 'r'};
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char modType = cArray[n2];
                    TypedQuery query = em.createNamedQuery("LinkModificationLink_deleteAllOfModType", LinkModificationLink.class);
                    query.setParameter("modType", (Object)Character.valueOf(modType));
                    query.executeUpdate();
                    ++n2;
                }
                TypedQuery query = em.createNamedQuery("LinkModificationLinkedItemDeletion_deleteAll", LinkModificationLinkedItemDeletion.class);
                query.executeUpdate();
                em.flush();
            }
        });
    }

    public static class ItemDeletionEntityProvider
    implements IModificationEntityProvider<LinkModificationLinkedItemDeletion> {
        private final EOLinkedItemDeletion linkedItemDeletion;

        public ItemDeletionEntityProvider(EOLinkedItemDeletion item) {
            this.linkedItemDeletion = item;
        }

        public LinkModificationLinkedItemDeletion createModificationEntity() throws EXEncoderException {
            return new LinkModificationLinkedItemDeletion(this.linkedItemDeletion.getLinkedItemUID(), (EncodableObjectBase)this.linkedItemDeletion);
        }
    }

    public static class LinkEntityProvider
    implements IModificationEntityProvider<LinkModificationLink> {
        private final char modType;
        private final EOLink link;

        public LinkEntityProvider(char modType, EOLink item) {
            this.modType = modType;
            this.link = item;
        }

        public LinkModificationLink createModificationEntity() throws EXEncoderException {
            return new LinkModificationLink(this.link.getUID(), this.modType, (EncodableObjectBase)this.link);
        }

        public char getModType() {
            return this.modType;
        }
    }

    public static abstract class ManagedSet<E> {
        final HashMap<E, E> setStore = new HashMap();
        final Set<E> readonlyView = Collections.unmodifiableSet(this.setStore.keySet());

        public abstract boolean remove(E var1);

        public abstract boolean add(E var1);

        public boolean isEmpty() {
            return this.setStore.isEmpty();
        }

        public int size() {
            return this.setStore.size();
        }

        public boolean contains(Object o) {
            return this.setStore.containsKey(o);
        }

        public abstract void clear();

        public Set<E> getReadonlyView() {
            return this.readonlyView;
        }
    }

    public class ManagedSet_EOLink
    extends ManagedSet<EOLink> {
        private final char modType;

        public ManagedSet_EOLink(char modType) {
            this.modType = modType;
        }

        @Override
        public boolean remove(EOLink link) {
            assert (link != null);
            final EOLink removedLink = (EOLink)this.setStore.remove(link);
            if (removedLink != null) {
                DifferentialLinkModLogAccessManager.this.atomicModificationDataAccessor.prepareModificationDataUpdate(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

                    public void run(EntityManager em) throws Exception {
                        String removedLinkUid = removedLink.getUID();
                        LinkEntityProvider canceledAddition = (LinkEntityProvider)DifferentialLinkModLogAccessManager.this.newLinkElementsToAdd.remove(removedLinkUid);
                        if (canceledAddition == null) {
                            LinkModificationLink elementToRemove = (LinkModificationLink)em.find(LinkModificationLink.class, (Object)removedLinkUid);
                            if (!$assertionsDisabled && elementToRemove == null) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && elementToRemove.getModType() != ManagedSet_EOLink.this.modType) {
                                throw new AssertionError();
                            }
                            LinkModificationLink previousValue = DifferentialLinkModLogAccessManager.this.existingLinkElementsToDelete.put(removedLinkUid, elementToRemove);
                            if (!$assertionsDisabled && previousValue != null) {
                                throw new AssertionError();
                            }
                        } else {
                            if (!$assertionsDisabled && canceledAddition == null) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && canceledAddition.getModType() != ManagedSet_EOLink.this.modType) {
                                throw new AssertionError();
                            }
                        }
                    }
                });
            }
            return removedLink != null;
        }

        @Override
        public boolean add(final EOLink link) {
            assert (link != null);
            EOLink previousValue = this.setStore.put(link, link);
            if (previousValue != null) {
                this.setStore.put(previousValue, previousValue);
            } else {
                DifferentialLinkModLogAccessManager.this.atomicModificationDataAccessor.prepareModificationDataUpdate(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

                    public void run(EntityManager em) throws Exception {
                        String linkUid = link.getUID();
                        if (!$assertionsDisabled && !DifferentialLinkModLogAccessManager.this.existingLinkElementsToDelete.containsKey(linkUid) && em.find(LinkModificationLink.class, (Object)linkUid) != null) {
                            throw new AssertionError();
                        }
                        LinkEntityProvider linkEntityProvider = new LinkEntityProvider(ManagedSet_EOLink.this.modType, link);
                        LinkEntityProvider previousVal = DifferentialLinkModLogAccessManager.this.newLinkElementsToAdd.put(linkUid, linkEntityProvider);
                        if (!$assertionsDisabled && previousVal != null) {
                            throw new AssertionError();
                        }
                    }
                });
            }
            return previousValue == null;
        }

        @Override
        public void clear() {
            this.setStore.clear();
            DifferentialLinkModLogAccessManager.this.atomicModificationDataAccessor.prepareModificationDataUpdate(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

                public void run(EntityManager em) throws Exception {
                    ManagedSet_EOLink.this.removeAllDiskElements(em);
                }
            });
        }

        public void reconstructDiskStateFromInMemoryState() {
            DifferentialLinkModLogAccessManager.this.atomicModificationDataAccessor.prepareModificationDataUpdate(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

                public void run(EntityManager em) throws Exception {
                    ManagedSet_EOLink.this.removeAllDiskElements(em);
                    for (EOLink link : ManagedSet_EOLink.this.setStore.values()) {
                        LinkEntityProvider linkEntityProvider = new LinkEntityProvider(ManagedSet_EOLink.this.modType, link);
                        LinkEntityProvider previousVal = DifferentialLinkModLogAccessManager.this.newLinkElementsToAdd.put(link.getUID(), linkEntityProvider);
                        if (!$assertionsDisabled && previousVal != null) {
                            throw new AssertionError();
                        }
                    }
                }
            });
        }

        private void removeAllDiskElements(EntityManager em) {
            Iterator iterator = DifferentialLinkModLogAccessManager.this.newLinkElementsToAdd.entrySet().iterator();
            while (iterator.hasNext()) {
                LinkEntityProvider linkEntityProvider = (LinkEntityProvider)iterator.next().getValue();
                if (linkEntityProvider.getModType() != this.modType) continue;
                assert (false);
                iterator.remove();
            }
            iterator = DifferentialLinkModLogAccessManager.this.existingLinkElementsToDelete.entrySet().iterator();
            while (iterator.hasNext()) {
                LinkModificationLink linkModificationLink = (LinkModificationLink)iterator.next().getValue();
                if (linkModificationLink.getModType() != this.modType) continue;
                iterator.remove();
            }
            TypedQuery query = em.createNamedQuery("LinkModificationLink_deleteAllOfModType", LinkModificationLink.class);
            query.setParameter("modType", (Object)Character.valueOf(this.modType));
            query.executeUpdate();
            em.flush();
        }
    }

    public class ManagedSet_EOLinkedItemDeletion
    extends ManagedSet<EOLinkedItemDeletion> {
        @Override
        public boolean remove(EOLinkedItemDeletion linkedItemDeletion) {
            assert (linkedItemDeletion != null);
            final EOLinkedItemDeletion removedLinkedItemDeletion = (EOLinkedItemDeletion)this.setStore.remove(linkedItemDeletion);
            if (removedLinkedItemDeletion != null) {
                DifferentialLinkModLogAccessManager.this.atomicModificationDataAccessor.prepareModificationDataUpdate(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

                    public void run(EntityManager em) throws Exception {
                        String removedLinkedItemUID = removedLinkedItemDeletion.getLinkedItemUID();
                        ItemDeletionEntityProvider canceledAddition = (ItemDeletionEntityProvider)DifferentialLinkModLogAccessManager.this.newItemDeletionElementsToAdd.remove(removedLinkedItemUID);
                        if (canceledAddition == null) {
                            LinkModificationLinkedItemDeletion elementToRemove = (LinkModificationLinkedItemDeletion)em.find(LinkModificationLinkedItemDeletion.class, (Object)removedLinkedItemUID);
                            if (!$assertionsDisabled && elementToRemove == null) {
                                throw new AssertionError();
                            }
                            LinkModificationLinkedItemDeletion previousValue = DifferentialLinkModLogAccessManager.this.existingItemDeletionElementsToDelete.put(removedLinkedItemUID, elementToRemove);
                            if (!$assertionsDisabled && previousValue != null) {
                                throw new AssertionError();
                            }
                        } else if (!$assertionsDisabled && canceledAddition == null) {
                            throw new AssertionError();
                        }
                    }
                });
            }
            return removedLinkedItemDeletion != null;
        }

        @Override
        public boolean add(final EOLinkedItemDeletion linkedItemDeletion) {
            assert (linkedItemDeletion != null);
            EOLinkedItemDeletion previousValue = this.setStore.put(linkedItemDeletion, linkedItemDeletion);
            if (previousValue != null) {
                this.setStore.put(previousValue, previousValue);
            } else {
                DifferentialLinkModLogAccessManager.this.atomicModificationDataAccessor.prepareModificationDataUpdate(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

                    public void run(EntityManager em) throws Exception {
                        String linkedItemUID = linkedItemDeletion.getLinkedItemUID();
                        if (!$assertionsDisabled && !DifferentialLinkModLogAccessManager.this.existingItemDeletionElementsToDelete.containsKey(linkedItemUID) && em.find(LinkModificationLinkedItemDeletion.class, (Object)linkedItemUID) != null) {
                            throw new AssertionError();
                        }
                        ItemDeletionEntityProvider itemDeletionEntityProvider = new ItemDeletionEntityProvider(linkedItemDeletion);
                        DifferentialLinkModLogAccessManager.this.newItemDeletionElementsToAdd.put(linkedItemUID, itemDeletionEntityProvider);
                    }
                });
            }
            return previousValue == null;
        }

        @Override
        public void clear() {
            this.setStore.clear();
            DifferentialLinkModLogAccessManager.this.atomicModificationDataAccessor.prepareModificationDataUpdate(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

                public void run(EntityManager em) throws Exception {
                    if (!($assertionsDisabled || DifferentialLinkModLogAccessManager.this.existingItemDeletionElementsToDelete.isEmpty() && DifferentialLinkModLogAccessManager.this.newItemDeletionElementsToAdd.isEmpty())) {
                        throw new AssertionError();
                    }
                    ManagedSet_EOLinkedItemDeletion.this.removeAllDiskElements(em);
                }
            });
        }

        public void reconstructDiskStateFromInMemoryState() {
            DifferentialLinkModLogAccessManager.this.atomicModificationDataAccessor.prepareModificationDataUpdate(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

                public void run(EntityManager em) throws Exception {
                    ManagedSet_EOLinkedItemDeletion.this.removeAllDiskElements(em);
                    for (EOLinkedItemDeletion linkedItemDeletion : ManagedSet_EOLinkedItemDeletion.this.setStore.values()) {
                        ItemDeletionEntityProvider itemDeletionEntityProvider = new ItemDeletionEntityProvider(linkedItemDeletion);
                        DifferentialLinkModLogAccessManager.this.newItemDeletionElementsToAdd.put(linkedItemDeletion.getLinkedItemUID(), itemDeletionEntityProvider);
                    }
                }
            });
        }

        private void removeAllDiskElements(EntityManager em) {
            DifferentialLinkModLogAccessManager.this.newItemDeletionElementsToAdd.clear();
            DifferentialLinkModLogAccessManager.this.existingItemDeletionElementsToDelete.clear();
            TypedQuery query = em.createNamedQuery("LinkModificationLinkedItemDeletion_deleteAll", LinkModificationLinkedItemDeletion.class);
            query.executeUpdate();
            em.flush();
        }
    }
}

