/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.ValueRangeEnumeration;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.ValueRangeDefinerEnumeration;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.AttributeEnumerationFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.EnumerationAttributeFilter;
import com.arcway.cockpit.frame.shared.message.EOContainer;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.java.tuples.Tuple;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class DataTypeEnumerationNEW
extends AbstractDataType {
    private final IAttributeTypeDataType baseDataType;
    private final ValueRangeDefinerEnumeration valueRangeHelper;
    private final boolean multipleSelection;
    private String id;

    public DataTypeEnumerationNEW(IAttributeTypeDataType baseDataType, IValueRange baseValueRange, boolean multipleSelection, boolean tolerantConcerningValueRange) {
        assert (!tolerantConcerningValueRange || multipleSelection);
        this.baseDataType = baseDataType;
        this.multipleSelection = multipleSelection;
        this.valueRangeHelper = new ValueRangeDefinerEnumeration(baseDataType, baseValueRange, tolerantConcerningValueRange);
        this.id = "enumeration_" + baseDataType.getID();
        this.id = multipleSelection ? String.valueOf(this.id) + "_multiple" : String.valueOf(this.id) + "_single";
    }

    public List<EnumerationEntry> getEnumerationEntries(Object value) {
        return (List)value;
    }

    public String getID() {
        return this.id;
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        if (value instanceof List) {
            return this.getValueRangeHelper().isInValueRange(value, valueRange);
        }
        return false;
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        if (!this.supportsValue(originalValue, valueRange)) {
            throw new ExInvalidDataType(originalValue.getClass().toString(), "Collection with entries in value range");
        }
        List originalCollection = (List)originalValue;
        ArrayList<EnumerationEntry> copyCollection = new ArrayList<EnumerationEntry>();
        for (Object o : originalCollection) {
            if (!(o instanceof EnumerationEntry)) {
                throw new ExInvalidDataType(o.getClass().toString(), EnumerationEntry.class.toString());
            }
            EnumerationEntry originalEntry = (EnumerationEntry)o;
            Object copyValue = this.baseDataType.getCopy(originalEntry.getValue(), null);
            EnumerationEntry copyEntry = new EnumerationEntry(originalEntry.getID(), copyValue);
            copyCollection.add(copyEntry);
        }
        return copyCollection;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        if (this.multipleSelection) {
            return String.valueOf(Messages.getString("DataTypeMultipleEnumeration.multiple_selection_of", locale)) + this.baseDataType.getDisplayName();
        }
        return String.valueOf(Messages.getString("DataTypeEnumeration.enumeration_of", locale)) + this.baseDataType.getDisplayName();
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) {
        if (!(value instanceof List)) {
            throw new ExInvalidDataType(value.getClass().toString(), List.class.toString());
        }
        List entries = (List)value;
        ValueRangeEnumeration valueRange = new ValueRangeEnumeration(entries);
        EOEncodableObject eoList = this.valueRangeHelper.getValueAsEO(valueRange, baseValueRange);
        return eoList;
    }

    public Object getEOAsValue(EOEncodableObject eo) {
        if (!(eo instanceof EOList)) {
            throw new ExInvalidDataType(eo.getClass().toString(), EOList.class.toString());
        }
        ArrayList<EnumerationEntry> entries = new ArrayList<EnumerationEntry>();
        EOList eoList = (EOList)eo;
        for (EOContainer eoContainer : eoList) {
            Object value = this.baseDataType.getEOAsValue(eoContainer.getContent());
            EnumerationEntry entry = new EnumerationEntry(eoContainer.getRole(), value);
            entries.add(entry);
        }
        return entries;
    }

    public Object getDefaultValue() {
        return Collections.EMPTY_LIST;
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) {
        if (!(value instanceof List)) {
            throw new ExInvalidDataType(value.getClass().toString(), List.class.toString());
        }
        Object vr = valueRange.getValueRange();
        if (!(vr instanceof List)) {
            throw new ExInvalidDataType(vr.getClass().toString(), List.class.toString());
        }
        List allowedValues = (List)vr;
        List selectedElements = (List)value;
        CompositeForViewing compositeForViewing = new CompositeForViewing(parent, 0);
        compositeForViewing.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        compositeForViewing.setLayout((Layout)gridLayout);
        for (EnumerationEntry entry : allowedValues) {
            if (!selectedElements.contains(entry)) continue;
            Control control = this.baseDataType.createSWTControlForViewing((Composite)compositeForViewing, entry.getValue(), null);
            compositeForViewing.addChildControl(control);
        }
        return compositeForViewing;
    }

    public ValueRangeDefinerEnumeration getValueRangeHelper() {
        return this.valueRangeHelper;
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        String valueAsSingleLineString;
        assert (valueRange instanceof ValueRangeEnumeration);
        if (!(value instanceof List)) {
            throw new ExInvalidDataType(value.getClass().toString(), List.class.toString());
        }
        List selectedElements = (List)value;
        if (selectedElements.isEmpty()) {
            valueAsSingleLineString = "";
        } else if (selectedElements.size() == 1) {
            LinkedHashMap<EnumerationEntry, Tuple<Integer, EnumerationEntry>> valueRangeMap = ((ValueRangeEnumeration)valueRange).getValueRange_opt();
            Tuple<Integer, EnumerationEntry> ordinalAndEnumerationEntry = valueRangeMap.get(selectedElements.get(0));
            if (ordinalAndEnumerationEntry != null) {
                valueAsSingleLineString = this.baseDataType.getValueAsSingleLineString(((EnumerationEntry)ordinalAndEnumerationEntry.getT2()).getValue(), null, separator, locale);
            } else {
                assert (false);
                valueAsSingleLineString = "";
            }
        } else {
            LinkedHashMap<EnumerationEntry, Tuple<Integer, EnumerationEntry>> valueRangeMap = ((ValueRangeEnumeration)valueRange).getValueRange_opt();
            EnumerationEntry[] validSelectedElementsInCorrectOrder = new EnumerationEntry[valueRangeMap.size()];
            for (Object selectedElement : selectedElements) {
                Tuple<Integer, EnumerationEntry> ordinalAndEnumerationEntry = valueRangeMap.get(selectedElement);
                if (ordinalAndEnumerationEntry != null) {
                    int ordinal = (Integer)ordinalAndEnumerationEntry.getT1();
                    assert (validSelectedElementsInCorrectOrder[ordinal] == null);
                    validSelectedElementsInCorrectOrder[ordinal] = (EnumerationEntry)ordinalAndEnumerationEntry.getT2();
                    continue;
                }
                assert (false);
            }
            StringBuilder valueAsSingleLineBuilder = new StringBuilder();
            boolean isFirst = true;
            EnumerationEntry[] enumerationEntryArray = validSelectedElementsInCorrectOrder;
            int n = validSelectedElementsInCorrectOrder.length;
            int n2 = 0;
            while (n2 < n) {
                EnumerationEntry selectedElement = enumerationEntryArray[n2];
                if (selectedElement != null) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        valueAsSingleLineBuilder.append(separator);
                    }
                    valueAsSingleLineBuilder.append(this.baseDataType.getValueAsSingleLineString(selectedElement.getValue(), null, separator, locale));
                }
                ++n2;
            }
            valueAsSingleLineString = valueAsSingleLineBuilder.toString();
        }
        return valueAsSingleLineString;
    }

    @Override
    public List<String> getValueAsStrings(Object value, IValueRange valueRange, Locale locale) {
        List allElements = (List)valueRange.getValueRange();
        List selectedElements = (List)value;
        ArrayList<String> strings = new ArrayList<String>();
        for (EnumerationEntry entry : allElements) {
            if (!selectedElements.contains(entry)) continue;
            strings.addAll(this.baseDataType.getValueAsStrings(entry.getValue(), null, locale));
        }
        return strings;
    }

    public IAttributeTypeDataType getBaseDataType() {
        return this.baseDataType;
    }

    @Override
    public IFilterItem createFilterItem(String filterName, AbstractFilter filter, IValueRange vaueRange) {
        return new AttributeEnumerationFilterItem(filterName, filter, this, this.baseDataType, vaueRange);
    }

    @Override
    public IAttributeFilter getFilter() {
        return EnumerationAttributeFilter.getDefault();
    }

    public Comparator getComparator(IValueRange valueRange) {
        final IValueRange _vr = valueRange;
        if (!this.multipleSelection) {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    Iterator i1 = ((Collection)o1).iterator();
                    Iterator i2 = ((Collection)o2).iterator();
                    if (i1.hasNext()) {
                        if (i2.hasNext()) {
                            EnumerationEntry e1 = (EnumerationEntry)i1.next();
                            EnumerationEntry e2 = (EnumerationEntry)i2.next();
                            List valueRangeList = (List)_vr.getValueRange();
                            return valueRangeList.indexOf(e1) - valueRangeList.indexOf(e2);
                        }
                        return 1;
                    }
                    return -1;
                }
            };
        }
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                EnumerationEntry entry;
                Collection c1 = (Collection)o1;
                Collection c2 = (Collection)o2;
                int[] values1 = new int[c1.size()];
                int[] values2 = new int[c2.size()];
                Arrays.sort(values1);
                Arrays.sort(values2);
                List valueRangeList = (List)_vr.getValueRange();
                Iterator i = c1.iterator();
                int counter = 0;
                while (i.hasNext()) {
                    entry = (EnumerationEntry)i.next();
                    values1[counter] = valueRangeList.indexOf(entry);
                    ++counter;
                }
                i = c2.iterator();
                counter = 0;
                while (i.hasNext()) {
                    entry = (EnumerationEntry)i.next();
                    values2[counter] = valueRangeList.indexOf(entry);
                    ++counter;
                }
                counter = 0;
                while (counter < Math.min(values1.length, values2.length)) {
                    int compare = values1[counter] - values2[counter];
                    if (compare != 0) {
                        return compare;
                    }
                    ++counter;
                }
                return values1.length - values2.length;
            }
        };
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    public Object mapValue(Object value, IValueRange valueRange) {
        if (!(valueRange.getValueRange() instanceof List)) {
            throw new ExInvalidDataType(valueRange.getClass().toString(), List.class.toString());
        }
        if (!(value instanceof List)) {
            return null;
        }
        if (!this.multipleSelection && ((List)value).size() > 1) {
            return null;
        }
        LinkedList<EnumerationEntry> newValue = new LinkedList<EnumerationEntry>();
        for (Object enumValueAsObject : (List)value) {
            if (!(enumValueAsObject instanceof EnumerationEntry)) continue;
            EnumerationEntry enumValue = (EnumerationEntry)enumValueAsObject;
            EnumerationEntry bestMatch = this.getValueRangeHelper().getBestMatch(enumValue, valueRange);
            if (bestMatch == null) continue;
            newValue.add(bestMatch);
        }
        if (!newValue.isEmpty()) {
            return newValue;
        }
        return null;
    }

    private class CompositeForViewing
    extends Composite {
        private final Collection childControls;

        public CompositeForViewing(Composite parent, int style) {
            super(parent, style);
            this.childControls = new ArrayList();
        }

        public void addChildControl(Control control) {
            this.childControls.add(control);
        }

        public void setFont(Font font) {
            super.setFont(font);
            for (Control control : this.childControls) {
                control.setFont(font);
            }
        }
    }
}

