/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.lib.java.tuples.Tuple;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ValueRangeEnumeration
implements IValueRange {
    private final ArrayList<EnumerationEntry> entries;
    private final LinkedHashMap<EnumerationEntry, Tuple<Integer, EnumerationEntry>> valueRangeMap;

    public ValueRangeEnumeration(List<EnumerationEntry> entries) {
        this.entries = new ArrayList<EnumerationEntry>(entries);
        this.valueRangeMap = ValueRangeEnumeration.calculateValueRangeMap(entries);
    }

    public List<? extends EnumerationEntry> getValueRange() {
        assert (this.entries.size() == this.valueRangeMap.size());
        return this.entries;
    }

    public LinkedHashMap<EnumerationEntry, Tuple<Integer, EnumerationEntry>> getValueRange_opt() {
        assert (this.entries.size() == this.valueRangeMap.size());
        return this.valueRangeMap;
    }

    private static LinkedHashMap<EnumerationEntry, Tuple<Integer, EnumerationEntry>> calculateValueRangeMap(List<EnumerationEntry> entries) {
        LinkedHashMap<EnumerationEntry, Tuple<Integer, EnumerationEntry>> valueRange = new LinkedHashMap<EnumerationEntry, Tuple<Integer, EnumerationEntry>>(entries.size() * 2);
        int ordinal = 0;
        for (EnumerationEntry entry : entries) {
            valueRange.put(entry, (Tuple<Integer, EnumerationEntry>)new Tuple((Object)ordinal, (Object)entry));
            ++ordinal;
        }
        return valueRange;
    }
}

