/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.To;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAttributeOwner
implements IAttributeOwnerRW {
    private static final ILogger logger = Logger.getLogger(AbstractFrameData.class);
    private String uID;
    private String projectUID;
    private final String cockpitDataType;
    private final Map<IAttributeTypeID, IAttribute> attributes;
    private final IAttributeTypesProvider attributeTypeProvider;
    private IAttributeModificationManager modificationManager;
    private final int modCount;
    private final int commitCount;
    private int cachedHashcode;

    public AbstractAttributeOwner(String uID, String projectUID, String cockpitDataType, Collection<IAttribute> attributes, IAttributeTypesProvider attributeTypeProvider, IAttributeModificationManager modificationManager) {
        assert (modificationManager != null);
        assert (cockpitDataType.length() < 129);
        this.setUIDAndUpdateHashcode(uID);
        this.projectUID = projectUID;
        this.cockpitDataType = cockpitDataType;
        this.modificationManager = modificationManager;
        this.attributeTypeProvider = attributeTypeProvider;
        this.modCount = 0;
        this.commitCount = 0;
        this.attributes = new HashMap<IAttributeTypeID, IAttribute>();
        for (IAttribute attribute : attributes) {
            this.simplySetAttribute(attribute);
        }
    }

    public AbstractAttributeOwner(String uID, String projectUID, int modCount, int commitCount, String cockpitDataTypeID, Collection<EOAttribute> attributes, IAttributeModificationManager attributeModificationManager, IFrameProjectAgent projectAgent) {
        this.setUIDAndUpdateHashcode(uID);
        this.projectUID = projectUID;
        this.cockpitDataType = cockpitDataTypeID;
        this.attributeTypeProvider = projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(cockpitDataTypeID);
        this.modificationManager = attributeModificationManager;
        this.modCount = modCount;
        this.commitCount = commitCount;
        this.attributes = new HashMap<IAttributeTypeID, IAttribute>(attributes.size() * 2);
        for (EOAttribute eoAttribute : attributes) {
            IAttribute attribute = this.getAttribute(eoAttribute);
            if (attribute == null) continue;
            this.simplySetAttribute(attribute);
        }
    }

    protected void setUID(String uID) {
        this.setUIDAndUpdateHashcode(uID);
    }

    private void setUIDAndUpdateHashcode(String uID) {
        this.uID = uID;
        this.cachedHashcode = uID.hashCode();
    }

    protected void setProjectUID(String projectUID) {
        this.projectUID = projectUID;
    }

    private IAttribute getAttribute(EOAttribute eoAttribute) {
        Attribute attribute = null;
        AttributeTypeID attributeTypeID = AttributeTypeID.getAttributeTypeID(eoAttribute.getAttributeTypeUID());
        IAttributeType type = this.attributeTypeProvider.getAttributeType(attributeTypeID);
        if (type != null) {
            try {
                IAttributeTypeDataType dataType = type.getDataType();
                Object value = dataType.getEOAsValue(eoAttribute.getValueAsEO());
                attribute = new Attribute(attributeTypeID, value);
            }
            catch (ExInvalidDataType e) {
                logger.error("could not convert eoAttribute", (Throwable)e);
            }
        }
        return attribute;
    }

    protected void simplySetAttribute(IAttribute attribute) {
        this.attributes.put(attribute.getAttributeTypeID(), attribute);
    }

    protected IAttribute simplyGetAttribute(IAttributeTypeID attributeTypeID) {
        IAttribute attribute = this.attributes.get(attributeTypeID);
        if (attribute == null) {
            IAttributeType attributeType = this.getAttributeType(attributeTypeID);
            attribute = new Attribute(attributeTypeID, attributeType.getDataType().getDefaultValue());
        }
        return attribute;
    }

    @Override
    public void setAttribute(IAttribute attribute) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        IAttributeType attributeType = this.attributeTypeProvider.getAttributeType(attribute.getAttributeTypeID());
        if (attributeType == null) {
            throw ExInvalidAttributeType.getExceptionForInvalidID((String)attribute.getAttributeTypeID().getUID(), (String)("attribute type not available for " + this.cockpitDataType));
        }
        if (!attributeType.getDataType().supportsValue(attribute.getAttributeValue(), attributeType.getValueRange())) {
            Object value = attribute.getAttributeValue();
            throw new ExInvalidDataType(To.string((Object)value), attributeType.getDataType().getDisplayName());
        }
        IAttributeType type = this.getAttributeType(attribute.getAttributeTypeID());
        IAttribute oldAttribute = this.simplyGetAttribute(attribute.getAttributeTypeID());
        type.getDataType().notifyAboutValueNotBeeingInUseAnymore(oldAttribute.getAttributeValue());
        type.getDataType().notifyAboutValueBeeingInUse(attribute.getAttributeValue());
        this.simplySetAttribute(attribute);
        try {
            this.modificationManager.modifyAttribute(attribute, oldAttribute.getAttributeValue());
        }
        catch (EXNoPermission e) {
            this.resetOldAttribute(attribute.getAttributeTypeID(), oldAttribute);
            throw e;
        }
        catch (EXNoLock e) {
            this.resetOldAttribute(attribute.getAttributeTypeID(), oldAttribute);
            throw e;
        }
    }

    public void setAttributeModificationManager(IAttributeModificationManager modificationManager) {
        this.modificationManager = modificationManager;
    }

    private void resetOldAttribute(IAttributeTypeID attributeTypeID, IAttribute oldAttribute) {
        if (oldAttribute == null) {
            this.attributes.remove(attributeTypeID);
        } else {
            this.simplySetAttribute(oldAttribute);
        }
    }

    public IAttribute getAttribute(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
        IAttributeType attributeType = this.getAttributeType(attributeTypeID);
        IAttribute attribute = this.simplyGetAttribute(attributeType.getAttributeTypeID());
        return attribute;
    }

    public IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
        IAttributeType type = this.attributeTypeProvider.getAttributeType(attributeTypeID);
        if (type == null) {
            throw ExInvalidAttributeType.getExceptionForNoneExistingAttributeType((String)attributeTypeID.getUID());
        }
        return type;
    }

    public IAttributeType getAttributeTypeByHumanreadableID(String humanreadableID) {
        IAttributeType type = this.attributeTypeProvider.getAttributeTypeByHumanreadableID(humanreadableID);
        if (type == null) {
            throw ExInvalidAttributeType.getExceptionForNoneExistingAttributeType((String)"unknown", (String)humanreadableID);
        }
        return type;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public String getTypeID() {
        return this.cockpitDataType;
    }

    public String getUID() {
        return this.uID;
    }

    public int getModificationCount() {
        return this.modCount;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public Collection<IAttribute> getAllAttributes() {
        ArrayList<IAttribute> attrs = new ArrayList<IAttribute>();
        Collection<IAttributeType> types = this.attributeTypeProvider.getAttributeTypes();
        for (IAttributeType type : types) {
            try {
                attrs.add(this.getAttribute(type.getAttributeTypeID()));
            }
            catch (ExInvalidAttributeType e) {
                logger.error("could not get attribute", (Throwable)e);
            }
        }
        return attrs;
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        this.modificationManager.requestAttributeModificationPermission(newAttribute, transactionController);
    }

    @Override
    public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        this.modificationManager.requestObjectTypeCategoryModificationPermission(transactionController);
    }

    @Override
    public Collection<IModificationProblem> checkGeneralAttributeModificationPermission(IAttributeType attributeType) {
        return this.modificationManager.checkGeneralModificationPermissions(attributeType);
    }

    @Override
    public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
        return this.modificationManager.checkObjectTypeCategoryModificationPermission();
    }

    @Override
    public IModificationProblem checkLocks() {
        return this.modificationManager.checkLocks();
    }

    protected Map<IAttributeTypeID, IAttribute> getAttributes() {
        return this.attributes;
    }

    protected IAttributeTypesProvider getAttributeTypeProvider() {
        return this.attributeTypeProvider;
    }

    protected IAttributeModificationManager getAttributeModificationManager() {
        return this.modificationManager;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ICockpitProjectData) {
            ICockpitProjectData projectData = (ICockpitProjectData)obj;
            return projectData.getUID().equals(this.getUID()) && projectData.getTypeID().equals(this.getTypeID()) && projectData.getProjectUID().equals(this.getProjectUID());
        }
        return false;
    }

    public int hashCode() {
        return this.cachedHashcode;
    }
}

