/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.files;

import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItemBody;
import com.arcway.cockpit.frame.shared.message.EOFileMetaInformation;

public class FileMetaInformationItem {
    private final FileID fileID;
    private final String projectUID;
    private final int commitCount;
    private final FileMetaInformationItemBody body;

    public FileMetaInformationItem(FileID fileID, String projectUID, int commitCount, FileMetaInformationItemBody body) {
        this.fileID = fileID;
        this.projectUID = projectUID;
        this.commitCount = commitCount;
        this.body = body;
    }

    public FileMetaInformationItem(FileMetaInformationItem fileMetaInformationItem) {
        this(fileMetaInformationItem.fileID, fileMetaInformationItem.projectUID, fileMetaInformationItem.commitCount, fileMetaInformationItem.body);
    }

    public FileMetaInformationItem(EOFileMetaInformation fileMetaInformationItem) {
        this(new FileID(fileMetaInformationItem.getFileUID()), fileMetaInformationItem.getProjectUID(), fileMetaInformationItem.getCommitCount(), new FileMetaInformationItemBody(fileMetaInformationItem.getOriginalFileName(), fileMetaInformationItem.getCreationDate()));
    }

    public FileID getFileID() {
        return this.fileID;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public String getOriginalFileName() {
        return this.body.getOriginalFileName();
    }

    public long getCreationDate() {
        return this.body.getCreationDate();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj instanceof FileMetaInformationItem) {
            FileMetaInformationItem fileMetaInformationItem = (FileMetaInformationItem)obj;
            result = fileMetaInformationItem.getFileID().equals(this.fileID);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.fileID.hashCode();
    }
}

