/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.categories;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.shared.message.EOFileID;
import com.arcway.cockpit.frame.shared.message.EOObjectTypeCategory;
import com.arcway.cockpit.frame.shared.message.EOObjectTypeCategoryID;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;

public class ObjectTypeCategory
implements ICockpitProjectData {
    private static final ILogger logger = Logger.getLogger(ObjectTypeCategory.class);
    public static final String DATA_TYPE_ID = "object-type-category";
    public static final int CATEGORY_ID_MAXLENGTH = 255;
    private final ObjectTypeCategoryID objectTypeCategoryID;
    private String humanReadableID;
    private String projectUID;
    private String cockpitDataTypeID;
    private int sortPosition;
    private String displayName;
    private FileID icon;
    private Set<IAttributeTypeID> attributeList;
    private int modCount = 0;
    private Timestamp modTime;

    public ObjectTypeCategory(ObjectTypeCategoryID uid, String humanReadableID, String projectUID, String cockpitDataTypeID, int sortPosition, String displayName, FileID icon, Set<IAttributeTypeID> attributeList) {
        assert (uid != null);
        assert (humanReadableID != null);
        assert (cockpitDataTypeID != null);
        String checkedHumanReadableID = ObjectTypeCategory.checkHumanReadableID(humanReadableID);
        this.objectTypeCategoryID = uid;
        this.humanReadableID = checkedHumanReadableID;
        this.projectUID = projectUID;
        this.cockpitDataTypeID = cockpitDataTypeID;
        this.sortPosition = sortPosition;
        this.displayName = displayName;
        this.icon = icon;
        this.attributeList = attributeList;
        this.modTime = new Timestamp(System.currentTimeMillis());
    }

    public ObjectTypeCategory(ObjectTypeCategory objectTypeCategory) {
        this.objectTypeCategoryID = objectTypeCategory.getObjectTypeCategoryID();
        this.humanReadableID = objectTypeCategory.getHumanReadableID();
        this.projectUID = objectTypeCategory.getProjectUID();
        this.cockpitDataTypeID = objectTypeCategory.getCockpitDataTypeID();
        this.sortPosition = objectTypeCategory.getSortPosition();
        this.displayName = objectTypeCategory.getDisplayName();
        this.icon = objectTypeCategory.getIcon();
        this.attributeList = objectTypeCategory.getAttributeList();
        this.modTime = new Timestamp(System.currentTimeMillis());
    }

    public String getTypeID() {
        return DATA_TYPE_ID;
    }

    public String getUID() {
        return this.objectTypeCategoryID.getUID();
    }

    public ObjectTypeCategoryID getObjectTypeCategoryID() {
        return this.objectTypeCategoryID;
    }

    public String getHumanReadableID() {
        return this.humanReadableID;
    }

    public void setHumanReadableID(String humanReadableID) {
        String checkedHumanReadableID;
        assert (Assert.checkArgumentBeeingNotNull((Object)humanReadableID));
        this.humanReadableID = checkedHumanReadableID = ObjectTypeCategory.checkHumanReadableID(humanReadableID);
    }

    private static String checkHumanReadableID(String humanReadableID_) {
        String checkedHumanReadableID;
        if (humanReadableID_.length() > 255) {
            logger.warn("Object type category id \"" + humanReadableID_ + "\" is too long. Cutting down to " + 255 + " characters");
            checkedHumanReadableID = humanReadableID_.substring(0, 255);
        } else {
            checkedHumanReadableID = humanReadableID_;
        }
        return checkedHumanReadableID;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public void setProjectUID(String projectUID) {
        this.projectUID = projectUID;
    }

    public String getCockpitDataTypeID() {
        return this.cockpitDataTypeID;
    }

    public void setCockpitDataTypeID(String cockpitDataTypeID) {
        assert (Assert.checkArgumentBeeingNotNull((Object)cockpitDataTypeID));
        this.cockpitDataTypeID = cockpitDataTypeID;
    }

    public int getSortPosition() {
        return this.sortPosition;
    }

    public void setSortPosition(int sortPosition) {
        this.sortPosition = sortPosition;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        assert (Assert.checkArgumentBeeingNotNull((Object)displayName));
        this.displayName = displayName;
    }

    public FileID getIcon() {
        return this.icon;
    }

    public void setIcon(FileID icon) {
        this.icon = icon;
    }

    public Set<IAttributeTypeID> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(Set<IAttributeTypeID> attributeList) {
        assert (Assert.checkArgumentBeeingNotNull(attributeList));
        this.attributeList = attributeList;
    }

    public int getModCount() {
        return this.modCount;
    }

    public void setModCount(int modCount) {
        this.modCount = modCount;
    }

    public Timestamp getModTime() {
        return this.modTime;
    }

    public void setModTime(Timestamp modTime) {
        assert (Assert.checkArgumentBeeingNotNull((Object)modTime));
        this.modTime = modTime;
    }

    public void copyAllAttributes(ObjectTypeCategory objectTypeCategory) {
        this.humanReadableID = objectTypeCategory.getHumanReadableID();
        this.projectUID = objectTypeCategory.getProjectUID();
        this.cockpitDataTypeID = objectTypeCategory.getCockpitDataTypeID();
        this.sortPosition = objectTypeCategory.getSortPosition();
        this.icon = objectTypeCategory.getIcon();
        this.displayName = objectTypeCategory.getDisplayName();
        this.attributeList = objectTypeCategory.getAttributeList();
        this.modTime = new Timestamp(System.currentTimeMillis());
    }

    public static ObjectTypeCategory createObjectTypeCategory(EOObjectTypeCategory eo) {
        HashSet<IAttributeTypeID> attributeList = new HashSet<IAttributeTypeID>();
        for (EOAttributeTypeID attributeTypeID : eo.getAttributeList()) {
            attributeList.add(AttributeTypeID.getAttributeTypeID(attributeTypeID));
        }
        ObjectTypeCategory type = new ObjectTypeCategory(ObjectTypeCategoryID.getObjectTypeCategoryID((String)eo.getUIDAsObject().getObjectTypeCategoryID()), eo.getHumanReadableID(), eo.getProjectUID(), eo.getCockpitDataTypeID(), eo.getSortPosition(), eo.getDisplayName(), new FileID(eo.getIcon().getFileID()), attributeList);
        return type;
    }

    public EOObjectTypeCategory createEncodableObject() {
        HashSet<EOAttributeTypeID> attributeList_ = new HashSet<EOAttributeTypeID>();
        for (IAttributeTypeID attributeTypeID : this.getAttributeList()) {
            attributeList_.add(new EOAttributeTypeID(attributeTypeID.getUID(), ""));
        }
        EOObjectTypeCategory eo = new EOObjectTypeCategory(new EOObjectTypeCategoryID(this.objectTypeCategoryID.getUID()), this.humanReadableID, this.projectUID, this.cockpitDataTypeID, this.sortPosition, this.displayName, new EOFileID(this.icon.getFileUID()), attributeList_, this.getModTime(), this.getModCount());
        return eo;
    }

    public boolean equals(Object obj) {
        if (obj != this) {
            if (obj instanceof ObjectTypeCategory) {
                ObjectTypeCategory objectTypeCategory = (ObjectTypeCategory)obj;
                return this.getObjectTypeCategoryID().equals((Object)objectTypeCategory.getObjectTypeCategoryID());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getObjectTypeCategoryID().hashCode();
    }
}

