/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core;

import com.arcway.cockpit.frame.client.project.core.links.IFrameLinkManager;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.interFace.IVersionedCockpitProjectData;
import java.util.Collection;

public class CommitVersionedItemsHelper {
    public static void addLinkLogsToCommittableItems(Collection<? extends EOCockpitProjectData> committableItems, Collection<String> inLinkTypes, Collection<String> outLinkTypes, IFrameLinkManager linkManager) {
        for (EOCockpitProjectData eOCockpitProjectData : committableItems) {
            EOLinkLog versionedLink;
            eOCockpitProjectData.setIsHistoricItem(true);
            for (String linkTypeID : outLinkTypes) {
                for (EOLink link : linkManager.getLinksOfLinkTypeForModuleDataItem(linkManager.getLinkType(linkTypeID), eOCockpitProjectData.getUID())) {
                    ICockpitProjectData linkableObject = linkManager.getLinkableObject(link);
                    int linkableObjectModCount = -1;
                    if (linkableObject instanceof IVersionedCockpitProjectData) {
                        linkableObjectModCount = ((IVersionedCockpitProjectData)linkableObject).getModificationCount();
                    }
                    versionedLink = new EOLinkLog(eOCockpitProjectData.getProjectUID(), linkableObject.getUID(), linkableObjectModCount, eOCockpitProjectData.getUID(), eOCockpitProjectData.getModCount(), "", linkTypeID);
                    eOCockpitProjectData.addOutLinkLog(versionedLink);
                }
            }
            for (String linkTypeID : inLinkTypes) {
                for (EOLink link : linkManager.getLinksOfLinkTypeForLinkableObject(linkManager.getLinkType(linkTypeID), eOCockpitProjectData.getUID())) {
                    ICockpitProjectData moduleDataItem = linkManager.getModuleDataItem(link);
                    int moduleDataModCount = -1;
                    if (moduleDataItem instanceof IVersionedCockpitProjectData) {
                        moduleDataModCount = ((IVersionedCockpitProjectData)moduleDataItem).getModificationCount();
                    }
                    versionedLink = new EOLinkLog(eOCockpitProjectData.getProjectUID(), eOCockpitProjectData.getUID(), eOCockpitProjectData.getModCount(), moduleDataItem.getUID(), moduleDataModCount, "", linkTypeID);
                    eOCockpitProjectData.addInLinkLog(versionedLink);
                }
            }
        }
    }
}

