/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class ProjectMetaDataManager
implements IFrameDataManager,
IPropertyChangesListener,
IProjectCloseListener {
    private static final ILogger logger = Logger.getLogger(ProjectMetaDataManager.class);
    private IDataLabelProvider dataLabelProvider;
    private IFrameProjectAgent projectAgent;
    private Project serverState;
    private Project localModification;

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.projectAgent = administrator.getFrameProjectAgent();
        EOProject eoProject = serverDataContainer.getMetaData();
        if (eoProject != null) {
            eoProject.setProjectUID(this.projectAgent.getProjectUID());
            ProjectAttributeModificationManager modManager = new ProjectAttributeModificationManager(this.projectAgent);
            this.serverState = new Project(this.projectAgent, eoProject, (IAttributeModificationManager)modManager);
            modManager.setProject(this.serverState);
        }
        try {
            IXMLDataAccessor modificationFileAccessor = this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.FILEKEY_PROJECTMETADATA, (IEncodableObjectFactory)MessageDataFactory.getInstance());
            EOProject modifiedEOProject = (EOProject)modificationFileAccessor.read();
            if (modifiedEOProject != null) {
                ProjectAttributeModificationManager modManager = new ProjectAttributeModificationManager(this.projectAgent);
                this.localModification = new Project(this.projectAgent, modifiedEOProject, (IAttributeModificationManager)modManager);
                modManager.setProject(this.localModification);
            }
        }
        catch (IOException e) {
            throw new EXCorruptProjectData((Exception)e);
        }
        catch (EXDecoderException e) {
            throw new EXCorruptProjectData((Exception)((Object)e));
        }
    }

    public void setNewProject(Project project) {
        this.localModification = project;
        this.saveLocalModifications();
        this.throwModelRefreshedEvent();
    }

    public EOProject getLocalModification() {
        if (this.localModification != null) {
            return this.localModification.createEncodableObject();
        }
        return null;
    }

    public void applySynchronousModification(EOProject modifiedProject) {
        ProjectAttributeModificationManager modManager = new ProjectAttributeModificationManager(this.projectAgent);
        this.serverState = new Project(this.projectAgent, modifiedProject, (IAttributeModificationManager)modManager);
        modManager.setProject(this.serverState);
        this.localModification = null;
        this.saveLocalModifications();
    }

    public void applyAsynchronousModification(EOProject modifiedProject) {
        if (this.localModification != null) {
            logger.warn("Project " + this.localModification.getName() + " was modified on this client and on another client at the same time.");
        }
        ProjectAttributeModificationManager modManager = new ProjectAttributeModificationManager(this.projectAgent);
        this.serverState = new Project(this.projectAgent, modifiedProject, (IAttributeModificationManager)modManager);
        modManager.setProject(this.serverState);
        String possiblyNewProjectName = Project.getProjectName(modifiedProject);
        if (!possiblyNewProjectName.equals(this.projectAgent.getProjectName())) {
            this.projectAgent.projectNameChanged(possiblyNewProjectName);
        }
        this.throwModelRefreshedEvent();
    }

    private void throwModelRefreshedEvent() {
        PropertyChanges changes1 = new PropertyChanges(null, (Object)this.getProject(), null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes1, ICockpitProject.class);
        PropertyChanges changes2 = new PropertyChanges(null, (Object)this.projectAgent, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes2, IProjectAgent.class);
    }

    static boolean modFileExists(IFrameProjectAgent projectAgent_) throws EXCorruptProjectData {
        boolean modFileExists = false;
        try {
            IXMLDataAccessor modificationFileAccessor = projectAgent_.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.FILEKEY_PROJECTMETADATA, (IEncodableObjectFactory)MessageDataFactory.getInstance());
            EOProject modifiedEOProject = (EOProject)modificationFileAccessor.read();
            if (modifiedEOProject != null) {
                modFileExists = true;
            }
        }
        catch (IOException e) {
            throw new EXCorruptProjectData((Exception)e);
        }
        catch (EXDecoderException e) {
            throw new EXCorruptProjectData((Exception)((Object)e));
        }
        return modFileExists;
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
        this.projectAgent.addProjectCloseListener(this);
        this.projectAgent.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IProjectAgent.class);
    }

    @Override
    public void closeProject(IFrameProjectAgent projectAgent_) {
        this.projectAgent.getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this);
        this.projectAgent.removeProjectCloseListener(this);
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        if (repositoryInterface != null) {
            String currentProjectLanguage = this.projectAgent.getLanguage();
            String oldProjectLanguage = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)repositoryInterface.getTypeManager()).getRepositoryLocale().getLanguage();
            if (!oldProjectLanguage.equals(currentProjectLanguage)) {
                this.projectAgent.deactivateRepositoryInterface();
                this.projectAgent.activateRepositoryInterface();
            }
        }
    }

    @Override
    public String getLocalizedManagerName() {
        return Messages.getString("ProjectMetaDataManager.project_metadata_manager");
    }

    @Override
    public void discardLocalModifications() {
        this.localModification = null;
        this.saveLocalModifications();
    }

    @Override
    public boolean hasLocalModifications() {
        return this.localModification != null;
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return cockpitDataTypeID.equals("frame.project");
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        return this.getCockpitProjectData(cockpitDataUID) != null;
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        Project project = this.getProject();
        if (cockpitDataUID.equals(project.getUID())) {
            return project;
        }
        return null;
    }

    public Project getProject() {
        return this.localModification == null ? this.serverState : this.localModification;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        if (this.dataLabelProvider == null) {
            this.dataLabelProvider = new IDataLabelProvider(){

                public Image getImageOfType(String dataTypeID) {
                    if (dataTypeID.equals("frame.project")) {
                        return FrameDataTypes.getDataType("frame.project").getIcon();
                    }
                    return null;
                }

                public String getTypeDisplayName(String dataTypeID) {
                    if (dataTypeID.equals("frame.project")) {
                        return FrameDataTypes.getDataType("frame.project").getDisplayName();
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    Project project;
                    if (element instanceof Project && (project = (Project)element).equals(ProjectMetaDataManager.this.getProject())) {
                        if (ProjectMetaDataManager.this.projectAgent.isOpened()) {
                            return Icons.getImageForOpenProject();
                        }
                        return Icons.getImageForClosedProject();
                    }
                    return null;
                }

                public String getText(Object element) {
                    if (element instanceof Project) {
                        Project project = (Project)element;
                        return project.getName();
                    }
                    return null;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
        }
        return this.dataLabelProvider;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        ILocalModificationContainer modification = new ILocalModificationContainer(){

            public IDataLabelProvider getDataLabelProvider() {
                return ProjectMetaDataManager.this.getDataLabelProvider();
            }

            public IAddedItem[] getAddedItems() {
                return null;
            }

            public boolean isEmpty() {
                return ProjectMetaDataManager.this.localModification == null;
            }

            public IModifiedItem[] getModifiedItems() {
                if (ProjectMetaDataManager.this.localModification != null) {
                    ModifiedItem item = new ModifiedItem((Object)ProjectMetaDataManager.this.localModification);
                    return new IModifiedItem[]{item};
                }
                return null;
            }

            public IDeletedItem[] getDeletedItems() {
                return null;
            }

            public Image getGeneralImage() {
                return FrameDataTypes.getDataType("frame.project").getIcon();
            }

            public String getGeneralDescription() {
                return FrameDataTypes.getDataType("frame.project").getDisplayName();
            }

            public String getTypeIDOfContainedData() {
                return "frame.project";
            }
        };
        return new ILocalModificationContainer[]{modification};
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        HashMap<IAttributeTypeDataType, Collection<IAttribute>> dataTypes_attributes = new HashMap<IAttributeTypeDataType, Collection<IAttribute>>();
        Project project = this.getProject();
        for (IAttribute attribute : project.getAllAttributes()) {
            IAttributeType attributeType = project.getAttributeType(attribute.getAttributeTypeID());
            IAttributeTypeDataType dataType = attributeType.getDataType();
            if (!dataTypeClazz.isAssignableFrom(dataType.getClass())) continue;
            ArrayList<IAttribute> attributes = (ArrayList<IAttribute>)dataTypes_attributes.get(dataType);
            if (attributes == null) {
                attributes = new ArrayList<IAttribute>();
                dataTypes_attributes.put(dataType, attributes);
            }
            attributes.add(attribute);
        }
        return dataTypes_attributes;
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        ArrayList<IAttributeType> types = new ArrayList<IAttributeType>();
        Project project = this.getProject();
        for (IAttribute attribute : project.getAllAttributes()) {
            IAttributeType attributeType = project.getAttributeType(attribute.getAttributeTypeID());
            if (!dataTypeClass.isAssignableFrom(attributeType.getDataType().getClass())) continue;
            types.add(attributeType);
        }
        return types;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        String cause = Messages.getString("ProjectMetaDataManager.metadata_may_not_be_deleted");
        transactionController.addLockModificationProblem(new ModificationProblem(cause, cause));
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new EXNoPermission("The projects metadata may not be deleted.");
    }

    private void saveLocalModifications() {
        IXMLDataAccessor modificationFileAccessor = this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.FILEKEY_PROJECTMETADATA, (IEncodableObjectFactory)MessageDataFactory.getInstance());
        if (this.localModification == null) {
            modificationFileAccessor.write(null);
        } else {
            modificationFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent((EOEncodableObject)this.localModification.createEncodableObject()));
        }
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        return Collections.singleton(this.getProject());
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        return null;
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        ArrayList<Object> children = null;
        if (parent.equals(this.getProject())) {
            children = new ArrayList<Object>();
            children.add(this.projectAgent.getFrameSectionManager().getRootSection());
            children.addAll(this.projectAgent.getFrameUniqueElementMgr().getUniqueElements());
            children.addAll(this.projectAgent.getFrameStakeholderManager().getStakeholders());
            children.addAll(this.projectAgent.getFrameStakeholderManager().getRoles());
            IFrameDataManager reportTemplateFoldersManager = this.projectAgent.getDataManager(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER);
            for (IAttributeOwner iAttributeOwner : reportTemplateFoldersManager.getData()) {
                IAttributeOwner folderParent = reportTemplateFoldersManager.getParent(iAttributeOwner);
                if (!parent.equals(folderParent)) continue;
                children.add(iAttributeOwner);
                break;
            }
            children.addAll(this.projectAgent.getModuleController().getChildren(null));
        }
        return children;
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        String cause = "Metadata can not be added";
        transactionController.addLockModificationProblem(new ModificationProblem(cause, cause));
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new EXNoPermission("Metadata can not be added!");
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        return false;
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("A project cannot be moved.", "Project can not be moved"));
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new EXNoPermission("A project cannot be moved.");
    }

    @Override
    public void dataModified(IAttributeOwner attributeOwner) {
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        return null;
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        return this.localModification != null;
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        return false;
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        return null;
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        return this.serverState;
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
        IAttributeOwnerRW.Visitor.visitAllAttributeOwnerRWs(this.getData(), visitor);
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return new ProjectAttributeTypeProvider(this.projectAgent.getProjectUID());
    }
}

