/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews;

import com.arcway.cockpit.frame.client.lib.relationviews.EdgeAttributes;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewViewPartFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.NodeAttributes;
import com.arcway.lib.eclipse.graphics.SWTImageData;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IImageDataProvider;
import com.arcway.lib.graphics.image.ImageDataProviders;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linemarkers.LineMarkerPeakedArc;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planview.cm.view.PVGraphicalSupplementText;
import com.arcway.planagent.planview.legends.PVImageLegend;
import com.arcway.planagent.planview.view.PVFigureLineShape;
import com.arcway.planagent.planview.view.PVFigurePlane;
import com.arcway.planagent.planview.view.PVMarker;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import com.arcway.planagent.planview.view.PVView;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public final class RelationViewViewPartFactory
implements IRelationViewViewPartFactory {
    private static final int NODE_SPACING_HORIZONTAL = 5;
    private static final int NODE_ICON_WIDTH = 20;
    private static final FillColor EDGE_FILLCOLOR = FillColor.BLACK;
    private static final double EDGE_SIZE = 0.5;
    private static final double ARROW_ARCLENGTH = 7.0;

    protected PVPlanViewPart createConnection(int startX, int startY, int endX, int endY, boolean showEdge, boolean sourceMarked, boolean targetMarked, Color lineColor) {
        PVView view = new PVView();
        if (showEdge) {
            LineMarkerPeakedArc arrow;
            PVFigureLineShape line = new PVFigureLineShape();
            Points points = new Points();
            Point sourcePoint = new Point((double)startX, (double)startY);
            Point targetPoint = new Point((double)endX, (double)endY);
            points.add(sourcePoint);
            points.add(targetPoint);
            line.setPoints(points);
            LineAppearance lineAppearance = new LineAppearance();
            lineAppearance.setLineStyle(LineStyle.SOLID);
            lineAppearance.setLineColor(lineColor);
            lineAppearance.setLineThickness(2.0 * lineAppearance.getLineThickness());
            line.setLineAppearance((ILineAppearanceRO)lineAppearance);
            line.setLineStartMarkerAppearance((ILineMarkerAppearanceRO)new LineMarkerAppearance());
            line.setLineEndMarkerAppearance((ILineMarkerAppearanceRO)new LineMarkerAppearance());
            view.addChild((PVPlanViewPart)line);
            if (sourceMarked) {
                PVMarker sourceLineMarker = new PVMarker();
                sourceLineMarker.setPosition(sourcePoint);
                arrow = new LineMarkerPeakedArc();
                arrow.arcLength(7.0);
                sourceLineMarker.setMarkerStyle((LineMarker)arrow, lineColor, EDGE_FILLCOLOR, 0.5, GeoVector.getDifferenceVectorAngle((Point)targetPoint, (Point)sourcePoint));
                view.addChild((PVPlanViewPart)sourceLineMarker);
            }
            if (targetMarked) {
                PVMarker targetLineMarker = new PVMarker();
                targetLineMarker.setPosition(targetPoint);
                arrow = new LineMarkerPeakedArc();
                arrow.arcLength(7.0);
                targetLineMarker.setMarkerStyle((LineMarker)arrow, lineColor, EDGE_FILLCOLOR, 0.5, GeoVector.getDifferenceVectorAngle((Point)sourcePoint, (Point)targetPoint));
                view.addChild((PVPlanViewPart)targetLineMarker);
            }
        }
        return view;
    }

    protected PVPlanViewPart createStandardNode(int x, int y, int width, int height, Color backgroundColor, Image image, String wrappedText, Font font, Color foregroundColor, String nodeTypeID, String nodeID, String nodeName) {
        PVView nodeView = new PVView();
        PVFigurePlane nodePlane = new PVFigurePlane();
        Points points = new Points();
        points.add(new Point((double)x, (double)y));
        points.add(new Point((double)(x + width), (double)y));
        points.add(new Point((double)(x + width), (double)(y + height)));
        points.add(new Point((double)x, (double)(y + height)));
        Corners corners = new Corners(points, 5.0);
        nodePlane.setPoints((Points)corners);
        FillColor fillColor = new FillColor(backgroundColor, 255);
        FillAppearance ghost = new FillAppearance((IFillAppearanceRO)new FillAppearance());
        ghost.setFillStyle(FillStyle.SOLID);
        ghost.setFillColor(fillColor);
        nodePlane.setFillAppearance((IFillAppearanceRO)ghost);
        LineAppearance lineAppearance = new LineAppearance();
        lineAppearance.setLineStyle(LineStyle.NONE);
        nodePlane.setLineAppearance((ILineAppearanceRO)lineAppearance);
        nodeView.addChild((PVPlanViewPart)nodePlane);
        PVGraphicalSupplementText nodeText = new PVGraphicalSupplementText();
        String fontName = font.getFontData()[0].getName();
        TextStyle textStyle = new TextStyle(fontName, false, false);
        TextAppearance textAppearance = new TextAppearance();
        textAppearance.setTextStyle(textStyle);
        double heightInPixels = this.getFontHeightInPixels(font);
        textAppearance.setTextLineHeight(heightInPixels);
        textAppearance.setTextColor(foregroundColor);
        textAppearance.setAlignment(new Alignment(1, 16));
        textAppearance.setInsets(new Insets(0.0));
        nodeText.setTextAppearance((ITextAppearance)textAppearance);
        nodeText.setText(wrappedText);
        int maxLabelWidth = width - 10 - (image != null ? 20 : 0);
        int childWidth = 0;
        int childHeight = 0;
        if (image != null) {
            childWidth += 20;
            childHeight = image.getBounds().height;
        }
        childHeight = Math.max(childHeight, (int)heightInPixels);
        int childX = x + (width - (childWidth += maxLabelWidth)) / 2;
        int childY = y + (height - childHeight) / 2;
        PVView childView = new PVView();
        int textX = childX;
        int textY = childY;
        if (image != null) {
            PVImageLegend icon = this.getImageIcon(childX, childY, image);
            childView.addChild((PVPlanViewPart)icon);
            textX = childX + 20;
        }
        Points cpoints = new Points();
        cpoints.add(new Point((double)textX, (double)textY));
        cpoints.add(new Point((double)(textX + childWidth), (double)textY));
        cpoints.add(new Point((double)(textX + childWidth), (double)(textY + childHeight)));
        cpoints.add(new Point((double)textX, (double)(textY + childHeight)));
        nodeText.setPoints(cpoints);
        childView.addChild((PVPlanViewPart)nodeText);
        nodeView.addChild((PVPlanViewPart)childView);
        if (nodeID != null) {
            PVView rootViewForLink = new PVView();
            String elementName = nodeName != null ? nodeName : "";
            String elementTypeID = nodeTypeID != null ? nodeTypeID : "";
            String elementID = nodeID;
            nodeView.setRoot((PVPlanViewPart)rootViewForLink, elementName, elementTypeID, elementID, null);
        }
        return nodeView;
    }

    private double getFontHeightInPixels(Font font) {
        int swtHeightInPointsPostscript = font.getFontData()[0].getHeight();
        Display screen = Display.getDefault();
        int screenDPIy = screen.getDPI().y;
        return (double)swtHeightInPointsPostscript / 72.0 * (double)screenDPIy / 0.8075987144168962;
    }

    private PVImageLegend getImageIcon(int x, int y, Image image) {
        ImageData swtImageData = image.getImageData();
        SWTImageData imageData = new SWTImageData(swtImageData, false, null);
        IImageDataProvider imageDataProvider = ImageDataProviders.createImageDataProvider((IImageData)imageData);
        Dimension d = new Dimension((double)imageData.getWidthInPixels(), (double)imageData.getHeightInPixels());
        Rectangle r = new Rectangle((double)x, (double)y, d);
        return new PVImageLegend(r, imageDataProvider);
    }

    @Override
    public PVPlanViewPart createEdgeViewPart(int startX, int startY, int endX, int endY, EdgeAttributes edge) {
        return this.createConnection(startX, startY, endX, endY, edge.showEdge(), edge.hasSourceArrow(), edge.hasTargetArrow(), edge.getLineColor());
    }

    @Override
    public PVPlanViewPart createNodeViewPart(int x, int y, int width, int height, NodeAttributes nodeAttributes, Object data, String nodeTypeID, String nodeID, String nodeName, Font nodeFont) {
        return this.createStandardNode(x, y, width, height, nodeAttributes.getBackgroundColor(), nodeAttributes.getIcon(), nodeAttributes.getWrappedText(), nodeFont, nodeAttributes.getForegroundColor(), nodeTypeID, nodeID, nodeName);
    }

    public void dispose() {
    }
}

