/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.tools.attributesetter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.tools.attributesetter.AttributeSetterTool;
import com.arcway.cockpit.frame.client.global.tools.attributesetter.AttributeSetterWizard;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class AttributeSetterActionDelegate
implements IViewActionDelegate {
    private IViewPart viewPart = null;
    private String projectUID = null;
    private Collection<IUniqueElement> selectedUniqueElements = null;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        assert (this.viewPart != null);
        this.updateProjectUIDAndSelectedUniqueElements(selection);
        action.setEnabled(this.calculateEnabled());
    }

    private boolean calculateEnabled() {
        List<IAttributeType> attributeTypes;
        ProjectAgent projectAgent;
        boolean enabled = this.projectUID != null ? ((projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID)) != null ? !(attributeTypes = AttributeSetterTool.getAvailableAttributeTypes(projectAgent)).isEmpty() && !this.selectedUniqueElements.isEmpty() : false) : false;
        return enabled;
    }

    private void updateProjectUIDAndSelectedUniqueElements(ISelection selection) {
        HashSet<String> projectUIDs = new HashSet<String>();
        HashSet<IUniqueElement> currentlySelectedUniqueElements = new HashSet<IUniqueElement>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof IUniqueElement)) continue;
                IUniqueElement uniqueElement = (IUniqueElement)element;
                projectUIDs.add(uniqueElement.getProjectUID());
                currentlySelectedUniqueElements.add(uniqueElement);
            }
        }
        if (projectUIDs.size() == 1) {
            this.projectUID = (String)projectUIDs.iterator().next();
            this.selectedUniqueElements = currentlySelectedUniqueElements;
        } else {
            this.projectUID = null;
            this.selectedUniqueElements = null;
        }
    }

    public void run(IAction action) {
        ProjectAgent projectAgent;
        assert (this.viewPart != null);
        if (this.calculateEnabled() && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID)) != null) {
            Shell shell = this.viewPart.getViewSite().getShell();
            AttributeSetterWizard wizard = new AttributeSetterWizard(projectAgent, this.selectedUniqueElements);
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
            wizardDialog.open();
        }
    }
}

