/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoryIconProvider;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.java.Equals;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ObjectTypeCategoryChangeMenu
extends MenuManager
implements IModuleProjectSwitchListener,
IMenuListener {
    private static final ILogger LOGGER = Logger.getLogger(ObjectTypeCategoryChangeMenu.class);
    private final String dataType;
    private IFrameProjectAgent projectAgent;
    private List<ObjectTypeCategory> currentCategories;
    private final ISelectionProvider selectionProvider;
    private List<? extends IAttributeOwnerRW> predefinedSelection;
    private final boolean usePredefinedSelection;

    public ObjectTypeCategoryChangeMenu(String dataType, ISelectionProvider selectionProvider) {
        super(ObjectTypeCategoryLabels.LABEL_CATEGORY, String.valueOf(dataType) + "." + "object-type-category");
        this.dataType = dataType;
        this.selectionProvider = selectionProvider;
        this.predefinedSelection = null;
        this.usePredefinedSelection = false;
    }

    public ObjectTypeCategoryChangeMenu(String dataType, List<? extends IAttributeOwnerRW> selection, String projectUID) {
        super(ObjectTypeCategoryLabels.LABEL_CATEGORY, String.valueOf(dataType) + "." + "object-type-category");
        this.dataType = dataType;
        this.selectionProvider = null;
        this.usePredefinedSelection = true;
        this.predefinedSelection = selection;
        for (IAttributeOwnerRW iAttributeOwnerRW : selection) {
            if (iAttributeOwnerRW.getTypeID().equals(dataType)) continue;
            this.predefinedSelection = null;
            break;
        }
        this.projectSwitched(projectUID);
        this.setActions();
    }

    @Override
    public void projectSwitched(String projectUID) {
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.setActions();
    }

    private void setActions() {
        this.removeAll();
        List<? extends IAttributeOwnerRW> selection = this.getSelection();
        if (this.projectAgent != null && selection != null) {
            HashSet<ObjectTypeCategoryID> activatedCategories = new HashSet<ObjectTypeCategoryID>();
            for (IAttributeOwnerRW iAttributeOwnerRW : selection) {
                activatedCategories.add(iAttributeOwnerRW.getCategoryID());
            }
            CategorySelectAction categorySelectAction = new CategorySelectAction(ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY, null, null);
            categorySelectAction.setChecked(activatedCategories.contains(null));
            this.add((IAction)categorySelectAction);
            this.currentCategories = this.projectAgent.getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(this.dataType);
            for (ObjectTypeCategory singleCategory : this.currentCategories) {
                ImageDescriptor icon = null;
                if (!FileID.NO_FILE.equals(singleCategory.getIcon())) {
                    icon = ObjectTypeCategoryIconProvider.getDefault().getObjectTypeCategoryIconResource(this.projectAgent.getProjectUID(), singleCategory.getObjectTypeCategoryID()).getImageDescriptor();
                }
                CategorySelectAction categoryAction = new CategorySelectAction(singleCategory.getDisplayName(), icon, singleCategory.getObjectTypeCategoryID());
                categoryAction.setChecked(activatedCategories.contains(singleCategory.getObjectTypeCategoryID()));
                this.add((IAction)categoryAction);
            }
        }
    }

    public boolean isVisible() {
        return super.isVisible() && this.getSelection() != null;
    }

    private List<? extends IAttributeOwnerRW> getSelection() {
        if (this.usePredefinedSelection) {
            return this.predefinedSelection;
        }
        ISelection selection = this.selectionProvider.getSelection();
        ArrayList<IAttributeOwnerRW> validElements = null;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            validElements = new ArrayList<IAttributeOwnerRW>(((IStructuredSelection)selection).size());
            for (Object singleSelection : ((IStructuredSelection)selection).toList()) {
                if (singleSelection instanceof IAttributeOwnerRW) {
                    IAttributeOwnerRW categoryOwner = (IAttributeOwnerRW)singleSelection;
                    if (this.dataType.equals(categoryOwner.getTypeID())) {
                        validElements.add(categoryOwner);
                        continue;
                    }
                    validElements = null;
                    break;
                }
                validElements = null;
                break;
            }
        }
        return validElements;
    }

    private class CategorySelectAction
    extends Action {
        private final ObjectTypeCategoryID categoryID;

        public CategorySelectAction(String name, ImageDescriptor icon, ObjectTypeCategoryID categoryID) {
            super(name, 2);
            this.setImageDescriptor(icon);
            this.categoryID = categoryID;
        }

        public void run() {
            ArrayList<IAttributeOwnerRW> frameDataToChange = new ArrayList<IAttributeOwnerRW>();
            List selection = ObjectTypeCategoryChangeMenu.this.getSelection();
            if (selection != null) {
                for (IAttributeOwnerRW singleSelection : selection) {
                    if (Equals.equals((Object)singleSelection.getCategoryID(), (Object)this.categoryID)) continue;
                    frameDataToChange.add(singleSelection);
                }
                if (!frameDataToChange.isEmpty()) {
                    LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(ObjectTypeCategoryChangeMenu.this.projectAgent);
                    for (IAttributeOwnerRW singleFrameDataToChange : frameDataToChange) {
                        singleFrameDataToChange.requestObjectTypeCategoryModificationPermission(transactionController);
                    }
                    Collection<IModificationProblem> problems = transactionController.checkConditions(true, true);
                    if (problems.isEmpty()) {
                        transactionController.execute();
                        try {
                            for (IAttributeOwnerRW singleFrameDataToChange : frameDataToChange) {
                                singleFrameDataToChange.setCategoryID(this.categoryID);
                            }
                        }
                        catch (EXNoPermission e) {
                            LOGGER.error("Could not execute", (Throwable)e);
                        }
                        catch (EXNoLock e) {
                            LOGGER.error("Could not execute", (Throwable)e);
                        }
                    } else {
                        ModificationProblemsDialog.showModificationProblemsDialog(problems, (Shell)Display.getCurrent().getActiveShell());
                    }
                }
            }
        }

        public boolean isEnabled() {
            return ObjectTypeCategoryChangeMenu.this.projectAgent.getFramePermissionChecker().hasPermission("modify-category", "com.arcway.cockpit.uniqueelement", ObjectTypeCategoryChangeMenu.this.projectAgent);
        }
    }
}

