/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.linkview;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IFrameData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IModuleLinkLabelProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IndirectLinksContainer;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ModuleLinkViewContribution;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplate;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILinkTypeFilter;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplate;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class LinkViewContentProvider
implements ITreeContentProvider,
ILabelProvider {
    private List<Object> rootElements;
    private final Collection<ILinkContentProvider> filteredContentProviders = new ArrayList<ILinkContentProvider>();
    private final HashMap<String, Image> images = new HashMap();
    private final Set<String> modelElementLinkTypes = new HashSet<String>();
    private final Set<String> otherLinkTypes = new HashSet<String>();
    private Image showComponentImage;
    private Image showCompositeImage;
    private final ModuleLinkViewContribution moduleLinkViewContribution;
    private final boolean limitedTextLength;
    private final Map<String, ICockpitDataType> map_cockpitTypeID_cockpitDataType;
    private final ILinkTypeFilter MODEL_ELEMENT_LINK_TYPE_FILTER = new ILinkTypeFilter(){

        @Override
        public boolean isLinkTypeToExclude(String linkTypeID) {
            return LinkViewContentProvider.this.isModelElementLinkType(linkTypeID);
        }
    };

    public LinkViewContentProvider(ModuleLinkViewContribution moduleLinkViewContribution, boolean limitedTextLength) {
        this.moduleLinkViewContribution = moduleLinkViewContribution;
        this.limitedTextLength = limitedTextLength;
        this.map_cockpitTypeID_cockpitDataType = new HashMap<String, ICockpitDataType>();
        Collection<ICockpitDataType> typeDescriptions = FrameDataTypes.getAllDataTypes();
        for (ICockpitDataType typeDescription : typeDescriptions) {
            this.map_cockpitTypeID_cockpitDataType.put(typeDescription.getCockpitDataTypeID(), typeDescription);
        }
    }

    private boolean isModelElementLinkType(String linkTypeID) {
        if (this.modelElementLinkTypes.contains(linkTypeID)) {
            return true;
        }
        if (this.otherLinkTypes.contains(linkTypeID)) {
            return false;
        }
        for (ILinkContentProvider lc : this.moduleLinkViewContribution.getModuleContentProviders()) {
            ILinkTypeFilter filterForModuleDataLinkTypes = lc.getFilterForModuleDataLinkTypes();
            if (!filterForModuleDataLinkTypes.isLinkTypeToExclude(linkTypeID)) continue;
            this.modelElementLinkTypes.add(linkTypeID);
            return true;
        }
        this.otherLinkTypes.add(linkTypeID);
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children;
        block10: {
            block9: {
                children = new ArrayList<Object>();
                if (!(parentElement instanceof IUniqueElement)) break block9;
                if (!this.isInRoot(parentElement)) break block10;
                IUniqueElement uniqueElement = (IUniqueElement)parentElement;
                ProjectAgent activeProject = ProjectMgr.getProjectMgr().getProjectAgent(uniqueElement.getProjectUID());
                IUniqueElementRelationshipProvider conRelshipProvider = activeProject.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider();
                Collection<IUniqueElement> containedElements = conRelshipProvider.getAllNextUniqueElements(uniqueElement.getUID());
                Collection<IUniqueElement> containerElements = conRelshipProvider.getAllPreviousUniqueElements(uniqueElement.getUID());
                for (ILinkContentProvider lc : this.moduleLinkViewContribution.getModuleContentProviders()) {
                    if (this.filteredContentProviders.contains(lc)) continue;
                    children.addAll(lc.getLinkedModuleData(uniqueElement, containedElements, containerElements));
                }
                ILOLinkAccessFacade linkFacade = LinkViewContentProvider.getLinkFacade(activeProject, uniqueElement);
                if (linkFacade == null) break block10;
                List<ICockpitProjectData> moduleData = linkFacade.getCrossLinkedModuleData(uniqueElement.getUID(), this.MODEL_ELEMENT_LINK_TYPE_FILTER);
                children.addAll(moduleData);
                break block10;
            }
            if (parentElement instanceof IFrameData) {
                ILOLinkAccessFacade linkFacade;
                IFrameData frameData = (IFrameData)parentElement;
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(frameData.getProjectUID());
                if (projectAgent != null && projectAgent.isOpened() && (linkFacade = LinkViewContentProvider.getLinkFacade(projectAgent, frameData)) != null) {
                    List<ICockpitProjectData> moduleData = linkFacade.getCrossLinkedModuleData(frameData.getUID(), ILinkContentProvider.NO_LINK_TYPE_FILTER);
                    children.addAll(moduleData);
                }
            } else if (parentElement instanceof IndirectLinksContainer) {
                IndirectLinksContainer container = (IndirectLinksContainer)parentElement;
                children.addAll(container.getLinkedModuleData());
            } else if (this.isInRoot(parentElement) && parentElement instanceof ICockpitProjectData) {
                children.addAll(LinkViewContentProvider.getLinkedElements((ICockpitProjectData)parentElement));
            } else {
                for (ILinkContentProvider lc : this.moduleLinkViewContribution.getModuleContentProviders()) {
                    Object[] c = lc.getChildren(parentElement);
                    if (c == null) continue;
                    children.addAll(Arrays.asList(c));
                }
            }
        }
        return children.toArray();
    }

    private static ILOLinkAccessFacade getLinkFacade(IFrameProjectAgent projectAgent, IFrameData frameData) {
        ILOLinkAccessFacade linkFacade = frameData instanceof ISection ? projectAgent.getFrameSectionManager().getSectionLinkFacade() : (frameData instanceof IPlan ? projectAgent.getFrameSectionManager().getPlanLinkFacade() : (frameData instanceof IUniqueElement ? projectAgent.getFrameUniqueElementMgr().getUniqueElementLinkFacade() : (frameData instanceof IStakeholder ? projectAgent.getFrameStakeholderManager().getStakeholderLinkFacade() : (frameData instanceof IStakeholderRole ? projectAgent.getFrameStakeholderManager().getStakeholderRoleLinkFacade() : (frameData instanceof IReportTemplateFolder ? projectAgent.getFrameReportTemplateFolderManager().getReportTemplateFolderLinkFacade() : (frameData instanceof IReportTemplate ? projectAgent.getFrameReportTemplateManager().getReportTemplateLinkFacade() : (frameData instanceof IReportOutputTemplate ? projectAgent.getFrameReportOutputTemplateManager().getReportOutputTemplateLinkFacade() : null)))))));
        return linkFacade;
    }

    private boolean isInRoot(Object data) {
        if (this.rootElements != null) {
            for (Object rootData : this.rootElements) {
                if (rootData != data) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasLinkedElements(ICockpitProjectData data) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(data.getProjectUID());
        return !projectAgent.getLinkManager().getUniqueElementLinks(data).isEmpty();
    }

    private static List<IUniqueElement> getLinkedElements(ICockpitProjectData data) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(data.getProjectUID());
        ArrayList<IUniqueElement> linkedElements = new ArrayList<IUniqueElement>();
        Collection<EOLink> links = projectAgent.getLinkManager().getUniqueElementLinks(data);
        LinkViewContentProvider.addLinkedUniqueElements(projectAgent, linkedElements, links);
        return linkedElements;
    }

    private static void addLinkedUniqueElements(IFrameProjectAgent projectAgent, Collection<IUniqueElement> elements, Collection<EOLink> links) {
        for (EOLink link : links) {
            IUniqueElement ce = (IUniqueElement)projectAgent.getLinkManager().getLinkableObject(link);
            if (elements.contains(ce)) continue;
            elements.add(ce);
        }
    }

    public void filter(ILinkContentProvider linkContentProvider) {
        this.filteredContentProviders.add(linkContentProvider);
    }

    public void unfilter(ILinkContentProvider linkContentProvider) {
        this.filteredContentProviders.remove(linkContentProvider);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IUniqueElement) {
            if (this.isInRoot(element)) {
                IUniqueElement uniqueElement = (IUniqueElement)element;
                ProjectAgent activeProject = ProjectMgr.getProjectMgr().getProjectAgent(uniqueElement.getProjectUID());
                IUniqueElementRelationshipProvider conRelshipProvider = activeProject.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider();
                Collection<IUniqueElement> containedElements = conRelshipProvider.getAllNextUniqueElements(uniqueElement.getUID());
                Collection<IUniqueElement> containerElements = conRelshipProvider.getAllPreviousUniqueElements(uniqueElement.getUID());
                for (ILinkContentProvider lc : this.moduleLinkViewContribution.getModuleContentProviders()) {
                    if (!lc.hasLinks(uniqueElement, containedElements, containerElements)) continue;
                    return true;
                }
                ILOLinkAccessFacade linkFacade = LinkViewContentProvider.getLinkFacade(activeProject, uniqueElement);
                if (linkFacade != null) {
                    return !linkFacade.getCrossLinks(uniqueElement.getUID(), this.MODEL_ELEMENT_LINK_TYPE_FILTER).isEmpty();
                }
            }
        } else {
            if (element instanceof IFrameData) {
                ILOLinkAccessFacade linkFacade;
                IFrameData frameData = (IFrameData)element;
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(frameData.getProjectUID());
                if (projectAgent != null && projectAgent.isOpened() && (linkFacade = LinkViewContentProvider.getLinkFacade(projectAgent, frameData)) != null) {
                    return !linkFacade.getCrossLinks(frameData.getUID(), ILinkContentProvider.NO_LINK_TYPE_FILTER).isEmpty();
                }
                return false;
            }
            if (element instanceof IndirectLinksContainer) {
                return true;
            }
            if (this.isInRoot(element) && element instanceof ICockpitProjectData) {
                return LinkViewContentProvider.hasLinkedElements((ICockpitProjectData)element);
            }
            for (ILinkContentProvider lc : this.moduleLinkViewContribution.getModuleContentProviders()) {
                if (!lc.hasChildren(element)) continue;
                return true;
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        this.rootElements = (List)inputElement;
        return this.rootElements.toArray();
    }

    public Image getImage(Object element) {
        Image image = ProjectTreeContentProvider.getImage_staticGeneral(element, this.moduleLinkViewContribution);
        if (image != null) {
            return image;
        }
        if (element instanceof IndirectLinksContainer) {
            IndirectLinksContainer container = (IndirectLinksContainer)element;
            if (container.isLinkedToComponent()) {
                return this.getShowComponentImage();
            }
            return this.getShowCompositeImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IUniqueElement) {
            IUniqueElement uniqueElement = (IUniqueElement)element;
            return uniqueElement.getElementName();
        }
        if (element instanceof IPlan) {
            IPlan plan = (IPlan)element;
            return String.valueOf(Messages.getString("LinkViewContentProvider.element_on_plan")) + plan.getPlanName();
        }
        for (IModuleLinkLabelProvider lp : this.moduleLinkViewContribution.getModuleLabelProviders()) {
            String text = lp.getText(element, this.limitedTextLength);
            if (text == null) continue;
            return text;
        }
        if (element instanceof IndirectLinksContainer) {
            IndirectLinksContainer container = (IndirectLinksContainer)element;
            if (container.isLinkedToComponent()) {
                return Messages.getString("LinkViewLabelProviderSwitch.Linked_to_Component__3");
            }
            return Messages.getString("LinkViewLabelProviderSwitch.Linked_to_Composition__4");
        }
        if (element instanceof ICockpitProjectData) {
            ICockpitDataType dataType;
            ICockpitProjectData data = (ICockpitProjectData)element;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(data.getProjectUID());
            if (projectAgent != null && projectAgent.isOpened() && (dataType = this.map_cockpitTypeID_cockpitDataType.get(data.getTypeID())) != null) {
                return dataType.getDisplayName(data);
            }
        }
        return "unknown entry type " + element.getClass();
    }

    private Image getShowComponentImage() {
        if (this.showComponentImage == null) {
            this.showComponentImage = FramePlugin.getImageDescriptor("sub_co.gif").createImage();
        }
        return this.showComponentImage;
    }

    private Image getShowCompositeImage() {
        if (this.showCompositeImage == null) {
            this.showCompositeImage = FramePlugin.getImageDescriptor("super_co.gif").createImage();
        }
        return this.showCompositeImage;
    }

    public void dispose() {
        Iterator<Image> i = this.images.values().iterator();
        while (i.hasNext()) {
            Image image = i.next();
            image.dispose();
            i.remove();
        }
        if (this.showComponentImage != null) {
            this.showComponentImage.dispose();
            this.showComponentImage = null;
        }
        if (this.showCompositeImage != null) {
            this.showCompositeImage.dispose();
            this.showCompositeImage = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

