/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.lib.dataview;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataViewProvider;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.ModuleUIPropertyChangesListenerManager;
import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.IProjectAssociationManager;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataView;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewProvider;
import de.plans.lib.util.incrementalsearch.DeltaPacket;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public abstract class CockpitTreeDataView<ContentType>
extends TreeDataView<ContentType> {
    private CockpitTreeDataViewProvider<ContentType> dataViewProvider;
    private ModuleUIPropertyChangesListenerManager uiPropertyChangesListener;
    private final IPropertyChangesListener propertyChangesListener = new IPropertyChangesListener(){

        public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
            CockpitTreeDataView.this.modelRefreshed(changes, clazz, projectUID);
        }
    };

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.uiPropertyChangesListener = new ModuleUIPropertyChangesListenerManager(this.getViewFacade(), this.dataViewProvider.getProjectAssociationManager());
    }

    @Override
    protected void createPermanentParts() {
        super.createPermanentParts();
        for (Class<?> clazz : this.dataViewProvider.getDataTypesThatTriggerRefresh()) {
            this.uiPropertyChangesListener.registerPropertyChangesListener(this.propertyChangesListener, clazz);
        }
    }

    @Override
    public void dispose() {
        this.uiPropertyChangesListener.deregisterPropertyChangesListener(this.propertyChangesListener);
        super.dispose();
    }

    private synchronized void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        if (this.isPropertyChangeRequiringExchangeOfViewer(changes, clazz)) {
            this.exchangeOfViewerRequired();
        } else {
            DeltaPacket deltaPacket = null;
            if (this.isPropertyChangeOfDisplayedItems(changes, clazz)) {
                if (!changes.isAsynchronousUpdate() && changes.getCreatedElements() != null && !changes.getCreatedElements().isEmpty()) {
                    this.setExplicitSelectionAfterRefresh(changes.getCreatedElements());
                }
                deltaPacket = new DeltaPacket(changes.getCreatedElements(), changes.getModifiedElements(), changes.getDeletedElements());
            }
            this.refreshOfViewerRequired(true, deltaPacket);
        }
    }

    protected abstract boolean isPropertyChangeRequiringExchangeOfViewer(IPropertyChanges<?> var1, Class<?> var2);

    protected abstract boolean isPropertyChangeOfDisplayedItems(IPropertyChanges<?> var1, Class<?> var2);

    public ModuleUIPropertyChangesListenerManager getUIPropertyChangesListenerManager() {
        return this.uiPropertyChangesListener;
    }

    @Override
    protected final TreeDataViewProvider<ContentType> createTreeDataViewProvider() {
        this.dataViewProvider = this.createCockpitTreeDataViewProvider();
        return this.dataViewProvider;
    }

    protected abstract CockpitTreeDataViewProvider<ContentType> createCockpitTreeDataViewProvider();

    @Override
    protected IProjectAssociationManager getProjectAssociationManager() {
        return this.dataViewProvider.getProjectAssociationManager();
    }
}

