/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.dnd;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.editors.UniqueElementOccurrenceListTransfer;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferAgent;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.lib.eclipse.transfer.TransferContentBackdoorStorage;
import com.arcway.lib.eclipse.transfer.dnd.IDragSourceListener;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanElementTypeDescription;
import com.arcway.planagent.controllinginterface.planeditor.plugin.PlanEditorExtensionMgr;
import com.arcway.planagent.controllinginterface.planeditor.plugin.TransferableTemplate;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class ViewItemDragSourceListener
implements IDragSourceListener {
    private final ISelectionProvider selectionProvider;
    private int supportedOperations = 0;
    private DragSource dragAgent;

    public ViewItemDragSourceListener(ISelectionProvider selectionProvider, int supportedOperations) {
        assert (selectionProvider != null);
        this.selectionProvider = selectionProvider;
        this.supportedOperations = supportedOperations;
    }

    public void dragStart(DragSourceEvent event) {
        this.dragAgent.setTransfer(new Transfer[]{MultipleObjectTransferAgent.getInstance()});
        Collection<MultipleObjectTransferContent> content = this.createContent();
        if (content != null) {
            TransferContentBackdoorStorage.setContent((Object)this, (MultipleObjectTransferContent)new MultipleObjectTransferContent(content, (AbstractTransferAgentForMultipleObjectTransfer)MultipleObjectTransferAgent.getInstance()));
            event.image = null;
        } else {
            event.doit = false;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        Collection<MultipleObjectTransferContent> content = (Collection<MultipleObjectTransferContent>)TransferContentBackdoorStorage.getContent((AbstractTransferAgentForMultipleObjectTransfer)MultipleObjectTransferAgent.getInstance(), (Object)this);
        if (content == null) {
            content = this.createContent();
        }
        if (content != null) {
            event.data = content;
        }
    }

    public void dragFinished(DragSourceEvent event) {
        TransferContentBackdoorStorage.clearContent((Object)this);
    }

    private Collection<MultipleObjectTransferContent> createContent() {
        ArrayList<MultipleObjectTransferContent> contentCollection = null;
        ISelection sel = this.selectionProvider.getSelection();
        IStructuredSelection selection = (IStructuredSelection)sel;
        Object dragData = selection.getFirstElement();
        if (dragData instanceof IUniqueElement) {
            final IUniqueElement ue = (IUniqueElement)dragData;
            ArrayList tmps = new ArrayList();
            Collection<PlanElementTypeDescription> descrs = ExtensionMgr.getDefault().getPlanElementTypeDescriptionForConstructionElementType(ue.getElementTypeID());
            for (PlanElementTypeDescription descr : descrs) {
                tmps.addAll(PlanEditorExtensionMgr.getDefault().getTransferableTemplates(descr.getPlanElementTypeID(), ue.getElementName(), null));
            }
            ArrayList<1> occurenceList = new ArrayList<1>(tmps.size());
            contentCollection = new ArrayList<MultipleObjectTransferContent>(tmps.size() + 1);
            for (final TransferableTemplate t : tmps) {
                contentCollection.add(t.getTransferableTemplate());
                IUniqueElementOccurrence occurenceToCreate = new IUniqueElementOccurrence(){

                    public String getElementUID() {
                        return ue.getUID();
                    }

                    public String getProjectUID() {
                        return ue.getProjectUID();
                    }

                    public String getPlanElementUID() {
                        return t.getPlanElement().getPlanElementUID();
                    }

                    public String getPlanUID() {
                        return "template";
                    }
                };
                occurenceList.add(occurenceToCreate);
            }
            contentCollection.add(new MultipleObjectTransferContent(UniqueElementOccurrenceListTransfer.createListToTransfer(occurenceList), (AbstractTransferAgentForMultipleObjectTransfer)UniqueElementOccurrenceListTransfer.getInstance()));
        }
        return contentCollection;
    }

    public int getSupportedOperations() {
        return this.supportedOperations;
    }

    public void setSWTDragAgent(DragSource dragSource) {
        this.dragAgent = dragSource;
    }
}

