/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.validators;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import org.eclipse.jface.dialogs.IInputValidator;

public class RenamePlanValidator
implements IInputValidator {
    private final IFrameProjectAgent projectAgent;
    private final String sectionUID;
    private IPlan originalPlan;

    public RenamePlanValidator(IPlan plan) {
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
        this.sectionUID = plan.getSectionUID();
        this.originalPlan = plan;
    }

    public RenamePlanValidator(IFrameProjectAgent projectAgent, String sectionUID) {
        this.projectAgent = projectAgent;
        this.sectionUID = sectionUID;
    }

    public String isValid(String newText) {
        if (newText == null || newText.trim().equals("")) {
            return Messages.getString("RenamePlanValidator.The_plan_name_mustn__t_be_empty._3");
        }
        if (newText.length() > 250) {
            return String.valueOf(Messages.getString("RenamePlanValidator.0")) + 250 + Messages.getString("RenamePlanValidator.1");
        }
        if (this.planAlreadyExistsInParent(newText.trim())) {
            return Messages.getString("RenamePlanValidator.The_parent_folder_already_contains_a_plan_with_that_name_!_5");
        }
        return null;
    }

    private boolean planAlreadyExistsInParent(String planName) {
        ISection parentSection = this.projectAgent.getFrameSectionManager().getSection(this.sectionUID);
        for (IPlan iPlan : this.projectAgent.getFrameSectionManager().getChildPlans(parentSection)) {
            if (!iPlan.getPlanName().equalsIgnoreCase(planName) || this.originalPlan != null && iPlan.getUID().equals(this.originalPlan.getUID())) continue;
            return true;
        }
        return false;
    }
}

