/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyReportTemplates;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportOutputtemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.AttributeTypesComposite;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeValueModifiedListener;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorManager;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplateType;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.file.UIFileValidator;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyGeneralReportOutputtemplates
implements IPropertiesListEntry {
    private static final ILogger logger = Logger.getLogger(PropertyGeneralReportOutputtemplates.class);
    private static final String DEFAULT_MESSAGE = Messages.getString("PropertyGeneral.Shows_all_general_properties_of_this__2");
    private IAttributeOwnerRW outputtemplate;
    private IFrameProjectAgent projectAgent;
    private IPropertiesDialog dialog;
    private AttributeTypesComposite attributeTypesComposite;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.outputtemplate = (IAttributeOwnerRW)elements[0];
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.outputtemplate.getProjectUID());
        IAttribute reportOutputFormat = this.outputtemplate.getAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_REPORTOUTPUTTEMPLATETYPEID);
        IAttributeType attributeType = this.outputtemplate.getAttributeType(ReportOutputtemplateAttributeTypesProvider.ATTRID_REPORTOUTPUTTEMPLATETYPEID);
        Object currentValue = reportOutputFormat.getAttributeValue();
        Object defaultValue = attributeType.getDataType().getDefaultValue();
        if (attributeType.getDataType().getComparator(attributeType.getValueRange()).compare(currentValue, defaultValue) != 0) {
            this.projectAgent.getDocGeneratorManager();
            if (DocGeneratorManager.getReportOutputFormat((String)reportOutputFormat.getAttributeValue()) == null) {
                return new ModificationProblem(Messages.getString("PropertiesGeneralReportOutputtemplates.ReportTypecannotBeUsed"), NLS.bind((String)Messages.getString("PropertiesGeneralReportOutputtemplates.ReportTypeUnknownOrNotCompatible"), (Object)reportOutputFormat.getAttributeValue()));
            }
        }
        this.setDialog(newDialog);
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1 && elements[0] instanceof IAttributeOwner) {
            IAttributeOwner attributeOwner = (IAttributeOwner)elements[0];
            return attributeOwner.getTypeID().equals(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE);
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyGeneral.General_1");
    }

    @Override
    public Image getPropertyImage() {
        return FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE).getIcon();
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        this.dialog.setTitle(FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE).getDisplayName(), this);
        this.dialog.setMessage(DEFAULT_MESSAGE, 0, this);
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        this.attributeTypesComposite = new AttributeTypesComposite(this.outputtemplate, parent, true, false, false, this.dialog, this);
        this.attributeTypesComposite.create(new GridData(1808));
        IAttributeValueModifiedListener reportTypeModListener = new IAttributeValueModifiedListener(){

            @Override
            public Collection<IModificationProblem> modified(Object newValue, Object additionalInfo) {
                IReportOutputTemplateType reportOutputTemplateType = PropertyGeneralReportOutputtemplates.this.projectAgent.getDocGeneratorManager().getReportOutputTemplateType((String)newValue);
                if (reportOutputTemplateType != null) {
                    Tuple<IAttribute, Object> currentFileValue = PropertyGeneralReportOutputtemplates.this.attributeTypesComposite.getCurrentAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_FILE);
                    PropertyGeneralReportOutputtemplates.this.attributeTypesComposite.setEnabled(ReportOutputtemplateAttributeTypesProvider.ATTRID_FILE, true);
                    return PropertyGeneralReportOutputtemplates.this.fileModified((Tuple<IAttribute, Object>)currentFileValue, reportOutputTemplateType);
                }
                return Collections.emptyList();
            }
        };
        this.attributeTypesComposite.addModificationListener(ReportOutputtemplateAttributeTypesProvider.ATTRID_REPORTOUTPUTTEMPLATETYPEID, reportTypeModListener);
        IAttributeValueModifiedListener fileModListener = new IAttributeValueModifiedListener(){

            @Override
            public Collection<IModificationProblem> modified(Object newValue, Object additionalInfo) {
                Tuple<IAttribute, Object> reportOutputTemplateTypeAttribute = PropertyGeneralReportOutputtemplates.this.attributeTypesComposite.getCurrentAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_REPORTOUTPUTTEMPLATETYPEID);
                IReportOutputTemplateType reportOutputTemplateType = PropertyGeneralReportOutputtemplates.this.projectAgent.getDocGeneratorManager().getReportOutputTemplateType((String)((IAttribute)reportOutputTemplateTypeAttribute.getT1()).getAttributeValue());
                if (reportOutputTemplateType != null) {
                    return PropertyGeneralReportOutputtemplates.this.fileModified((Tuple<IAttribute, Object>)new Tuple((Object)new Attribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_FILE, newValue), additionalInfo), reportOutputTemplateType);
                }
                return Collections.emptyList();
            }
        };
        this.attributeTypesComposite.addModificationListener(ReportOutputtemplateAttributeTypesProvider.ATTRID_FILE, fileModListener);
        return this.attributeTypesComposite.getComposite();
    }

    private Collection<IModificationProblem> fileModified(Tuple<IAttribute, Object> fileValue, IReportOutputTemplateType reportOutputTemplateType) {
        File file = null;
        boolean fileIsFromArchive = false;
        FileID fileID = null;
        if (fileValue.getT2() == AttributeTypesComposite.ADDITIONALINFORMATION_FOR_UNMODIFIEDATTRIBUTE) {
            try {
                fileID = (FileID)((IAttribute)fileValue.getT1()).getAttributeValue();
                if (!fileID.equals(FileID.NO_FILE)) {
                    file = this.projectAgent.getFilesManager().getFile(fileID);
                    fileIsFromArchive = true;
                }
            }
            catch (ServerNotAvailableException e) {
                logger.error("Can't retrieve file.", (Throwable)e);
            }
            catch (EXServerException e) {
                logger.error("Can't retrieve file.", (Throwable)e);
            }
            catch (LoginCanceledException e) {
                logger.error("Can't retrieve file.", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.error("Can't retrieve file.", (Throwable)e);
            }
            catch (ExPrematureEndOfTransfer e) {
                logger.error("Can't retrieve file.", (Throwable)e);
            }
        } else {
            file = (File)fileValue.getT2();
        }
        List<IModificationProblem> problems = Collections.emptyList();
        UIFileValidator fileValidator = reportOutputTemplateType.getFileValidator();
        IModificationProblem problem = fileValidator.getInvalidityReason(file);
        if (problem != null) {
            problems = Collections.singleton(problem);
        }
        if (fileIsFromArchive) {
            try {
                FileHelper.deleteExistingFileOrDirectory((File)file);
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.warn("Could not delete file retrieved from file archive.", (Throwable)e);
            }
        }
        return problems;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return this.attributeTypesComposite.isModified();
    }

    @Override
    public void commitPropertyChanges1() {
        for (IAttribute attribute : this.newAttributes) {
            try {
                this.outputtemplate.setAttribute(attribute);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXNoLock e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
    }

    @Override
    public void disposeResources() {
        if (this.attributeTypesComposite != null) {
            this.attributeTypesComposite.dispose();
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.newAttributes = this.attributeTypesComposite.getNewAttributes();
        for (IAttribute attribute : this.newAttributes) {
            this.outputtemplate.requestAttributeModificationPermission(attribute, this.transactionController);
        }
        return this.transactionController.execute();
    }

    @Override
    public void rollbackCommitRequest() {
        this.transactionController.rollback();
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public int getTypeOfPage() {
        return 0;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        if (this.attributeTypesComposite != null) {
            return this.attributeTypesComposite.getModificationProblems(true);
        }
        return Collections.emptyList();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeModifyReportTemplates.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }
}

