/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.stakeholder;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.AbstractDialogWithCategorySelection;
import com.arcway.cockpit.frame.client.global.gui.dialogs.ChoosePermissionOwnerDialog;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameStakeholderValidator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import de.plans.psc.shared.message.EOUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddStakeholderDialog
extends AbstractDialogWithCategorySelection {
    private Text nameText;
    private Text userText;
    private Text emailText;
    private Text descriptionText;
    private Text companyText;
    private Text telephoneText;
    private Text faxText;
    private Text addressText;
    private String newName;
    private Map<IAttributeTypeID, IAttribute> attributes = new HashMap<IAttributeTypeID, IAttribute>();
    private final Collection<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return AddStakeholderDialog.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };
    private final RenameStakeholderValidator inputValidator;
    private Combo categoryCombo;

    public AddStakeholderDialog(Shell parentShell, IFrameProjectAgent projectAgent) {
        super(parentShell, true, projectAgent);
        this.projectAgent = projectAgent;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.inputValidator = new RenameStakeholderValidator(projectAgent);
    }

    @Override
    protected Control createDialogArea_internal(Composite parent) {
        this.getShell().setText(Messages.getString("AddStakeholderDialog.Create_new_Stakeholder_1"));
        this.setTitle(Messages.getString("AddStakeholderDialog.Create_new_Stakeholder_2"));
        this.setMessage(Messages.getString("AddStakeholderDialog.Please_enter_the_values_3"));
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(base, 256);
        GridDataFactory.fillDefaults().align(4, 2).grab(false, false).applyTo((Control)label);
        label.setText(String.valueOf(ObjectTypeCategoryLabels.LABEL_CATEGORY) + ":");
        this.categoryCombo = new Combo(base, 12);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(1, 1).applyTo((Control)this.categoryCombo);
        LineSeparator line = new LineSeparator(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)line);
        Label space = new Label(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(3, 1).applyTo((Control)space);
        Label nameLabel = new Label(base, 0);
        nameLabel.setText(Messages.getString("AddStakeholderDialog.Name_4"));
        this.nameText = new Text(base, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText("");
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddStakeholderDialog.this.setErrorMessage(AddStakeholderDialog.this.inputValidator.isValid(AddStakeholderDialog.this.nameText.getText()));
                AddStakeholderDialog.this.setValue(StakeholderAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(AddStakeholderDialog.this.nameText.getText(), null, null));
            }
        });
        new Label(base, 0);
        Label userLabel = new Label(base, 0);
        userLabel.setText(Messages.getString("AddStakeholderDialog.Server_User_6"));
        this.userText = new Text(base, 2048);
        this.userText.setLayoutData((Object)new GridData(768));
        this.userText.setEditable(false);
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddStakeholderDialog.this.setValue(StakeholderAttributeTypesProvider.ATTRID_USERNAME, DataTypeString.getInstanceString().getAttributeValueFromString(AddStakeholderDialog.this.userText.getText(), null, null));
            }
        });
        Button selectUserButton = new Button(base, 0);
        selectUserButton.setText("...");
        selectUserButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddStakeholderDialog.this.getUserFromList();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        selectUserButton.setEnabled(ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.projectAgent.getServerID()).arePermissionsNeeded() && this.checkModPermission(StakeholderAttributeTypesProvider.ATTRID_USERNAME));
        Label companyLabel = new Label(base, 0);
        companyLabel.setText(Messages.getString("AddStakeholderDialog.Company_1"));
        this.companyText = new Text(base, 2048);
        this.companyText.setLayoutData((Object)new GridData(768));
        this.companyText.setText("");
        this.companyText.setEditable(this.checkModPermission(StakeholderAttributeTypesProvider.ATTRID_COMPANY));
        this.companyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddStakeholderDialog.this.setValue(StakeholderAttributeTypesProvider.ATTRID_COMPANY, DataTypeString.getInstanceString().getAttributeValueFromString(AddStakeholderDialog.this.companyText.getText(), null, null));
            }
        });
        new Label(base, 0);
        Label phoneLabel = new Label(base, 0);
        phoneLabel.setText(Messages.getString("AddStakeholderDialog.Telephone_3"));
        this.telephoneText = new Text(base, 2048);
        this.telephoneText.setLayoutData((Object)new GridData(768));
        this.telephoneText.setText("");
        this.telephoneText.setEditable(this.checkModPermission(StakeholderAttributeTypesProvider.ATTRID_PHONE));
        this.telephoneText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddStakeholderDialog.this.setValue(StakeholderAttributeTypesProvider.ATTRID_PHONE, DataTypeString.getInstanceString().getAttributeValueFromString(AddStakeholderDialog.this.telephoneText.getText(), null, null));
            }
        });
        new Label(base, 0);
        Label faxLabel = new Label(base, 0);
        faxLabel.setText(Messages.getString("AddStakeholderDialog.Fax_5"));
        this.faxText = new Text(base, 2048);
        this.faxText.setLayoutData((Object)new GridData(768));
        this.faxText.setText("");
        this.faxText.setEditable(this.checkModPermission(StakeholderAttributeTypesProvider.ATTRID_FAX));
        this.faxText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddStakeholderDialog.this.setValue(StakeholderAttributeTypesProvider.ATTRID_FAX, DataTypeString.getInstanceString().getAttributeValueFromString(AddStakeholderDialog.this.faxText.getText(), null, null));
            }
        });
        new Label(base, 0);
        Label emailLabel = new Label(base, 0);
        emailLabel.setText(Messages.getString("AddStakeholderDialog.EMail_8"));
        this.emailText = new Text(base, 2048);
        this.emailText.setLayoutData((Object)new GridData(768));
        this.emailText.setText("");
        this.emailText.setEditable(this.checkModPermission(StakeholderAttributeTypesProvider.ATTRID_EMAIL));
        this.emailText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddStakeholderDialog.this.setValue(StakeholderAttributeTypesProvider.ATTRID_EMAIL, DataTypeString.getInstanceString().getAttributeValueFromString(AddStakeholderDialog.this.emailText.getText(), null, null));
            }
        });
        new Label(base, 0);
        Label addressLabel = new Label(base, 0);
        addressLabel.setText(Messages.getString("AddStakeholderDialog.Address_7"));
        this.addressText = new Text(base, 2562);
        GridData data = new GridData(1808);
        data.heightHint = 50;
        this.addressText.setLayoutData((Object)data);
        this.addressText.setText("");
        this.addressText.setEditable(this.checkModPermission(StakeholderAttributeTypesProvider.ATTRID_ADDRESS));
        this.addressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddStakeholderDialog.this.setValue(StakeholderAttributeTypesProvider.ATTRID_ADDRESS, DataTypeText.getInstanceText().getAttributeValueFromString(AddStakeholderDialog.this.addressText.getText(), null, null));
            }
        });
        new Label(base, 0);
        Label descriptionLabel = new Label(base, 0);
        IAttributeTypesProvider stakeholderAttributeTypeProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.stakeholder");
        IAttributeType descrType = stakeholderAttributeTypeProv.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_DESCRIPTION);
        descriptionLabel.setText(descrType.getDisplayName());
        this.descriptionText = new Text(base, 2562);
        GridData descriptionData = new GridData(1808);
        descriptionData.heightHint = 50;
        this.descriptionText.setLayoutData((Object)descriptionData);
        this.descriptionText.setText("");
        this.descriptionText.setEditable(this.checkModPermission(StakeholderAttributeTypesProvider.ATTRID_DESCRIPTION));
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddStakeholderDialog.this.setValue(StakeholderAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(AddStakeholderDialog.this.descriptionText.getText(), null, null));
            }
        });
        return base;
    }

    private void setValue(IAttributeTypeID attributeTypeID, Object value) {
        IAttribute attribute = this.attributes.get(attributeTypeID);
        if (attribute == null) {
            attribute = new Attribute(attributeTypeID, value);
            this.attributes.put(attributeTypeID, attribute);
        } else {
            attribute.setAttributeValue(value);
        }
    }

    private boolean checkModPermission(IAttributeTypeID attributeTypeID) {
        IAttributeTypesProvider attributeTypeProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.stakeholder");
        IAttributeType attributeType = attributeTypeProv.getAttributeType(attributeTypeID);
        if (!this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeType, this.operandTree, true)) {
            this.modificationProblems.add(new ModificationProblem(attributeType, this.operandTree, this.projectAgent));
            return false;
        }
        return true;
    }

    protected void okPressed() {
        this.newName = this.nameText.getText().trim();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.newName = null;
        this.attributes = null;
        super.cancelPressed();
    }

    public String getNewStakeholderName() {
        return this.newName;
    }

    public Collection<IAttribute> getNewStakeholderAttributes() {
        return this.attributes.values();
    }

    public void setErrorMessage(String msg) {
        this.getButton(0).setEnabled(msg == null);
        super.setErrorMessage(msg);
    }

    private void getUserFromList() {
        Object[] serverUsers;
        ChoosePermissionOwnerDialog dialog = new ChoosePermissionOwnerDialog(this.getShell(), this.projectAgent, Messages.getString("AddStakeholderDialog.select_server_user"), Messages.getString("AddStakeholderDialog.assign_server_user_2_stakeholder"), 0, true);
        dialog.setBlockOnOpen(true);
        int ok = dialog.open();
        if (ok == 0 && (serverUsers = dialog.getResult()).length > 0) {
            EOUser user = (EOUser)serverUsers[0];
            this.userText.setText(user.getUserName());
            if (this.descriptionText.getEditable()) {
                this.descriptionText.setText(user.getDescription());
                this.setValue(StakeholderAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(this.descriptionText.getText(), null, null));
            }
            if (this.emailText.getEditable()) {
                this.emailText.setText(user.getEmail());
                this.setValue(StakeholderAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(this.emailText.getText(), null, null));
            }
            if (this.nameText.getEditable()) {
                this.nameText.setText(user.getDisplayName());
                this.setValue(StakeholderAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(this.nameText.getText(), null, null));
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button btn = this.getButton(0);
        if (btn != null) {
            btn.setEnabled(false);
        }
    }

    protected void dispose() {
    }

    @Override
    protected Combo getCategoryCombo() {
        return this.categoryCombo;
    }

    @Override
    protected String getFrameDataTypeID() {
        return "com.arcway.cockpit.stakeholder";
    }
}

