/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.locking;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.locking.LockingAdminLockTreeContentProvider;
import com.arcway.cockpit.frame.client.global.gui.dialogs.locking.LockingAdminLockTreeLabelProvider;
import com.arcway.cockpit.frame.client.global.gui.dialogs.locking.LockingAdminProjectDictionary;
import com.arcway.cockpit.frame.client.global.gui.dialogs.locking.LockingAdminTreeContentEntry;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class LockingAdmin {
    private final String DIALOG_TITLE = Messages.getString("LockingAdmin.List_of_all_locks_of_all_connected_servers._1");
    private final String DIALOG_EMPTY_LIST_MSG = Messages.getString("LockingAdmin.No_locks_set._2");
    private final String DIALOG_OK_BUTTON_MSG = Messages.getString("LockingAdmin.Remove_3");
    private final ILogger logger = Logger.getLogger(this.getClass());
    private final Shell parentShell;

    public LockingAdmin(Shell parentShell) {
        this.parentShell = parentShell;
    }

    public void start() {
        List conns = PSCServices.getServiceFacade().getServerConnections();
        LockingAdminProjectDictionary projectDictionary = new LockingAdminProjectDictionary();
        LockingAdminLockTreeContentProvider contentProvider = new LockingAdminLockTreeContentProvider();
        for (ServerConnection sc : conns) {
            if (!sc.isConnected()) continue;
            IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(sc.getServerID());
            try {
                contentProvider.addTreeContent((EOList<EOLock>)new EOList(serverProxy.getAllLocksOnServer()), sc, projectDictionary);
            }
            catch (LoginCanceledException lce) {
                this.logger.debug(33, "login canceled by user");
            }
            catch (ServerNotAvailableException e) {
                this.logger.info("Server " + serverProxy.getServerName() + " is not available.");
            }
            catch (EXServerException e) {
                this.logger.error("could not execute", (Throwable)e);
            }
            catch (UnknownServerException e) {
                this.logger.error("could not execute", (Throwable)e);
            }
        }
        List<LockingAdminTreeContentEntry> locks = this.getLocksToRemove(contentProvider);
        for (ServerConnection sc : conns) {
            this.removeLocks(sc.getServerID(), locks);
        }
    }

    private void removeLocks(String serverID, List<LockingAdminTreeContentEntry> locks) {
        EOList simpleLocks = new EOList();
        ArrayList<LockingAdminTreeContentEntry> notRemovedLocks = new ArrayList<LockingAdminTreeContentEntry>();
        for (LockingAdminTreeContentEntry ce : locks) {
            if (!ce.getServerID().equals(serverID)) continue;
            if (this.isAdmin(ce.getServerID())) {
                simpleLocks.add((EncodableObjectBase)ce.getLock());
                continue;
            }
            notRemovedLocks.add(ce);
        }
        if (!simpleLocks.isEmpty()) {
            try {
                ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID).removeLocks((Collection<EOLock>)simpleLocks);
            }
            catch (Throwable t) {
                this.logger.error("could not remove locks", t);
            }
        }
        if (!notRemovedLocks.isEmpty()) {
            this.showNotRemovedLocks(notRemovedLocks);
        }
    }

    private void showNotRemovedLocks(List<LockingAdminTreeContentEntry> locks) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String msg = Messages.getString("LockingAdmin.Locks_for_the_following_projects_have_not_been_removed_because_the_user_has_not_administration_permission_on_the_server__n_n_7");
        ArrayList<String> projects = new ArrayList<String>();
        for (LockingAdminTreeContentEntry lock : locks) {
            String name = ProjectMgr.getProjectMgr().getProjectName(lock.getLock().getProjectUID(), lock.getServerID());
            if (projects.contains(name)) continue;
            projects.add(name);
            msg = String.valueOf(msg) + name + "\n";
        }
        MessageDialog mDialog = new MessageDialog(shell, Messages.getString("LockingAdmin.Could_not_remove_locks_6"), null, msg, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        mDialog.open();
    }

    private boolean isAdmin(String serverID) {
        boolean isAdmin = false;
        try {
            isAdmin = PSCServices.getServiceFacade().isAdminUser(serverID, true);
        }
        catch (Exception e) {
            this.logger.error("Cannot acquire if user is AdminUser due to server exception.", (Throwable)e);
        }
        return isAdmin;
    }

    private List<LockingAdminTreeContentEntry> getLocksToRemove(LockingAdminLockTreeContentProvider contentProvider) {
        MessageDialog.openWarning((Shell)this.parentShell, (String)Messages.getString("LockingAdmin.remove_locks"), (String)Messages.getString("LockingAdmin.will_cause_data_lost"));
        LockingAdminLockTreeLabelProvider labelProvider = new LockingAdminLockTreeLabelProvider();
        CheckedTreeSelectionDialog dlg = new CheckedTreeSelectionDialog(this.parentShell, labelProvider, contentProvider){

            protected void okPressed() {
                boolean deletionConfirmed = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("LockingAdmin.DeleteConfirmation.Title"), (String)Messages.getString("LockingAdmin.DeleteConfirmation.Message"));
                if (deletionConfirmed) {
                    super.okPressed();
                }
            }
        };
        dlg.setSorter(new ViewerSorter(){});
        dlg.setBlockOnOpen(true);
        dlg.setTitle(this.DIALOG_TITLE);
        dlg.setEmptyListMessage(this.DIALOG_EMPTY_LIST_MSG);
        dlg.setInput((Object)contentProvider.getRootEntry());
        dlg.setContainerMode(true);
        dlg.create();
        Button okButton = dlg.getOkButton();
        okButton.setText(this.DIALOG_OK_BUTTON_MSG);
        dlg.open();
        ArrayList<LockingAdminTreeContentEntry> locks = new ArrayList<LockingAdminTreeContentEntry>();
        if (dlg.getReturnCode() == 0) {
            int i = 0;
            while (i < dlg.getResult().length) {
                LockingAdminTreeContentEntry ce = (LockingAdminTreeContentEntry)dlg.getResult()[i];
                if (ce.isLock()) {
                    locks.add(ce);
                }
                ++i;
            }
        }
        return locks;
    }
}

