/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions.test;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.ServerPermissionChecker;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.CreateNewProjectWizard;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.GetProjectFromServerDialog;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsCreate;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsLoad;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsNumber;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class NewProjectAction
extends Action {
    private static final ILogger logger = Logger.getLogger(NewProjectAction.class);
    public static final int CREATE_NEW_PROJECT = 1;
    public static final int GET_PROJECT_FROM_SERVER = 2;
    private final ISelectionProvider selectionProvider;
    private final int mode;
    private final Shell parentShell;
    private final IWorkbenchPage workbenchPage;

    public NewProjectAction(ISelectionProvider selectionProvider, int mode, IWorkbenchPage workbenchPage) {
        this.selectionProvider = selectionProvider;
        this.parentShell = workbenchPage.getWorkbenchWindow().getShell();
        this.workbenchPage = workbenchPage;
        switch (mode) {
            case 1: {
                this.setText(Messages.getString("NewProjectAction.Project..._1"));
                this.setToolTipText(Messages.getString("NewProjectAction.Creates_a_new_project_on_the_selected_server_2"));
                break;
            }
            case 2: {
                break;
            }
            default: {
                assert (false) : "invalid mode";
                break;
            }
        }
        this.setDescription(this.getToolTipText());
        this.setImageDescriptor(FramePlugin.getImageDescriptor("new_project.gif"));
        this.mode = mode;
    }

    public void update() {
        ServerConnection serverConnection = this.getSelectedServer();
        if (serverConnection == null) {
            this.setEnabled(false);
        } else {
            Object licenseValue;
            IProjectManagerServerProxy sp = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverConnection.getServerID());
            IClientFunctionLicenseManager slm = sp.getFunctionLicenseManager();
            boolean hasLicense = false;
            IClientFunctionLicense lic = null;
            switch (this.mode) {
                case 1: {
                    this.setText(Messages.getString("NewProjectAction.Project..._1"));
                    this.setToolTipText(Messages.getString("NewProjectAction.Creates_a_new_project_on_the_selected_server_2"));
                    lic = slm.findClientFunctionLicense(ClientFunctionLicenseTypeProjectsCreate.getInstance());
                    break;
                }
                case 2: {
                    this.setText(sp.getGetProjectFromServerLabel());
                    this.setToolTipText(sp.getGetProjectFromServerDescription());
                    lic = slm.findClientFunctionLicense(ClientFunctionLicenseTypeProjectsLoad.getInstance());
                    break;
                }
                default: {
                    assert (false) : "invalid mode";
                    break;
                }
            }
            int nrOfProjects = ProjectMgr.getProjectMgr().getConfiguredProjects().length;
            int maxProjects = 0;
            if (lic != null && (licenseValue = lic.getValue()) != null && ((Boolean)licenseValue).booleanValue()) {
                maxProjects = ClientFunctionLicenseTypeProjectsNumber.getMaxNumberOfProjects(slm);
            }
            if (maxProjects < 0 || maxProjects > nrOfProjects) {
                hasLicense = true;
            }
            this.setDescription(this.getToolTipText());
            this.setImageDescriptor(FramePlugin.getImageDescriptor("new_project.gif"));
            ServerConnection sc = ProjectMgr.getProjectMgr().getGeneralServerProxy().getServerConnection(this.getSelectedServer().getServerID());
            if (sc != null && sc.isConnected()) {
                if (this.mode == 1) {
                    this.setEnabled(hasLicense && ServerPermissionChecker.mayCreateProjects(this.getSelectedServer().getServerID(), false));
                } else {
                    this.setEnabled(ProjectMgr.getProjectMgr().getProjectManagerServerProxy(sc.getServerID()).offersProjectsForDownload());
                }
            } else if (this.mode == 1) {
                this.setEnabled(hasLicense);
            } else {
                this.setEnabled(hasLicense);
            }
        }
    }

    public void run() {
        ServerConnection sc = this.getSelectedServer();
        if (sc == null) {
            return;
        }
        NewProjectAction.run(sc, this.parentShell, this.mode, this.workbenchPage, null);
    }

    private ServerConnection getSelectedServer() {
        ISelection sel = this.selectionProvider.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ssel = (IStructuredSelection)sel;
        if (ssel.getFirstElement() instanceof ServerConnection) {
            return (ServerConnection)ssel.getFirstElement();
        }
        return null;
    }

    public static void run(ServerConnection sc, Shell parentShell, int mode, IWorkbenchPage workbenchPage, EOProject[] projectsAvailableOnServer) {
        Object licenseValue;
        String serverAvailability = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(sc.getServerID()).getServerAvailabilityState();
        if (serverAvailability != null) {
            String title = Messages.getString("NewProjectAction.cannot_create");
            String msg = String.valueOf(Messages.getString("NewProjectAction.reason")) + serverAvailability;
            MessageDialog.openError((Shell)parentShell, (String)title, (String)msg);
            return;
        }
        if (!ProjectMgr.getProjectMgr().connectToServer(sc.getServerID())) {
            return;
        }
        int nrOfLocalProjects = ProjectMgr.getProjectMgr().getConfiguredProjects().length;
        IProjectManagerServerProxy sp = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(sc.getServerID());
        IClientFunctionLicense createLicense = null;
        createLicense = mode == 1 ? sp.getFunctionLicenseManager().findClientFunctionLicense(ClientFunctionLicenseTypeProjectsCreate.getInstance()) : sp.getFunctionLicenseManager().findClientFunctionLicense(ClientFunctionLicenseTypeProjectsLoad.getInstance());
        int maxNr = 0;
        if (createLicense != null && (licenseValue = createLicense.getValue()) != null && ((Boolean)licenseValue).booleanValue()) {
            maxNr = ClientFunctionLicenseTypeProjectsNumber.getMaxNumberOfProjects(sp.getFunctionLicenseManager());
        }
        if (maxNr >= 0 && maxNr <= nrOfLocalProjects) {
            MessageDialog mDialog = new MessageDialog(parentShell, Messages.getString("NewProjectAction.no_more_projects_allowed"), null, String.valueOf(Messages.getString("NewProjectAction.not_allowed_to_create_more")) + maxNr + Messages.getString("NewProjectAction.projects_on_this_client"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            return;
        }
        switch (mode) {
            case 1: {
                boolean serverIsAvailable = sc.isConnected();
                if (!serverIsAvailable) break;
                boolean mayCreateProjects = ServerPermissionChecker.mayCreateProjects(sc.getServerID(), false);
                if (mayCreateProjects) {
                    CreateNewProjectWizard newProjectWizard = new CreateNewProjectWizard(workbenchPage, sc);
                    WizardDialog createNewDialog = new WizardDialog(parentShell, (IWizard)newProjectWizard);
                    createNewDialog.open();
                    break;
                }
                MessageDialog mDialog = new MessageDialog(parentShell, Messages.getString("NewProjectAction.Missing_permission"), null, Messages.getString("NewProjectAction.The_connected_user_is_not_allowed_to_create_projects."), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                break;
            }
            case 2: {
                try {
                    EOProject[] projects = projectsAvailableOnServer != null ? projectsAvailableOnServer : sp.getAvailableProjectsFromServer(parentShell);
                    String title = sp.getGetProjectFromServerLabel();
                    String message = sp.getGetProjectFromServerDescription();
                    if (projects != null) {
                        GetProjectFromServerDialog getFromServerDialog = new GetProjectFromServerDialog(workbenchPage, sc, projects, title, title, message);
                        getFromServerDialog.setBlockOnOpen(true);
                        getFromServerDialog.open();
                    }
                    return;
                }
                catch (ServerNotAvailableException e) {
                    logger.error("could not get project from server", (Throwable)e);
                    break;
                }
                catch (EXServerException e) {
                    logger.error("could not get project from server", (Throwable)e);
                    break;
                }
                catch (LoginCanceledException e) {
                    break;
                }
                catch (UnknownServerException e) {
                    logger.error("could not get project from server", (Throwable)e);
                    break;
                }
            }
            default: {
                assert (false) : "invalid mode";
                break;
            }
        }
    }
}

