/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.data;

import com.arcway.cockpit.errorreporting.data.CockpitLogFetcher;
import com.arcway.cockpit.errorreporting.data.IDataFetcher;
import com.arcway.cockpit.frame.client.global.license.ClientLicenseFilesManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;

public class LicensesFetcher
implements IDataFetcher {
    private static final ILogger LOGGER = Logger.getLogger(CockpitLogFetcher.class);

    @Override
    public void fetchData(File sessionTempSubDir) {
        int i = 1;
        File destinationParentLicenseDir = new File(sessionTempSubDir, "Licenses");
        Collection licenseFileDirs = ClientLicenseFilesManager.getLicenseFileDirs();
        destinationParentLicenseDir.mkdir();
        for (File licenseDir : licenseFileDirs) {
            if (!licenseDir.exists()) continue;
            File destinationLicenseDir = new File(destinationParentLicenseDir, String.valueOf(licenseDir.getName()) + i);
            File licenseDirInfoFile = new File(destinationLicenseDir, "Info.txt");
            try {
                destinationLicenseDir.mkdir();
                licenseDirInfoFile.createNewFile();
                FileHelper.copyDirectoryContent((File)licenseDir, (File)destinationLicenseDir);
                String licenseDirInfoTxt = licenseDir.getAbsolutePath();
                BufferedWriter fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(licenseDirInfoFile)));
                fout.write("The original path of this licenses was: ");
                fout.newLine();
                fout.write(licenseDirInfoTxt);
                fout.close();
            }
            catch (JvmExternalResourceInteractionException e) {
                LOGGER.error("Unable to copy license-directory content to temporary directory. " + licenseDir + " " + destinationLicenseDir, (Throwable)e);
                throw new Error(e);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create license-info file. " + licenseDirInfoFile, (Throwable)e);
                throw new Error(e);
            }
            ++i;
        }
    }
}

