/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.data;

import com.arcway.cockpit.errorreporting.data.CockpitLogFetcher;
import com.arcway.cockpit.errorreporting.data.IDataFetcher;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class AdditionalFileFetcher
implements IDataFetcher {
    private static final ILogger LOGGER = Logger.getLogger(CockpitLogFetcher.class);
    private final Collection<File> fileList = new ArrayList<File>();

    @Override
    public void fetchData(File sessionTempSubDir) {
        if (!this.fileList.isEmpty()) {
            File destinationParentDir = new File(sessionTempSubDir, "Attachments");
            destinationParentDir.mkdir();
            for (File userDefinedFile : this.fileList) {
                try {
                    File destinationSubDir;
                    String sourceFileParentDirName = new String(userDefinedFile.getParentFile().getName());
                    if (sourceFileParentDirName.length() < 1) {
                        sourceFileParentDirName = "Unknown_source-directory";
                    }
                    if (!(destinationSubDir = new File(destinationParentDir, sourceFileParentDirName)).exists()) {
                        destinationSubDir.mkdir();
                    }
                    File targetFile = new File(destinationSubDir, userDefinedFile.getName());
                    DataCopyHelper.copyFile((File)userDefinedFile, (File)targetFile);
                    LOGGER.debug("File: " + userDefinedFile);
                    LOGGER.debug("Target: " + targetFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    LOGGER.error("Unable to copy manually added file(s) to temporary directory.", (Throwable)e);
                    throw new Error(e);
                }
            }
        }
    }

    public void setFileList(Collection<File> additionalFiles) {
        this.fileList.clear();
        this.fileList.addAll(additionalFiles);
    }
}

