/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.menu.actions;

import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.EditWebLinkAdapter;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionNewWebLink
extends Action {
    private final Shell activeShell;
    private final IModelController modelCtrl;
    private final DocumentContainer parent;

    public ActionNewWebLink(Shell activeShell, IModelController modelCtrl, DocumentContainer parent) {
        this.activeShell = activeShell;
        this.modelCtrl = modelCtrl;
        this.parent = parent;
    }

    public void run() {
        assert (this.parent != null);
        assert (this.modelCtrl != null);
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        LockAccess lock = lockMgr.acquireInsertLock((ICockpitProjectData)this.parent);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return;
        }
        EditWebLinkAdapter dialogProvider = new EditWebLinkAdapter(this.parent);
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "dcm.weblink", this.modelCtrl, Messages.getString("EditWebLinkDialog.CreateWebLinkDetails"));
        RLWebLink newItem = new RLWebLink();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{this.parent});
        if (!creationPossible) {
            lock.releaseLocks();
            return;
        }
        WizardDialog dialog = new WizardDialog(this.activeShell, (IWizard)wizard);
        if (dialog.open() != 0) {
            lock.releaseLocks();
        }
    }
}

