/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dnd;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMModifyItems;
import com.arcway.cockpit.documentmodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.documentmodule.client.gui.actions.ActionDelegateNewContainerViaUniqueElement;
import com.arcway.cockpit.documentmodule.client.gui.dnd.FileAndURLDropHelper;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.frame.client.global.license.HierarchicalClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.editors.IDNDFileTransfer;
import com.arcway.cockpit.frame.client.project.editors.IDNDTextTransfer;
import com.arcway.cockpit.frame.client.project.editors.IDropListener;
import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.Collections;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PlanElementFileAndURLDropListener
implements IDropListener {
    private static final int DEFAULT_MODE = 4;

    public int isDropOnUniqueElementAllowed(IUniqueElement uniqueElement, int modesAllowed, int modeWished, Object payLoad) {
        if (!this.hasLicense(uniqueElement.getProjectUID())) {
            return 0;
        }
        int mode = payLoad != null ? 4 : 0;
        int toReturn = mode & modesAllowed;
        return toReturn;
    }

    public boolean dropOnUniqueElement(IUniqueElement uniqueElement, int modesAllowed, int mode, Object payLoad) {
        boolean dropAllowed;
        if (!this.hasLicense(uniqueElement.getProjectUID())) {
            return false;
        }
        if (payLoad != null) {
            if (payLoad instanceof IDNDFileTransfer || payLoad instanceof IDNDTextTransfer) {
                dropAllowed = true;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                IModelController modelCtrl = DocumentModulePlugin.getDefault().getProjectManager().getModelController(uniqueElement.getProjectUID());
                PermissionMgr permissionMgr = (PermissionMgr)modelCtrl.getPermissionMgr();
                if (permissionMgr.mayEditAnyCategories() || permissionMgr.mayCreateCategories()) {
                    shell.getDisplay().asyncExec((Runnable)new DropHandlerRunnable(modelCtrl, payLoad, uniqueElement));
                } else {
                    permissionMgr.showNoPermissionMsg(shell);
                }
            } else {
                dropAllowed = false;
            }
        } else {
            dropAllowed = false;
        }
        return dropAllowed;
    }

    private boolean hasLicense(String projectUID) {
        boolean hasLicense = true;
        HierarchicalClientFunctionLicenseType licenseType = ClientFunctionLicenseTypeDCMModifyItems.getInstance();
        if (licenseType != null) {
            ProjectMgr projectManager = DocumentModulePlugin.getDefault().getProjectManager();
            IFrameProjectAgent projectAgent = (IFrameProjectAgent)projectManager.getProjectAgent(projectUID);
            IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense((IClientFunctionLicenseType)licenseType);
            hasLicense = !licenseType.isDenial(license);
        }
        return hasLicense;
    }

    private class DropHandlerRunnable
    implements Runnable {
        private final IModelController modelController;
        private final Object payLoad;
        private final IUniqueElement uniqueElement;

        public DropHandlerRunnable(IModelController modelController, Object payLoad, IUniqueElement uniqueElement) {
            this.modelController = modelController;
            this.payLoad = payLoad;
            this.uniqueElement = uniqueElement;
        }

        @Override
        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            shell.forceActive();
            String nameSuggestion = FileAndURLDropHelper.getNameSuggestionForContainer(this.payLoad);
            final DocumentContainer container = ActionDelegateNewContainerViaUniqueElement.createContainer(this.modelController, Collections.singleton(this.uniqueElement), nameSuggestion, shell, activePart);
            if (container != null) {
                this.modelController.executeTransaction(new Runnable(){

                    @Override
                    public void run() {
                        if (DropHandlerRunnable.this.payLoad instanceof IDNDFileTransfer) {
                            String[] files = ((IDNDFileTransfer)DropHandlerRunnable.this.payLoad).getFiles();
                            int i = 0;
                            while (i < files.length) {
                                RLFileSystemLink fileLink = new RLFileSystemLink();
                                fileLink.setProjectUID(DropHandlerRunnable.this.modelController.getProjectUID());
                                fileLink.getURL().setValue(((IDNDFileTransfer)DropHandlerRunnable.this.payLoad).getFiles()[i]);
                                fileLink.calculateLocalURLs(0, (IProjectAgent)DropHandlerRunnable.this.modelController.getProjectAgent());
                                DropHandlerRunnable.this.modelController.addItem((IModuleData)fileLink);
                                DropHandlerRunnable.this.modelController.createLink(container.getUID(), (IModuleData)fileLink, "FilelinkDocumentContainer");
                                ++i;
                            }
                        } else if (DropHandlerRunnable.this.payLoad instanceof IDNDTextTransfer) {
                            RLWebLink webLink = new RLWebLink();
                            webLink.setProjectUID(DropHandlerRunnable.this.modelController.getProjectUID());
                            String url = ((IDNDTextTransfer)DropHandlerRunnable.this.payLoad).getText();
                            if (url.indexOf("\n") > 0) {
                                url = url.substring(0, url.indexOf("\n"));
                            }
                            webLink.getURL().setValue(url);
                            DropHandlerRunnable.this.modelController.addItem((IModuleData)webLink);
                            DropHandlerRunnable.this.modelController.createLink(container.getUID(), (IModuleData)webLink, "WeblinkDocumentContainer");
                        }
                    }
                });
            }
        }
    }
}

