/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMModifyItems;
import com.arcway.cockpit.documentmodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.documentmodule.client.gui.actions.DCMModuleActionDelegate;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.EditFileSystemLinkAdapter;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ActionDelegateNewFileSystemLink
extends DCMModuleActionDelegate {
    private IModelController modelCtrl;
    private DocumentContainer currentlySelectedContainer;
    private boolean enabled;

    public void run(IAction action) {
        assert (action != null);
        assert (this.currentlySelectedContainer != null);
        assert (this.modelCtrl != null);
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        LockAccess lock = lockMgr.acquireInsertLock((ICockpitProjectData)this.currentlySelectedContainer);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return;
        }
        EditFileSystemLinkAdapter dialogProvider = new EditFileSystemLinkAdapter(this.currentlySelectedContainer);
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "dcm.filesystemlink", this.modelCtrl, Messages.getString("EditFileSystemLinkDialog.CreateFileSystemLinkDetails"));
        RLFileSystemLink newItem = new RLFileSystemLink();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{this.currentlySelectedContainer});
        if (!creationPossible) {
            lock.releaseLocks();
            return;
        }
        WizardDialog dialog = new WizardDialog(this.getIssuingShell(), (IWizard)wizard);
        if (dialog.open() != 0) {
            lock.releaseLocks();
        }
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        boolean enable = false;
        if (selection != null) {
            IStructuredSelection selectionContent = (IStructuredSelection)selection;
            String projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)selectionContent);
            if (selectionContent.size() == 1 && selectionContent.getFirstElement() instanceof DocumentContainer && projectUid != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                this.modelCtrl = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUid);
                this.currentlySelectedContainer = (DocumentContainer)selectionContent.getFirstElement();
                PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
                enable = permissionMgr.mayEditContainer(this.currentlySelectedContainer);
            } else {
                this.currentlySelectedContainer = null;
                enable = false;
            }
        }
        this.enabled = enable;
        return this.enabled;
    }

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        return this.enabled;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeDCMModifyItems.getInstance();
    }
}

