/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMModifyItems;
import com.arcway.cockpit.documentmodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.documentmodule.client.gui.actions.DCMModuleActionDelegate;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.EditDocumentContainerAdapter;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ActionDelegateNewDocumentContainer
extends DCMModuleActionDelegate {
    private IModelController modelCtrl;
    private Category selectedCategory;
    private boolean enabled;

    protected boolean determineEnabledStatus(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            IStructuredSelection selectionContent = (IStructuredSelection)selection;
            String projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)selectionContent);
            if (selectionContent != null && selectionContent.size() == 1 && selectionContent.getFirstElement() instanceof Category && projectUid != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                this.modelCtrl = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUid);
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof Category) {
                    this.selectedCategory = (Category)((Object)firstElement);
                    assert (this.modelCtrl != null);
                    PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
                    this.enabled = permissionMgr.mayEditCategory(this.selectedCategory);
                    return this.enabled;
                }
            }
        }
        this.enabled = false;
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.modelCtrl != null);
        assert (this.selectedCategory != null);
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        LockAccess lock = lockMgr.acquireInsertLock((ICockpitProjectData)this.selectedCategory);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return;
        }
        EditDocumentContainerAdapter dialogProvider = new EditDocumentContainerAdapter(this.selectedCategory);
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "dcm.documentcontainer", this.modelCtrl, Messages.getString("EditDocumentContainerDialog.EnterDCAttributes"));
        DocumentContainer newItem = new DocumentContainer();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{this.selectedCategory});
        if (!creationPossible) {
            lock.releaseLocks();
            return;
        }
        if (new WizardDialog(this.getIssuingShell(), (IWizard)wizard).open() != 0) {
            lock.releaseLocks();
        }
    }

    protected boolean determineEnabledStatus(String projectUID) {
        PermissionMgr permissionMgr;
        this.modelCtrl = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        this.enabled = projectUID != null ? (permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr()).mayCreateCategories() || permissionMgr.mayEditAnyCategories() : false;
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        PermissionMgr permissionMgr;
        this.enabled = this.modelCtrl != null ? (permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr()).mayCreateCategories() || permissionMgr.mayEditAnyCategories() : false;
        return this.enabled;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeDCMModifyItems.getInstance();
    }
}

