/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.core.project;

import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider2;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.project.DataLabelProvider;
import com.arcway.cockpit.documentmodule.client.core.project.DocumentPermissionRootNode;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DCMDataTypesHelper;
import com.arcway.cockpit.documentmodule.client.messages.DCMLinkTypeHelper;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.IDocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.documentmodule.client.messages.RefreshDataViewRunnable;
import com.arcway.cockpit.documentmodule.client.messages.RefreshFileLinkThread;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.links.ILinkModificationListener;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleFacade;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DataMgr
extends AbstractDataMgr
implements ILinkModificationListener {
    private static final ILogger logger = Logger.getLogger(AbstractDataMgr.class);
    private IDataLabelProvider2<String> labelProvider;

    public void construct(String projectUid, IFrameProjectAgent project, IModelController modelControllerP, AbstractPermissionMgr permissionMgrP, AbstractLockManager lockMgrP, ProjectionMgr projectionMgrP, LinkMgr linkMgrP, PropertyChangesManager propertyChangesManager, ModuleFacade moduleFacade, IClientDataFactory clientDataFactory, AbstractEncodableObjectFactory p_eoFactory) {
        super.construct(projectUid, project, modelControllerP, permissionMgrP, lockMgrP, projectionMgrP, linkMgrP, propertyChangesManager, moduleFacade, clientDataFactory, p_eoFactory);
    }

    public Collection getChildren(IModuleData item) {
        if (item == null) {
            return super.getChildren(null);
        }
        ArrayList children = new ArrayList();
        if (item instanceof Category) {
            children.addAll(this.getLinkMgr().getModuleData(item, "ContainerCategory"));
        }
        if (item instanceof DocumentContainer) {
            children.addAll(this.getLinkMgr().getModuleData(item, "FilelinkDocumentContainer"));
            children.addAll(this.getLinkMgr().getModuleData(item, "WeblinkDocumentContainer"));
        }
        return children;
    }

    public IModuleData getParent(IModuleData item) {
        String linkTypeID;
        assert (item != null);
        if (item instanceof RLFileSystemLink) {
            linkTypeID = "FilelinkDocumentContainer";
        } else if (item instanceof RLWebLink) {
            linkTypeID = "WeblinkDocumentContainer";
        } else if (item instanceof DocumentContainer) {
            linkTypeID = "ContainerCategory";
        } else {
            return null;
        }
        Iterator i = this.getLinkMgr().getLinkableObjects(item, linkTypeID).iterator();
        if (i.hasNext()) {
            return (IModuleData)i.next();
        }
        logger.error("Item without parent");
        return null;
    }

    public Collection getAllRootItems() {
        return this.getAllItems("dcm.category");
    }

    public Collection getRootItems(String cockpitTypeID) {
        if (cockpitTypeID.equals("dcm.category")) {
            return this.getAllItems("dcm.category");
        }
        return Collections.EMPTY_SET;
    }

    public List filterSelection(List selection) {
        ArrayList filteredSelection = new ArrayList();
        for (Object nextItem : selection) {
            if (nextItem instanceof DocumentContainer || nextItem instanceof ResourceLocator) {
                filteredSelection.add(nextItem);
                continue;
            }
            if (!(nextItem instanceof IDocumentContainer)) continue;
            filteredSelection.add(((IDocumentContainer)nextItem).getDocumentContainer());
        }
        return filteredSelection;
    }

    public void callbackCommitCompleted() {
        super.callbackCommitCompleted();
        this.refreshLocalFileLinkAttributes();
    }

    private void refreshLocalFileLinkAttributes() {
        Collection fileLinks = this.getAllItems("dcm.filesystemlink");
        new RefreshFileLinkThread(fileLinks, null).start();
        for (RLFileSystemLink fileLink : fileLinks) {
            fileLink.calculateLocalURLs(0, (IProjectAgent)this.getProjectAgent());
        }
    }

    public void callbackAsynchronousUpdateStarted() {
        super.callbackAsynchronousUpdateStarted();
    }

    public void asynchronousUpdateHook_post_addedItems(String dataTypeId, Collection<IModuleData> addedItems) {
    }

    public void asynchronousUpdateHook_post_modifiedItems(String dataTypeId, Collection<IModuleData> modifiedItems) {
    }

    public void asynchronousUpdateHook_pre_removedItems(String dataTypeId, Collection<IModuleData> removedItems) {
    }

    public void callbackAsynchronousUpdateCompleted() {
        super.callbackAsynchronousUpdateCompleted();
        this.refreshLocalFileLinkAttributes();
    }

    public void linkAdded(EOLink link) {
        this.handleLinkModification(new HashSet<EOLink>(Collections.singleton(link)));
    }

    public void linkDeleted(EOLink link) {
        this.handleLinkModification(new HashSet<EOLink>(Collections.singleton(link)));
    }

    private void handleLinkModification(Collection links) {
        this.getPropertyChangesManager().signalPropertyChanges(this.extractContainers(links), null, null, EOLink.class);
    }

    private Collection extractContainers(Collection links) {
        HashSet<DocumentContainer> containers = new HashSet<DocumentContainer>();
        for (EOLink link : links) {
            if (!link.getLinkTypeID().equals("ContainerCategory")) continue;
            DocumentContainer container = (DocumentContainer)this.getItem("dcm.documentcontainer", link.getModuleDataUID());
            containers.add(container);
        }
        return containers;
    }

    public void projectInitialized_callbackForSubClasses() {
        Collection fileLinks = this.getAllItems("dcm.filesystemlink");
        for (RLFileSystemLink fileLink : fileLinks) {
            fileLink.calculateLocalURLs(0, (IProjectAgent)this.getProjectAgent());
        }
        new RefreshFileLinkThread(fileLinks, new RefreshDataViewRunnable(Display.getCurrent(), fileLinks, ProjectMgr.getProjectMgr().getProjectAgent(this.getProjectUID()).getPropertyChangesProviderManager())).start();
    }

    public void newProjectCreated() {
        super.newProjectCreated();
        this.getPermissionMgr().addStandardPermissions((IPermissionOperand)DocumentPermissionRootNode.ALL_CATEGORIES_INSTANCE);
    }

    public void linksAdded(Collection<EOLink> links) {
        this.handleLinkModification(links);
    }

    public void linksDeleted(Collection<EOLink> links) {
        this.handleLinkModification(links);
    }

    public boolean informDuringServerUpdate() {
        return true;
    }

    public IDataLabelProvider2<String> getDataLabelProvider2() {
        if (this.labelProvider == null) {
            this.labelProvider = new DataLabelProvider(this);
        }
        return this.labelProvider;
    }

    public String getDisplayNameForData() {
        return Messages.getString("DataMgr.documents");
    }

    public Image getImageForData() {
        return this.getDataLabelProvider2().getImageForType((Object)"dcm.documentcontainer");
    }

    public Category getCategory(DocumentContainer documentContainer) {
        return (Category)((Object)this.getLinkableObjects((IModuleData)documentContainer, "ContainerCategory").iterator().next());
    }

    public void dataDeleted(ICockpitProjectData deletedData) {
    }

    public IDataTypesHelper getDataTypesHelper() {
        return DCMDataTypesHelper.getDefault();
    }

    protected ILinkTypeHelper getLinkTypesHelper() {
        return DCMLinkTypeHelper.getDefault();
    }

    protected boolean isDataTypeWithID(String dataTypeID) {
        return false;
    }
}

