/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IConfiguredProject;
import com.arcway.cockpit.docgen.provider.interfaces.IConfiguredServerConnection;
import com.arcway.cockpit.docgen.provider.interfaces.IProjectOnServer;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.HTMLEncoder;
import java.io.File;
import org.eclipse.ui.IWorkbenchPage;

public final class ProjectOnServer
implements IProjectOnServer {
    private static final ILogger LOGGER = Logger.getLogger(ProjectOnServer.class);
    private final IConfiguredServerConnection serverConnection;
    private final EOProject project;
    private final IWorkbenchPage currentPage;

    public ProjectOnServer(IConfiguredServerConnection serverConnection, EOProject project, IWorkbenchPage currentPage) {
        this.serverConnection = serverConnection;
        this.project = project;
        this.currentPage = currentPage;
    }

    @Override
    public IConfiguredServerConnection getServerConnection() {
        return this.serverConnection;
    }

    @Override
    public String getProjectUID() {
        return this.project.getUID();
    }

    @Override
    public String getProjectName() {
        String projectName = Project.getProjectName((EOProject)this.project);
        return HTMLEncoder.encode((String)projectName);
    }

    @Override
    public IConfiguredProject fetchProjectFromServer() {
        IConfiguredProject configuredProject = this.serverConnection.getConfiguredProjects().get(this.project.getProjectUID());
        if (configuredProject == null) {
            String serverID = this.serverConnection.getServerID();
            ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
            IProjectManagerServerProxy projectManagerServerProxy = projectMgr.getProjectManagerServerProxy(serverID);
            boolean triggerUserOnOpenActions = false;
            try {
                projectManagerServerProxy.getProjectFromServer(this.project, this.currentPage, triggerUserOnOpenActions);
                configuredProject = this.serverConnection.getConfiguredProjects().get(this.project.getProjectUID());
            }
            catch (Exception e) {
                LOGGER.error("Cannot fetch project from server " + this.getProjectUID() + " / " + this.getProjectName(), (Throwable)e);
            }
        }
        return configuredProject;
    }

    @Override
    public String getProjectDumpAsFileName(String fileNamePrefix, int timeOutInSeconds) {
        String serverID = this.serverConnection.getServerID();
        ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
        IProjectManagerServerProxy projectManagerServerProxy = projectMgr.getProjectManagerServerProxy(serverID);
        try {
            File tempFile = SessionTempDirectoryManager.createSessionTempFile((String)fileNamePrefix, (String)"zip");
            projectManagerServerProxy.dumpProject(this.project, tempFile, null, timeOutInSeconds);
            tempFile.deleteOnExit();
            return AbstractAttributeOwnerDocGenProxy.getFileName(tempFile);
        }
        catch (Exception e) {
            LOGGER.error("Error while dumping project " + this.getProjectUID() + " / " + this.getProjectName(), (Throwable)e);
            return null;
        }
    }
}

