/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMember;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.word.docbook2word.AnchorWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.LinkWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Range;
import java.util.Iterator;
import java.util.List;

public class SimpleListWriter {
    private static SimpleListWriter writer;

    public static SimpleListWriter getInstance() {
        if (writer == null) {
            writer = new SimpleListWriter();
        }
        return writer;
    }

    private SimpleListWriter() {
    }

    public void write(EOSimpleList list, Paragraph paragraph, Document document, ProcessingContext processingContext) {
        Range range = paragraph.get_Range();
        range.set_End(range.get_End() - 1);
        this.write(list, range, document, processingContext);
        range.dispose();
    }

    public void write(EOSimpleList list, Range range, Document document, ProcessingContext processingContext) {
        String listType = list.getType();
        List itemList = list.getItems();
        if (listType.equals("inline")) {
            Iterator itemIter = itemList.iterator();
            while (itemIter.hasNext()) {
                EOMember member = (EOMember)itemIter.next();
                this.write(member, range, document, processingContext);
                if (!itemIter.hasNext()) continue;
                range.InsertAfter(", ");
            }
        } else if (!listType.equals("horiz")) {
            listType.equals("vert");
        }
    }

    private void write(EOMember member, Range range, Document document, ProcessingContext processingContext) {
        List contentList = member.getContent(processingContext.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                range.InsertAfter((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, range, processingContext);
                continue;
            }
            if (!(obj instanceof EOLink)) continue;
            LinkWriter.getInstance().write((EOLink)obj, range, document, processingContext);
        }
    }
}

