/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEmphasis;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.word.StyleMap;
import com.arcway.cockpit.docgen.writer.word.docbook2word.AnchorWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.IWordDocumentationWriterTask;
import com.arcway.cockpit.docgen.writer.word.docbook2word.LinkWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.List;

public class EmphasisWriter {
    private static ILogger logger = Logger.getLogger(EmphasisWriter.class);
    private static EmphasisWriter writer;

    public static EmphasisWriter getInstance() {
        if (writer == null) {
            writer = new EmphasisWriter();
        }
        return writer;
    }

    private EmphasisWriter() {
    }

    public Range write(final EOEmphasis emphasis, Range originalRange, Document document, final StyleMap styleMap, ProcessingContext processingContext) {
        boolean createdNewRangeForEmphasis;
        Range emphasisRange;
        if (originalRange.get_End() - originalRange.get_Start() > 0) {
            emphasisRange = originalRange.Next();
            emphasisRange.set_End(emphasisRange.get_End() - 1);
            createdNewRangeForEmphasis = true;
        } else {
            emphasisRange = originalRange;
            createdNewRangeForEmphasis = false;
        }
        List contentList = emphasis.getContent(processingContext.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                emphasisRange.InsertAfter((String)obj);
                if (!logger.isDebugEnabled(150)) continue;
                logger.debug(150, "[write paragraph] inserted text " + (String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, emphasisRange, processingContext);
                continue;
            }
            if (!(obj instanceof EOLink)) continue;
            LinkWriter.getInstance().write((EOLink)obj, emphasisRange, document, processingContext);
        }
        Range rangeAfterEmphasis = emphasisRange.Next();
        rangeAfterEmphasis.set_End(rangeAfterEmphasis.get_End() - 1);
        if (emphasisRange.get_End() - emphasisRange.get_Start() > 0) {
            final Range emphasisRangeDupe = emphasisRange.get_Duplicate();
            processingContext.addPostProcessingTask(new IWordDocumentationWriterTask(){

                @Override
                public void run() {
                    boolean explicitStyleSet = styleMap.applyEmphasisStyle(emphasisRangeDupe, emphasis.getRole());
                    if (!explicitStyleSet) {
                        emphasisRangeDupe.set_Bold(1);
                    }
                    emphasisRangeDupe.dispose();
                }
            });
        }
        if (createdNewRangeForEmphasis) {
            emphasisRange.dispose();
        }
        return rangeAfterEmphasis;
    }
}

