/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.AnchorWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.LinkWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.UlinkWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.ParagraphWrapper;
import java.util.List;

public class TitleWriter {
    private static TitleWriter writer;

    public static TitleWriter getInstance() {
        if (writer == null) {
            writer = new TitleWriter();
        }
        return writer;
    }

    private TitleWriter() {
    }

    public void write(EOTitle title, ParagraphWrapper paragraph, DocBook2WordMLGenerationContext context) {
        List contentList = title.getContent(context.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                paragraph.addText((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, paragraph, context);
                continue;
            }
            if (obj instanceof EOLink) {
                LinkWriter.getInstance().write((EOLink)obj, paragraph, context);
                continue;
            }
            if (!(obj instanceof EOUlink)) continue;
            UlinkWriter.getInstance().write((EOUlink)obj, paragraph, context);
        }
    }
}

