/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.DocBookPostProcessingProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOChapter;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSection;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.wordML.StyleMap;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.AnchorWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.SectionWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.TableWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.TitleWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.BodyNodeWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.ChapterWrapper;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import java.util.List;

public class ChapterWriter {
    private static ChapterWriter writer;

    public static ChapterWriter getInstance() {
        if (writer == null) {
            writer = new ChapterWriter();
        }
        return writer;
    }

    private ChapterWriter() {
    }

    public void write(EOChapter chapter, BodyNodeWrapper body, StyleMap styleMap, DocBook2WordMLGenerationContext context, DocBookPostProcessingProgress progress) throws ReportGenerationCanceledException, ReportGenerationException {
        EOSubtitle subtitle;
        ChapterWrapper chapterWrapper = body.addChapter();
        EOTitle title = chapter.getTitle();
        if (title != null) {
            String style = styleMap.findStyle("heading 1");
            TitleWriter.getInstance().write(title, chapterWrapper.addParagraph(style), context);
        }
        if ((subtitle = chapter.getSubtitle()) != null) {
            String style = styleMap.findStyle("heading 2");
            SubTitleWriter.getInstance().write(subtitle, chapterWrapper.addParagraph(style), context);
        }
        List contentList = chapter.getContent();
        for (Object obj : contentList) {
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, chapterWrapper, context);
            } else if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, chapterWrapper, context);
            } else if (obj instanceof EOSection) {
                SectionWriter.getInstance().write((EOSection)obj, chapterWrapper, 2, styleMap, context, progress);
            } else if (obj instanceof EOTable) {
                TableWriter.getInstance().write((EOTable)obj, chapterWrapper, context);
            } else if (obj instanceof EOSimpleList) {
                SimpleListWriter.getInstance().write((EOSimpleList)obj, chapterWrapper, context);
            }
            progress.checkCancelState();
        }
        int chapterCounter = context.getNextFreeChapterIndex();
        chapterWrapper.terminateChapter(chapterCounter, context);
        progress.incrementChapterProgress();
    }
}

