/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML;

import com.arcway.cockpit.docgen.writer.wordML.dom.WordMLReader;
import com.arcway.lib.java.dom.DOMHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleMap {
    private static final ILogger logger = Logger.getLogger(StyleMap.class);
    private Map<String, String> styleMap = null;

    public StyleMap(WordMLReader reader) {
        this.fillStyleCache(reader);
    }

    public String findStyle(String styleName) {
        if (styleName == null) {
            return null;
        }
        return this.styleMap.get(styleName);
    }

    private void fillStyleCache(WordMLReader reader) {
        this.styleMap = new HashMap<String, String>();
        Document doc = reader.getDocument();
        NodeList stylesNodeList = doc.getElementsByTagName("w:styles");
        if (stylesNodeList.getLength() > 0) {
            Node stylesNode = stylesNodeList.item(0);
            NodeList styleNodeList = stylesNode.getChildNodes();
            int i = 0;
            while (i < styleNodeList.getLength()) {
                Node styleNode = styleNodeList.item(i);
                if (styleNode.getNodeName().equals("w:style")) {
                    NamedNodeMap styleAttributes = styleNode.getAttributes();
                    Node id = styleAttributes.getNamedItem("w:styleId");
                    String styleID = id.getNodeValue();
                    Node nameNode = DOMHelper.getFirstChild((Node)styleNode, (String)"w:name");
                    NamedNodeMap nameAttributes = nameNode.getAttributes();
                    Node name = nameAttributes.getNamedItem("w:val");
                    String styleName = name.getNodeValue();
                    this.styleMap.put(styleName, styleID);
                    if (logger.isDebugEnabled(180)) {
                        logger.debug(180, "[write table] found style " + styleID);
                    }
                }
                ++i;
            }
        }
    }
}

