/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPreface;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TitleWriter;
import com.arcway.cockpit.docgen.writer.odt.dom.BodyNodeWrapper;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;

public class PrefaceWriter {
    private static PrefaceWriter writer;

    public static PrefaceWriter getInstance() {
        if (writer == null) {
            writer = new PrefaceWriter();
        }
        return writer;
    }

    private PrefaceWriter() {
    }

    public void write(EOPreface preface, BodyNodeWrapper body, DocBook2ODTGenerationContext context) throws ReportGenerationException, JvmExternalResourceInteractionException {
        EOSubtitle subtitle;
        EOTitle title = preface.getTitle();
        if (title != null) {
            String style = title.getRole();
            if (style == null) {
                style = "Title";
            }
            TitleWriter.getInstance().write(title, body.addParagraph(style), context);
        }
        if ((subtitle = preface.getSubtitle()) != null) {
            String style = subtitle.getRole();
            if (style == null) {
                style = "Subtitle";
            }
            SubTitleWriter.getInstance().write(subtitle, body.addParagraph(style), context);
        }
        for (Object obj : preface.getContent()) {
            if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, body, context);
                continue;
            }
            boolean cfr_ignored_0 = obj instanceof EOTable;
        }
    }
}

