/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.interfaces.frame.propertychanges;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PropertyChanges<T>
implements IPropertyChanges<T> {
    private Set<T> createdElements;
    private Set<T> modifiedElements;
    private Set<T> deletedElements;
    private boolean isAsynchronousUpdate;

    public PropertyChanges() {
        this(false);
    }

    public PropertyChanges(boolean isAsynchronousUpdate) {
        this.createdElements = new HashSet<T>();
        this.modifiedElements = new HashSet<T>();
        this.deletedElements = new HashSet<T>();
        this.isAsynchronousUpdate = isAsynchronousUpdate;
    }

    public PropertyChanges(Collection<? extends T> createdElements, Collection<? extends T> modifiedElements, Collection<? extends T> deletedElements) {
        this(createdElements, modifiedElements, deletedElements, false);
    }

    public PropertyChanges(Collection<? extends T> createdElements, Collection<? extends T> modifiedElements, Collection<? extends T> deletedElements, boolean isAsynchronousUpdate) {
        this.createdElements = createdElements == null ? new HashSet<T>() : new HashSet<T>(createdElements);
        this.modifiedElements = modifiedElements == null ? new HashSet<T>() : new HashSet<T>(modifiedElements);
        this.deletedElements = deletedElements == null ? new HashSet<T>() : new HashSet<T>(deletedElements);
        this.isAsynchronousUpdate = isAsynchronousUpdate;
    }

    public PropertyChanges(T createdElement, T modifiedElement, T deletedElement) {
        this(createdElement, modifiedElement, deletedElement, false);
    }

    public PropertyChanges(T createdElement, T modifiedElement, T deletedElement, boolean isAsynchronousUpdate) {
        assert (!(createdElement instanceof Collection));
        assert (!(modifiedElement instanceof Collection));
        assert (!(deletedElement instanceof Collection));
        if (createdElement != null) {
            this.createdElements = new HashSet<T>(1);
            this.createdElements.add(createdElement);
        } else {
            this.createdElements = new HashSet<T>();
        }
        if (modifiedElement != null) {
            this.modifiedElements = new HashSet<T>(1);
            this.modifiedElements.add(modifiedElement);
        } else {
            this.modifiedElements = new HashSet<T>();
        }
        if (deletedElement != null) {
            this.deletedElements = new HashSet<T>(1);
            this.deletedElements.add(deletedElement);
        } else {
            this.deletedElements = new HashSet<T>();
        }
        this.isAsynchronousUpdate = isAsynchronousUpdate;
    }

    @Override
    public Collection<T> getCreatedElements() {
        return this.createdElements;
    }

    @Override
    public Collection<T> getModifiedElements() {
        return this.modifiedElements;
    }

    @Override
    public Collection<T> getDeletedElements() {
        return this.deletedElements;
    }

    @Override
    public boolean isAsynchronousUpdate() {
        return this.isAsynchronousUpdate;
    }

    public void addPropertyChanges(IPropertyChanges<T> propertyChanges) {
        for (T element : propertyChanges.getCreatedElements()) {
            if (this.deletedElements.remove(element)) {
                this.modifiedElements.add(element);
                continue;
            }
            this.createdElements.add(element);
        }
        for (T element : propertyChanges.getModifiedElements()) {
            if (this.createdElements.remove(element)) {
                this.createdElements.add(element);
                continue;
            }
            this.modifiedElements.remove(element);
            this.modifiedElements.add(element);
        }
        for (T element : propertyChanges.getDeletedElements()) {
            if (this.createdElements.remove(element)) continue;
            this.modifiedElements.remove(element);
            this.deletedElements.add(element);
        }
    }
}

