/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ClassTypeExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ManualQueryKeyExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;

public abstract class ObjectExpression
extends DataExpression {
    protected transient ClassDescriptor descriptor;
    public List<Expression> derivedExpressions;
    protected boolean shouldUseOuterJoinForMultitableInheritance;
    protected boolean shouldUseOuterJoin = false;
    protected Class castClass;
    protected Expression joinSource;
    protected Expression onClause;

    @Override
    public Expression treat(Class castClass) {
        this.setCastClass(castClass);
        return this;
    }

    @Override
    public boolean equals(Object expression) {
        if (this == expression) {
            return true;
        }
        if (!super.equals(expression)) {
            return false;
        }
        if (this.onClause != null || ((ObjectExpression)expression).onClause != null) {
            return false;
        }
        return this.shouldUseOuterJoin == ((ObjectExpression)expression).shouldUseOuterJoin;
    }

    public synchronized void addDerivedExpression(Expression addThis) {
        if (this.derivedExpressions == null) {
            this.derivedExpressions = new ArrayList<Expression>();
        }
        this.derivedExpressions.add(addThis);
    }

    public Expression additionalExpressionCriteria() {
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression criteria = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
        if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() && this.isUsingOuterJoinForMultitableInheritance()) {
            Expression childrenCriteria = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
            childrenCriteria = this.getBaseExpression().twist(childrenCriteria, this);
            childrenCriteria.convertToUseOuterJoin();
            criteria = criteria == null ? childrenCriteria : criteria.and(childrenCriteria);
        }
        return criteria;
    }

    public Map additionalExpressionCriteriaMap() {
        if (this.getDescriptor() == null) {
            return null;
        }
        HashMap<DatabaseTable, Expression> tablesJoinExpressions = null;
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            tablesJoinExpressions = new HashMap<DatabaseTable, Expression>();
            List<DatabaseTable> childrenTables = this.getDescriptor().getInheritancePolicy().getChildrenTables();
            int i = 0;
            while (i < childrenTables.size()) {
                DatabaseTable table = childrenTables.get(i);
                Expression joinExpression = this.getDescriptor().getInheritancePolicy().getChildrenTablesJoinExpressions().get(table);
                joinExpression = this.getBaseExpression() != null ? this.getBaseExpression().twist(joinExpression, this) : this.twist(joinExpression, this);
                tablesJoinExpressions.put(table, joinExpression);
                ++i;
            }
        }
        return tablesJoinExpressions;
    }

    @Override
    public Expression anyOf(String attributeName, boolean shouldJoinBeIndependent) {
        QueryKeyExpression queryKey = shouldJoinBeIndependent ? this.newDerivedExpressionNamed(attributeName) : this.derivedExpressionNamed(attributeName);
        queryKey.doQueryToManyRelationship();
        return queryKey;
    }

    @Override
    public Expression anyOfAllowingNone(String attributeName, boolean shouldJoinBeIndependent) {
        QueryKeyExpression queryKey = shouldJoinBeIndependent ? this.newDerivedExpressionNamed(attributeName) : this.derivedExpressionNamed(attributeName);
        queryKey.doUseOuterJoin();
        queryKey.doQueryToManyRelationship();
        return queryKey;
    }

    public ClassDescriptor convertToCastDescriptor(ClassDescriptor rootDescriptor, AbstractSession session) {
        if (this.castClass == null) {
            return rootDescriptor;
        }
        if (rootDescriptor.getJavaClass() == this.castClass) {
            this.descriptor = rootDescriptor;
            return rootDescriptor;
        }
        ClassDescriptor castDescriptor = session.getClassDescriptor(this.castClass);
        if (castDescriptor == null) {
            throw QueryException.couldNotFindCastDescriptor(this.castClass, this.getBaseExpression());
        }
        if (castDescriptor.getInheritancePolicy() == null) {
            throw QueryException.castMustUseInheritance(this.getBaseExpression());
        }
        ClassDescriptor parentDescriptor = castDescriptor.getInheritancePolicy().getParentDescriptor();
        while (parentDescriptor != null) {
            if (parentDescriptor == rootDescriptor) {
                this.descriptor = castDescriptor;
                return castDescriptor;
            }
            parentDescriptor = parentDescriptor.getInheritancePolicy().getParentDescriptor();
        }
        ClassDescriptor childDescriptor = rootDescriptor;
        while (childDescriptor != null) {
            if (childDescriptor == castDescriptor) {
                this.descriptor = rootDescriptor;
                return this.descriptor;
            }
            childDescriptor = childDescriptor.getInheritancePolicy().getParentDescriptor();
        }
        throw QueryException.couldNotFindCastDescriptor(this.castClass, this.getBaseExpression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Expression> copyDerivedExpressions(Map alreadyDone) {
        ArrayList<Expression> derivedExpressionsCopy;
        if (this.derivedExpressions == null) {
            return null;
        }
        ObjectExpression objectExpression = this;
        synchronized (objectExpression) {
            derivedExpressionsCopy = new ArrayList<Expression>(this.derivedExpressions);
        }
        ArrayList<Expression> result = new ArrayList<Expression>(derivedExpressionsCopy.size());
        for (Expression exp : derivedExpressionsCopy) {
            result.add(exp.copiedVersionFrom(alreadyDone));
        }
        return result;
    }

    public QueryKeyExpression derivedExpressionNamed(String attributeName) {
        QueryKeyExpression existing = this.existingDerivedExpressionNamed(attributeName);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedExpressionNamed(attributeName);
    }

    public Expression derivedManualExpressionNamed(String attributeName, ClassDescriptor aDescriptor) {
        QueryKeyExpression existing = this.existingDerivedExpressionNamed(attributeName);
        if (existing != null) {
            return existing;
        }
        return this.newManualDerivedExpressionNamed(attributeName, aDescriptor);
    }

    public void doNotUseOuterJoin() {
        this.shouldUseOuterJoin = false;
    }

    public void doUseOuterJoin() {
        this.shouldUseOuterJoin = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryKeyExpression existingDerivedExpressionNamed(String attributeName) {
        ArrayList<Expression> derivedExpressionsCopy;
        if (this.derivedExpressions == null) {
            return null;
        }
        ObjectExpression objectExpression = this;
        synchronized (objectExpression) {
            derivedExpressionsCopy = new ArrayList<Expression>(this.derivedExpressions);
        }
        for (Expression derivedExpression : derivedExpressionsCopy) {
            QueryKeyExpression exp = (QueryKeyExpression)derivedExpression;
            if (!exp.getName().equals(attributeName)) continue;
            return exp;
        }
        return null;
    }

    @Override
    public Expression get(String attributeName) {
        QueryKeyExpression result = this.derivedExpressionNamed(attributeName);
        result.doNotUseOuterJoin();
        return result;
    }

    @Override
    public Expression leftJoin(Expression target, Expression onClause) {
        this.join(target, onClause);
        ((ObjectExpression)target).doUseOuterJoin();
        return this;
    }

    @Override
    public Expression join(Expression target, Expression onClause) {
        if (!(target instanceof ObjectExpression)) {
            throw new IllegalArgumentException();
        }
        ((ObjectExpression)target).setJoinSource(this);
        ((ObjectExpression)target).setOnClause(onClause);
        return this;
    }

    @Override
    public Expression getAllowingNull(String attributeName) {
        QueryKeyExpression exp = this.existingDerivedExpressionNamed(attributeName);
        if (exp != null) {
            return exp;
        }
        QueryKeyExpression result = this.derivedExpressionNamed(attributeName);
        result.doUseOuterJoin();
        return result;
    }

    public Class getCastClass() {
        return this.castClass;
    }

    @Override
    public Expression type() {
        return new ClassTypeExpression(this);
    }

    @Override
    public ClassDescriptor getDescriptor() {
        if (this.isAttribute()) {
            return null;
        }
        if (this.descriptor == null) {
            ForeignReferenceQueryKey queryKey = (ForeignReferenceQueryKey)this.getQueryKeyOrNull();
            if (queryKey != null) {
                this.descriptor = this.getSession().getDescriptor(queryKey.getReferenceClass());
                return this.convertToCastDescriptor(this.descriptor, this.getSession());
            }
            if (this.getMapping() == null) {
                throw QueryException.invalidQueryKeyInExpression(this);
            }
            this.descriptor = this.getMapping().getReferenceDescriptor();
            if (this.getMapping().isVariableOneToOneMapping()) {
                throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(this.getMapping(), this.descriptor);
            }
            this.convertToCastDescriptor(this.descriptor, this.getSession());
        }
        return this.descriptor;
    }

    @Override
    public Vector getFields() {
        if (this.getDescriptor() == null) {
            DatabaseMapping mapping = this.getMapping();
            if (mapping != null) {
                return mapping.getSelectFields();
            }
            return new NonSynchronizedVector(0);
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().shouldReadSubclasses() && !this.descriptor.getInheritancePolicy().hasMultipleTableChild() || this.shouldUseOuterJoinForMultitableInheritance()) {
            return this.descriptor.getAllFields();
        }
        return this.descriptor.getFields();
    }

    protected Vector getForUpdateOfFields() {
        Vector allFields = this.getFields();
        int expected = this.getTableAliases().size();
        Vector<DatabaseField> firstFields = new Vector<DatabaseField>(expected);
        DatabaseTable lastTable = null;
        DatabaseField field = null;
        int i = 0;
        while (i < allFields.size() && firstFields.size() < expected) {
            field = (DatabaseField)allFields.elementAt(i++);
            if (lastTable != null && field.getTable().equals(lastTable)) continue;
            lastTable = field.getTable();
            int j = 0;
            while (j < firstFields.size()) {
                if (lastTable.equals(((DatabaseField)firstFields.elementAt(j)).getTable())) break;
                ++j;
            }
            if (j != firstFields.size()) continue;
            firstFields.addElement(field);
        }
        return firstFields;
    }

    public Expression getManualQueryKey(String attributeName, ClassDescriptor aDescriptor) {
        return this.derivedManualExpressionNamed(attributeName, aDescriptor);
    }

    public List<DatabaseTable> getAdditionalTables() {
        return null;
    }

    @Override
    public Vector getOwnedTables() {
        ClassDescriptor descriptor = this.getDescriptor();
        Vector tables = null;
        if (descriptor == null) {
            List<DatabaseTable> additionalTables = this.getAdditionalTables();
            if (additionalTables == null) {
                return null;
            }
            return new Vector<DatabaseTable>(additionalTables);
        }
        if (descriptor.isAggregateDescriptor()) {
            return null;
        }
        tables = descriptor.getHistoryPolicy() != null && this.getAsOfClause().getValue() != null ? descriptor.getHistoryPolicy().getHistoricalTables() : (this.isUsingOuterJoinForMultitableInheritance() ? descriptor.getInheritancePolicy().getAllTables() : descriptor.getTables());
        List<DatabaseTable> additionalTables = this.getAdditionalTables();
        if (additionalTables != null) {
            tables = new Vector(tables);
            Helper.addAllUniqueToVector(tables, additionalTables);
            return tables;
        }
        return tables;
    }

    protected boolean hasDerivedExpressions() {
        return this.derivedExpressions != null;
    }

    @Override
    public boolean isObjectExpression() {
        return true;
    }

    public boolean isUsingOuterJoinForMultitableInheritance() {
        return this.shouldUseOuterJoinForMultitableInheritance() && this.getDescriptor() != null && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasMultipleTableChild() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses();
    }

    public QueryKeyExpression newDerivedExpressionNamed(String attributeName) {
        QueryKeyExpression result = new QueryKeyExpression(attributeName, this);
        this.addDerivedExpression(result);
        return result;
    }

    public Expression newManualDerivedExpressionNamed(String attributeName, ClassDescriptor aDescriptor) {
        ManualQueryKeyExpression result = new ManualQueryKeyExpression(attributeName, this, aDescriptor);
        this.addDerivedExpression(result);
        return result;
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.derivedExpressions = this.copyDerivedExpressions(alreadyDone);
        if (this.onClause != null) {
            this.onClause = this.onClause.copiedVersionFrom(alreadyDone);
        }
        if (this.joinSource != null) {
            this.joinSource = this.joinSource.copiedVersionFrom(alreadyDone);
        }
    }

    public DatabaseTable getRelationTable() {
        return null;
    }

    public boolean isDirectCollection() {
        return false;
    }

    public void postCopyIn(Map alreadyDone, List<Expression> oldDerivedFields, List<Expression> oldDerivedTables) {
        if (oldDerivedFields != null) {
            if (this.derivedFields == null) {
                this.derivedFields = this.copyCollection(oldDerivedFields, alreadyDone);
            } else {
                this.derivedFields.addAll(this.copyCollection(oldDerivedFields, alreadyDone));
            }
        }
        if (oldDerivedTables != null) {
            if (this.derivedTables == null) {
                this.derivedTables = this.copyCollection(oldDerivedTables, alreadyDone);
            } else {
                this.derivedTables.addAll(this.copyCollection(oldDerivedTables, alreadyDone));
            }
        }
    }

    public Expression getOnClause() {
        return this.onClause;
    }

    public void setOnClause(Expression onClause) {
        this.onClause = onClause;
    }

    public void setCastClass(Class castClass) {
        this.castClass = castClass;
    }

    public void setShouldUseOuterJoinForMultitableInheritance(boolean shouldUseOuterJoinForMultitableInheritance) {
        this.shouldUseOuterJoinForMultitableInheritance = shouldUseOuterJoinForMultitableInheritance;
    }

    public boolean shouldUseOuterJoin() {
        return this.shouldUseOuterJoin;
    }

    public boolean shouldUseOuterJoinForMultitableInheritance() {
        return this.shouldUseOuterJoinForMultitableInheritance;
    }

    protected void writeForUpdateOfFields(ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        for (DatabaseField field : this.getForUpdateOfFields()) {
            if (printer.getPlatform().shouldPrintAliasForUpdate()) {
                this.writeAlias(printer, field, statement);
                continue;
            }
            this.writeField(printer, field, statement);
        }
    }

    public Expression getJoinSource() {
        return this.joinSource;
    }

    public void setJoinSource(Expression joinSource) {
        this.joinSource = joinSource;
    }
}

