/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.workspace.table;

import com.arcway.lib.codec.data.IKey;
import com.arcway.repository.interFace.data.table.IRepositoryColumnSet;
import com.arcway.repository.interFace.data.table.IRepositoryStructuredColumnSet;
import com.arcway.repository.interFace.data.table.IRepositoryTable;
import com.arcway.repository.interFace.data.table.IRepositoryTableRow;
import com.arcway.repository.interFace.registration.data.table.IRepositoryColumnSetType;
import com.arcway.repository.interFace.registration.data.table.IRepositoryStructuredColumnSetType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RepositoryTableRow
implements IRepositoryTableRow {
    private final IRepositoryTable table;
    private final Map columnSets = new HashMap();

    public RepositoryTableRow(IRepositoryTable table, Collection containedColumnSets) {
        this.table = table;
        for (IRepositoryColumnSet columnSet : containedColumnSets) {
            IKey role = this.getRole(columnSet);
            this.columnSets.put(role, columnSet);
        }
    }

    private IKey getRole(IRepositoryColumnSet columnSet) {
        for (IKey key : this.table.getTableType().getContainedColumnSetTypeRoles()) {
            IRepositoryColumnSetType setType = this.table.getTableType().getContainedColumnSetType(key);
            if (!columnSet.getColumnSetType().equals(setType)) continue;
            return key;
        }
        return null;
    }

    public IRepositoryStructuredColumnSetType getStructuredColumnSetType() {
        return this.table.getTableType();
    }

    public IRepositoryTable getTable() {
        return this.table;
    }

    public IRepositoryColumnSetType getColumnSetType() {
        return this.table.getTableType();
    }

    public IRepositoryColumnSet getContainedColumnSet(IKey role) {
        return (IRepositoryColumnSet)this.columnSets.get(role);
    }

    public IRepositoryStructuredColumnSet getContainingColumnSet() {
        return null;
    }
}

