/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.implementation.access;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySetSample;
import java.lang.ref.WeakReference;

public class RepositoryObjectSample
implements IRepositoryObjectSample {
    private final IRepositoryObjectTypeID objectTypeID;
    private final IRepositoryObjectTypeCategoryID objectTypeCategoryID;
    private final IRepositoryPropertySetSample propertySetSample;
    private ObjectReferenceCacheEntry objectReferenceCache;

    public RepositoryObjectSample(IRepositoryObject object) throws EXNotReproducibleSnapshot {
        assert (object != null);
        IRepositoryObjectType objectType = object.getObjectType();
        this.objectTypeID = objectType.getRepositoryObjectTypeID();
        this.objectTypeCategoryID = object.getObjectTypeCategory() != null ? object.getObjectTypeCategory().getObjectTypeCategoryID() : null;
        HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        for (IRepositoryAttributeSetType attributeSetType : objectType.getAttributeSetTypes()) {
            IRepositoryAttributeSet attributeSet = object.getAttributeSet(attributeSetType);
            for (IRepositoryPropertyType propertyType : attributeSetType.getPropertyTypes()) {
                IRepositoryProperty property = attributeSet.getProperty(propertyType);
                IRepositoryPropertySample propertySample = property.sample();
                propertySamples.put((Object)propertyType.getRepositoryPropertyTypeID(), (Object)propertySample);
            }
        }
        this.propertySetSample = new RepositoryPropertySetSample((IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)propertySamples);
    }

    public RepositoryObjectSample(IRepositoryObjectType objectType, IRepositoryObjectTypeCategoryID objectTypeCategoryID, IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample> propertySamples) {
        Assert.checkArgumentBeeingNotNull((Object)objectType);
        Assert.checkArgumentBeeingNotNull(propertySamples);
        this.objectTypeID = objectType.getRepositoryObjectTypeID();
        this.objectTypeCategoryID = objectTypeCategoryID;
        this.propertySetSample = new RepositoryPropertySetSample(propertySamples);
    }

    public RepositoryObjectSample(IRepositoryObjectTypeID objectTypeID, IRepositoryObjectTypeCategoryID objectTypeCategoryID, IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample> propertySamples) {
        Assert.checkArgumentBeeingNotNull((Object)objectTypeID);
        Assert.checkArgumentBeeingNotNull(propertySamples);
        this.objectTypeID = objectTypeID;
        this.objectTypeCategoryID = objectTypeCategoryID;
        this.propertySetSample = new RepositoryPropertySetSample(propertySamples);
    }

    public RepositoryObjectSample(IRepositoryObjectTypeID objectTypeID, IRepositoryObjectTypeCategoryID objectTypeCategoryID, IRepositoryPropertySetSample propertySetSample) {
        Assert.checkArgumentBeeingNotNull((Object)objectTypeID);
        Assert.checkArgumentBeeingNotNull((Object)propertySetSample);
        this.objectTypeID = objectTypeID;
        this.objectTypeCategoryID = objectTypeCategoryID;
        this.propertySetSample = propertySetSample;
    }

    @Override
    public IRepositoryObjectTypeID getObjectTypeID() {
        return this.objectTypeID;
    }

    @Override
    public IRepositoryObjectTypeCategoryID getObjectTypeCategoryID() {
        return this.objectTypeCategoryID;
    }

    @Override
    public IRepositoryPropertySetSample getPropertySetSample() {
        return this.propertySetSample;
    }

    @Override
    public synchronized IRepositoryObjectReference getObjectReference(IRepositoryTypeManagerRO repositoryTypeManager) {
        IRepositoryObjectReference objectReference = null;
        if (this.objectReferenceCache != null && repositoryTypeManager == this.objectReferenceCache.typeManagerReference.get()) {
            objectReference = this.objectReferenceCache.objectReference;
        } else {
            IRepositoryObjectType repositoryObjectType = repositoryTypeManager.getObjectType(this.getObjectTypeID());
            IRepositoryPropertySetSample freshObjectID = RepositorySamples.getPropertySetSampleForAttributeSet(this, repositoryObjectType.getIDAttributeSetType());
            objectReference = this.objectReferenceCache != null && IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)this.objectReferenceCache.objectReference.getObjectID(), (Object)freshObjectID) ? this.objectReferenceCache.objectReference : new RepositoryObjectReference(this.objectTypeID, freshObjectID);
            this.objectReferenceCache = new ObjectReferenceCacheEntry(new WeakReference<IRepositoryTypeManagerRO>(repositoryTypeManager), objectReference);
        }
        return objectReference;
    }

    @Override
    public IRepositoryPropertySetSample getObjectID(IRepositoryTypeManagerRO repositoryTypeManager) {
        return this.getObjectReference(repositoryTypeManager).getObjectID();
    }

    public String toString() {
        StringBuffer str = new StringBuffer("RepositoryObjectSample: ");
        str.append(this.objectTypeID);
        str.append(this.propertySetSample.toString());
        return str.toString();
    }

    private static final class ObjectReferenceCacheEntry {
        public final WeakReference<IRepositoryTypeManagerRO> typeManagerReference;
        public final IRepositoryObjectReference objectReference;

        public ObjectReferenceCacheEntry(WeakReference<IRepositoryTypeManagerRO> typeManagerReference, IRepositoryObjectReference objectReference) {
            this.typeManagerReference = typeManagerReference;
            this.objectReference = objectReference;
        }
    }
}

