/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.implementation.access;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;

public class RepositoryObjectReference
implements IRepositoryObjectReference {
    private final IRepositoryObjectTypeID objectTypeID;
    private final IRepositoryPropertySetSample objectID;

    public RepositoryObjectReference(IRepositoryObjectTypeID repositoryObjectTypeID, IRepositoryPropertySetSample repositoryObjectID) {
        Assert.checkArgumentBeeingNotNull((Object)repositoryObjectTypeID);
        Assert.checkArgumentBeeingNotNull((Object)repositoryObjectID);
        this.objectID = repositoryObjectID;
        this.objectTypeID = repositoryObjectTypeID;
    }

    public RepositoryObjectReference(IRepositoryObject object) throws EXNotReproducibleSnapshot {
        this.objectTypeID = object.getObjectType().getRepositoryObjectTypeID();
        IRepositoryAttributeSetType idASType = object.getObjectType().getIDAttributeSetType();
        this.objectID = object.getAttributeSet(idASType).sample();
    }

    @Override
    public IRepositoryObjectTypeID getObjectTypeID() {
        return this.objectTypeID;
    }

    @Override
    public IRepositoryPropertySetSample getObjectID() {
        return this.objectID;
    }

    public static IHasher_<IRepositoryObjectReference> get_REFERENCING_EQUAL_OBJECTS_HASHER(final IRepositoryTypeManagerRO typeManager) {
        IHasher_<IRepositoryObjectReference> referencingEqualObjectsHasher = IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER;
        referencingEqualObjectsHasher = new IHasher_<IRepositoryObjectReference>(){

            public boolean isEqual(IRepositoryObjectReference iRepositoryObjectReference1, IRepositoryObjectReference iRepositoryObjectReference2) {
                IRepositoryPropertySetSample idASSample2;
                if (iRepositoryObjectReference1 == iRepositoryObjectReference2) {
                    return true;
                }
                IHasher_<IRepositoryPropertySetSample> attributeSetSampleHasher = IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER;
                IRepositoryPropertySetSample idASSample1 = iRepositoryObjectReference1.getObjectID();
                if (!attributeSetSampleHasher.isEqual((Object)idASSample1, (Object)(idASSample2 = iRepositoryObjectReference2.getObjectID()))) {
                    return false;
                }
                IRepositoryObjectType objectType1 = typeManager.getObjectType(iRepositoryObjectReference1.getObjectTypeID());
                IRepositoryObjectType objectType2 = typeManager.getObjectType(iRepositoryObjectReference2.getObjectTypeID());
                IHasher_<IRepositoryObjectTypeID> objectTypeIDHasher = IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER;
                return objectTypeIDHasher.isEqual((Object)objectType1.getIDDefiningSuperType().getRepositoryObjectTypeID(), (Object)objectType2.getIDDefiningSuperType().getRepositoryObjectTypeID());
            }

            public int getHashCode(IRepositoryObjectReference iRepositoryObjectReference) {
                return IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.getHashCode((Object)iRepositoryObjectReference.getObjectID());
            }
        };
        return referencingEqualObjectsHasher;
    }
}

