/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT.importjob.impl;

import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.IImportJobRelatedItem;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurrenceRelation;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IProperty;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class Property
implements IProperty,
IImportJobRelatedItem {
    private final ImportedObject object;
    private final IRepositoryPropertyType propertyType;
    private final IRepositoryData importedValue;
    private final Collection<OccurrenceRelation> occurrenceRelations = new HashSet<OccurrenceRelation>();
    private IRepositoryData toBeValue;

    public Property(ImportedObject object, IRepositoryPropertyType propertyType, IRepositoryData importedValue, boolean importedValueAsToBeValue) {
        this.object = object;
        this.propertyType = propertyType;
        this.importedValue = importedValue;
        this.toBeValue = importedValueAsToBeValue ? importedValue : null;
    }

    @Override
    public IRepositoryPropertyType getRepositoryPropertyType() {
        return this.propertyType;
    }

    @Override
    public ImportedObject getObject() {
        return this.object;
    }

    @Override
    public IRepositoryData getImportedValue() {
        return this.importedValue;
    }

    @Override
    public IRepositoryData getToBeValue() {
        return this.toBeValue;
    }

    @Override
    public void setToBeValue(IRepositoryData toBeValue) throws EXNotReproducibleSnapshot {
        this.toBeValue = toBeValue;
        this.fireChange();
    }

    @Override
    public IRepositoryPropertyReference getCurrentValue() {
        if (this.object.getMatchingObject() != null) {
            return new RepositoryPropertyReference(this.object.getMatchingObject(), this.propertyType.getRepositoryPropertyTypeID());
        }
        return null;
    }

    public void addOccurrenceRelation(OccurrenceRelation occurrenceRelation) {
        this.occurrenceRelations.add(occurrenceRelation);
    }

    public Collection<OccurrenceRelation> getOccurrenceRelations() {
        return Collections.unmodifiableCollection(this.occurrenceRelations);
    }

    @Override
    public void fireChange() throws EXNotReproducibleSnapshot {
        this.object.fireChange();
    }
}

