/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data.lock;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;

public abstract class AbstractRepositoryAttributeSetLockSample
extends AbstractRepositoryLockSample {
    public abstract IRepositoryObjectTypeID getObjectTypeID();

    public abstract IRepositoryPropertySetSample getObjectID();

    public abstract IRepositoryAttributeSetTypeID getAttributeSetTypeID();

    @Override
    public boolean isEqualTo(AbstractRepositoryLockSample sample) {
        if (this == sample) {
            return true;
        }
        if (sample == null) {
            return false;
        }
        if (!(sample instanceof AbstractRepositoryAttributeSetLockSample)) {
            return false;
        }
        AbstractRepositoryAttributeSetLockSample other = (AbstractRepositoryAttributeSetLockSample)sample;
        assert (this.getAttributeSetTypeID() != null && this.getObjectID() != null && this.getObjectTypeID() != null);
        assert (other.getAttributeSetTypeID() != null && other.getObjectID() != null && other.getObjectTypeID() != null);
        if (IRepositoryAttributeSetTypeID.IS_EQUAL_ATTRIBUTE_SET_TYPE_ID_HASHER.isEqual((Object)this.getAttributeSetTypeID(), (Object)other.getAttributeSetTypeID()) && RepositorySamples.isEqual(this.getObjectID(), other.getObjectID()) && IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)this.getObjectTypeID(), (Object)other.getObjectTypeID())) {
            if (this.getBasedSnapshotID() == null) {
                return other.getBasedSnapshotID() == null;
            }
            return RepositorySamples.isEqual(this.getBasedSnapshotID(), other.getBasedSnapshotID());
        }
        return false;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("RepositoryAttributeSetLockSample: ");
        str.append("{object type id=");
        str.append(this.getObjectTypeID());
        str.append(", object id=");
        str.append(this.getObjectID());
        str.append(", attribute set type id=");
        str.append(this.getAttributeSetTypeID());
        str.append(", based snapshot id=");
        str.append(this.getBasedSnapshotID());
        str.append('}');
        return str.toString();
    }

    @Override
    public boolean isCurrent(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        IRepositoryObjectType objectType = snapshot.getRepositoryInterface().getTypeManager().getObjectType(this.getObjectTypeID());
        IRepositoryObject object = snapshot.findRepositoryObject(objectType, this.getObjectID());
        IRepositoryAttributeSetType attributeSetType = objectType.getAttributeSetType(this.getAttributeSetTypeID());
        IRepositoryAttributeSet attributeSet = object.getAttributeSet(attributeSetType);
        return RepositorySamples.isEqual(this.getBasedSnapshotID(), attributeSet.getSnapshotIDOfLastModification());
    }
}

