/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions.actions;

import com.arcway.lib.java.collections.IIterator_;
import com.arcway.repository.implementation.transactions.AbstractElementaryAction;
import com.arcway.repository.implementation.transactions.actions.LockHelper;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.relationcontribution.IRepositoryIterator_ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXCannotDeleteObjectPartOfRelation;
import com.arcway.repository.interFace.transactions.exceptions.EXCannotDeleteObjectWithChildren;
import com.arcway.repository.interFace.transactions.exceptions.EXCannotDeleteRootObject;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;

public class READeleteObject
extends AbstractElementaryAction {
    private IRepositoryObjectReference objectToDeleteReference;
    private IRepositoryObjectReference parentObjectReference;
    private IRepositoryObjectSample deletedObject;

    public READeleteObject(IRepositoryObjectReference objectToDelete) {
        this.objectToDeleteReference = objectToDelete;
    }

    @Override
    public void execute(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        assert (this.objectToDeleteReference != null);
        IRepositoryObject objectToDelete = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)this.objectToDeleteReference, (IRepositorySnapshotRO)snapshot);
        IRepositoryAttributeSet parentAS = objectToDelete.getParentAttributeSet();
        if (parentAS == null) {
            throw new EXCannotDeleteRootObject();
        }
        this.parentObjectReference = new RepositoryObjectReference(parentAS.getObject());
        for (IRepositoryAttributeSetType attributeSetType : objectToDelete.getObjectType().getAttributeSetTypes()) {
            IRepositoryAttributeSet attributeSet = objectToDelete.getAttributeSet(attributeSetType);
            IIterator_ possibleChildIter = attributeSetType.getChildObjectTypes().iterator();
            while (possibleChildIter.hasNext()) {
                IRepositoryIterator_IRepositoryObject childIter = attributeSet.childObjectIterator((IRepositoryObjectType)possibleChildIter.next());
                if (!childIter.hasNext()) continue;
                childIter.abortIteration();
                throw new EXCannotDeleteObjectWithChildren(objectToDelete.sample());
            }
            for (ICrossLinkRepositoryRelationContributionType rcType : attributeSetType.getCrossLinkRelationContributionTypesToConcreteRelationTypes()) {
                IRepositoryIterator_ICrossLinkRepositoryRelationContribution iteratorRCs = attributeSet.relationContributionIterator(rcType);
                if (!iteratorRCs.hasNext()) continue;
                iteratorRCs.abortIteration();
                throw new EXCannotDeleteObjectPartOfRelation(objectToDelete.sample());
            }
        }
        this.setLocks(LockHelper.lockWholeObjectWithParent(objectToDelete));
        this.deletedObject = objectToDelete.sample();
        snapshot.deleteObject(objectToDelete);
    }

    @Override
    public void rollback(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        assert (this.parentObjectReference != null);
        assert (this.deletedObject != null);
        IRepositoryObjectType parentObjectType = snapshot.getTypeManager().getObjectType(this.parentObjectReference.getObjectTypeID());
        IRepositoryPropertySetSample parentObjectObjectID = this.parentObjectReference.getObjectID();
        IRepositoryObject parentObject = snapshot.findRepositoryObject(parentObjectType, parentObjectObjectID);
        assert (parentObject != null);
        snapshot.createObject(parentObject, this.deletedObject);
        this.deletedObject = null;
    }

    public String getName() {
        return "Delete Object Action";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        READeleteObject clone = (READeleteObject)((Object)super.clone());
        clone.objectToDeleteReference = this.objectToDeleteReference;
        return clone;
    }
}

