/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.attributeset;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.RegistrationTransaction;
import com.arcway.repository.implementation.registration.type.RepositoryDeclarationItem;
import com.arcway.repository.implementation.registration.type.item.RepositoryItemType;
import com.arcway.repository.implementation.registration.type.manager.RTAHookAttributeSetType;
import com.arcway.repository.implementation.registration.type.manager.RTAInheritanceHookAttributeSetType;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.implementation.registration.type.object.RepositoryObjectType;
import com.arcway.repository.implementation.registration.type.property.RepositoryPropertyType;
import com.arcway.repository.implementation.registration.type.relationcontribution.CrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.chassis.exceptions.EXRepositoryDeclarationInvalid;
import com.arcway.repository.interFace.chassis.exceptions.EXUnexpectedFinalizationType;
import com.arcway.repository.interFace.declaration.data.item.IItemTypeID;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.IRepositoryDeclarationItemID;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.attributeset.RepositoryAttributeSetTypeConflictType;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.attributeset.RepositoryAttributeSetTypeFinalizationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IAbstractRepositoryRelationContributionType;
import com.arcway.repository.lib.high.declaration.data.item.ItemTypeID;
import com.arcway.repository.lib.high.declaration.type.RepositoryDeclarationItemTypeID;
import com.arcway.repository.lib.high.declaration.type.object.BaseRepositoryObjectTypeAttributeSetTypes;

public class RepositoryAttributeSetType
extends RepositoryDeclarationItem
implements IRepositoryAttributeSetType {
    public static final ItemTypeID ITEM_TYPE_ID = new RepositoryDeclarationItemTypeID(new KeySegment("attributesettype"));
    private final IRepositoryAttributeSetTypeID repositoryAttributeSetTypeID;
    private final RepositoryAttributeSetTypeFinalizationType finalizationType;
    private final RepositoryAttributeSetTypeConflictType conflictType;
    RepositoryItemType definingItemType = null;
    RepositoryObjectType relatedObjectType = null;
    final IMapRW_<IRepositoryPropertyTypeID, RepositoryPropertyType> propertyTypes = new HashMap_(IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER);
    final ISetRW_<RepositoryObjectType> childObjectTypes = new HashSet_(IRepositoryDeclarationItem.EQUAL_ID_HASHER);
    final ISetRW_<CrossLinkRepositoryRelationContributionType> relationContributionTypesToConcreteRelations = new HashSet_(IAbstractRepositoryRelationContributionType.IS_EQUAL_IRELATION_CONTRIBUTION_HASHER);

    public static void load(RepositoryItemType definingItemType, RegistrationTransaction registrationTransaction, IRepositoryAttributeSetTypeDeclaration attributeSetTypeDeclaration, RepositoryAttributeSetTypeFinalizationType finalizationType) throws EXRepositoryDeclarationInvalid {
        RepositoryTypeManager typeManager = definingItemType.getRepositoryTypeManagerImplementation();
        IRepositoryAttributeSetTypeID attributeSetTypeID = attributeSetTypeDeclaration.getAttributeSetTypeID();
        IRepositoryObjectTypeID objectTypeID = attributeSetTypeDeclaration.getObjectTypeID();
        RepositoryAttributeSetTypeConflictType conflictType = attributeSetTypeDeclaration.getConflictType();
        RepositoryTypeManager.assertIdIsNotNull(registrationTransaction, IRepositoryAttributeSetTypeID.class, (IRepositoryDeclarationItemID)attributeSetTypeID);
        RepositoryTypeManager.assertIdIsNotNull(registrationTransaction, IRepositoryObjectTypeID.class, (IRepositoryDeclarationItemID)objectTypeID);
        RepositoryTypeManager.assertParameterIsNotNull(registrationTransaction, "conflict type", conflictType);
        RepositoryObjectType objectType = typeManager.getReferencedObjectType(registrationTransaction, objectTypeID);
        objectType.checkAttributeSetTypeIDIsUnused(registrationTransaction, attributeSetTypeID);
        if (!IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER.isEqual((Object)attributeSetTypeID, (Object)BaseRepositoryObjectTypeAttributeSetTypes.NonInherited.ID_ID) && finalizationType.isFinal()) {
            objectType.checkToBeReferencable(registrationTransaction);
        }
        RepositoryAttributeSetType newAttributeSetType = new RepositoryAttributeSetType(typeManager, attributeSetTypeID, finalizationType, conflictType);
        registrationTransaction.execute(new RTAHookAttributeSetType(definingItemType, objectType, newAttributeSetType));
    }

    public static RTAInheritanceHookAttributeSetType createAttributeSetTypeAndInheritanceHook(RepositoryItemType definingItemType, RepositoryAttributeSetType repositoryAttributeSetType, RepositoryObjectType objectType, RepositoryAttributeSetTypeFinalizationType newFinalizationType) throws EXRepositoryDeclarationInvalid {
        if (newFinalizationType.isNotFinal() && repositoryAttributeSetType.getFinalizationType().isFinal()) {
            throw new EXRepositoryDeclarationInvalid(repositoryAttributeSetType.getRepositoryDeclarationItemID(), (Throwable)new EXUnexpectedFinalizationType(newFinalizationType));
        }
        RepositoryAttributeSetType newAttributeSetType = new RepositoryAttributeSetType(repositoryAttributeSetType.getRepositoryTypeManagerImplementation(), repositoryAttributeSetType.getRepositoryAttributeSetTypeID(), newFinalizationType, repositoryAttributeSetType.getConflictType());
        RTAInheritanceHookAttributeSetType hookAttributeSetTypes = new RTAInheritanceHookAttributeSetType(repositoryAttributeSetType, definingItemType, objectType, newAttributeSetType);
        return hookAttributeSetTypes;
    }

    private RepositoryAttributeSetType(RepositoryTypeManager repositoryTypeManager, IRepositoryAttributeSetTypeID repositoryAttributeSetTypeID, RepositoryAttributeSetTypeFinalizationType finalizationType, RepositoryAttributeSetTypeConflictType conflictType) {
        super(repositoryTypeManager);
        Assert.checkArgumentBeeingNotNull((Object)repositoryAttributeSetTypeID);
        Assert.checkArgumentBeeingNotNull((Object)finalizationType);
        Assert.checkArgumentBeeingNotNull((Object)conflictType);
        this.repositoryAttributeSetTypeID = repositoryAttributeSetTypeID;
        this.finalizationType = finalizationType;
        this.conflictType = conflictType;
    }

    public final IItemTypeID getItemTypeID() {
        return ITEM_TYPE_ID;
    }

    public IRepositoryDeclarationItemID getRepositoryDeclarationItemID() {
        return this.getRepositoryAttributeSetTypeID();
    }

    public IRepositoryAttributeSetTypeID getRepositoryAttributeSetTypeID() {
        return this.repositoryAttributeSetTypeID;
    }

    public void checkToBeNotFinal(RegistrationTransaction registrationTransaction) throws EXRepositoryDeclarationInvalid {
        if (!this.isNotFinal()) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new EXUnexpectedFinalizationType(this.getFinalizationType()));
        }
    }

    public void checkPropertyTypeIDIsUnused(RegistrationTransaction registrationTransaction, IRepositoryPropertyTypeID id) throws EXRepositoryDeclarationInvalid {
        RepositoryTypeManager.assertDeclarationItemIsNotFound(registrationTransaction, (IRepositoryDeclarationItemID)id, this.findPropertyType(id));
    }

    public RepositoryPropertyType findReferencedPropertyType(RegistrationTransaction registrationTransaction, IRepositoryPropertyTypeID id) throws EXRepositoryDeclarationInvalid {
        RepositoryPropertyType type = this.findPropertyType(id);
        RepositoryTypeManager.assertDeclarationItemIsFound(registrationTransaction, (IRepositoryDeclarationItemID)id, type);
        return type;
    }

    public RepositoryPropertyType findPropertyType(IRepositoryPropertyTypeID propertyTypeID) {
        return (RepositoryPropertyType)this.propertyTypes.getByKey((Object)propertyTypeID);
    }

    public boolean isFinal() {
        return this.getFinalizationType().isFinal();
    }

    public boolean isNotFinal() {
        return this.getFinalizationType().isNotFinal();
    }

    public RepositoryItemType getDefiningItemType() {
        return this.definingItemType;
    }

    public RepositoryObjectType getObjectType() {
        return this.relatedObjectType;
    }

    public RepositoryAttributeSetTypeFinalizationType getFinalizationType() {
        return this.finalizationType;
    }

    public RepositoryAttributeSetTypeConflictType getConflictType() {
        return this.conflictType;
    }

    public ICollection_<? extends RepositoryPropertyType> getPropertyTypes() {
        return this.propertyTypes.values();
    }

    public RepositoryPropertyType getPropertyType(IRepositoryPropertyTypeID id) {
        RepositoryPropertyType propertyType = this.findPropertyType(id);
        Assert.checkArgumentBeeingNotNull((Object)propertyType);
        return propertyType;
    }

    public ICollection_<? extends RepositoryObjectType> getChildObjectTypes() {
        return this.childObjectTypes;
    }

    public ICollection_<? extends CrossLinkRepositoryRelationContributionType> getCrossLinkRelationContributionTypesToConcreteRelationTypes() {
        return this.relationContributionTypesToConcreteRelations;
    }
}

