/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearance;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import de.plans.lib.xml.encoding.EAEncodableAttributes;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class EALineMarkerAppearance
extends EAEncodableAttributes
implements ILineMarkerAppearance {
    private static final String ATTR_TAG_LINEMARKER_STYLENAME = "stylename";
    private static final String ATTR_TAG_LINEMARKER_SIZE = "size";
    private static final String ATTR_TAG_LINEMARKER_COLOR_RED = "color.red";
    private static final String ATTR_TAG_LINEMARKER_COLOR_GREEN = "color.green";
    private static final String ATTR_TAG_LINEMARKER_COLOR_BLUE = "color.blue";
    private static final String ATTR_TAG_LINEMARKER_COLOR_TRANSPARENT = "color.transparent";
    private static final String ATTR_TAG_LINEMARKER_FILLCOLOR_RED = "fillcolor.red";
    private static final String ATTR_TAG_LINEMARKER_FILLCOLOR_GREEN = "fillcolor.green";
    private static final String ATTR_TAG_LINEMARKER_FILLCOLOR_BLUE = "fillcolor.blue";
    private static final String ATTR_TAG_LINEMARKER_FILLCOLOR_ALPHA = "fillcolor.alpha";
    private LineMarker lineMarker = DEFAULT_LINEMARKER;
    private String lineMarkerStyleName = DEFAULT_LINEMARKER_STYLENAME;
    private double lineMarkerSize = 0.75;
    private int lineMarkerColorRed = 0;
    private int lineMarkerColorGreen = 0;
    private int lineMarkerColorBlue = 0;
    private boolean lineMarkerColorTransparent = false;
    private int lineMarkerFillColorRed = 255;
    private int lineMarkerFillColorGreen = 255;
    private int lineMarkerFillColorBlue = 255;
    private int lineMarkerFillColorAlpha = 255;

    public EALineMarkerAppearance(String xmlAttrTag) {
        super(xmlAttrTag);
    }

    public void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (this.lineMarker != null) {
            if (!this.lineMarker.equals(DEFAULT_LINEMARKER)) {
                this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_STYLENAME, this.lineMarker.getName());
            }
        } else {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_STYLENAME, this.lineMarkerStyleName);
        }
        if (Math.abs(this.lineMarkerSize - 0.75) > 1.0E-10) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_SIZE, this.lineMarkerSize);
        }
        if (this.lineMarkerColorTransparent) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_COLOR_TRANSPARENT, this.lineMarkerColorTransparent);
        }
        if (!(this.lineMarkerColorRed == 0 && this.lineMarkerColorGreen == 0 && this.lineMarkerColorBlue == 0 || this.lineMarkerColorTransparent)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_COLOR_RED, this.lineMarkerColorRed);
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_COLOR_GREEN, this.lineMarkerColorGreen);
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_COLOR_BLUE, this.lineMarkerColorBlue);
        }
        if (this.lineMarkerFillColorRed != 255 || this.lineMarkerFillColorGreen != 255 || this.lineMarkerFillColorBlue != 255 || this.lineMarkerFillColorAlpha != 255) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_FILLCOLOR_RED, this.lineMarkerFillColorRed);
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_FILLCOLOR_GREEN, this.lineMarkerFillColorGreen);
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_FILLCOLOR_BLUE, this.lineMarkerFillColorBlue);
            this.appendAttrToXML(writeContext, ATTR_TAG_LINEMARKER_FILLCOLOR_ALPHA, this.lineMarkerFillColorAlpha);
        }
    }

    protected boolean setSubAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_LINEMARKER_STYLENAME)) {
            LineMarker marker = LineMarker.lineMarkerDefaultGetByName((String)value);
            if (marker != null) {
                this.lineMarker = marker;
                this.lineMarkerStyleName = marker.getName();
            } else {
                this.lineMarker = DEFAULT_LINEMARKER;
                this.lineMarkerStyleName = value;
            }
        } else if (name.equals(ATTR_TAG_LINEMARKER_SIZE)) {
            this.lineMarkerSize = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_LINEMARKER_COLOR_RED)) {
            this.lineMarkerColorRed = this.toInt(value);
        } else if (name.equals(ATTR_TAG_LINEMARKER_COLOR_GREEN)) {
            this.lineMarkerColorGreen = this.toInt(value);
        } else if (name.equals(ATTR_TAG_LINEMARKER_COLOR_BLUE)) {
            this.lineMarkerColorBlue = this.toInt(value);
        } else if (name.equals(ATTR_TAG_LINEMARKER_COLOR_TRANSPARENT)) {
            this.lineMarkerColorTransparent = this.toBoolean(value);
        } else if (name.equals(ATTR_TAG_LINEMARKER_FILLCOLOR_RED)) {
            this.lineMarkerFillColorRed = this.toInt(value);
        } else if (name.equals(ATTR_TAG_LINEMARKER_FILLCOLOR_GREEN)) {
            this.lineMarkerFillColorGreen = this.toInt(value);
        } else if (name.equals(ATTR_TAG_LINEMARKER_FILLCOLOR_BLUE)) {
            this.lineMarkerFillColorBlue = this.toInt(value);
        } else if (name.equals(ATTR_TAG_LINEMARKER_FILLCOLOR_ALPHA)) {
            this.lineMarkerFillColorAlpha = this.toInt(value);
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    @Override
    public double getLineMarkerSize() {
        return this.lineMarkerSize;
    }

    @Override
    public Color getLineMarkerColor() {
        if (this.lineMarkerColorTransparent) {
            return new Color(Color.TRANSPARENT);
        }
        return new Color(this.lineMarkerColorRed, this.lineMarkerColorGreen, this.lineMarkerColorBlue);
    }

    @Override
    public FillColor getLineMarkerFillColor() {
        return new FillColor(this.lineMarkerFillColorRed, this.lineMarkerFillColorGreen, this.lineMarkerFillColorBlue, this.lineMarkerFillColorAlpha);
    }

    @Override
    public void setLineMarkerSize(double lineMarkerSize) {
        this.lineMarkerSize = lineMarkerSize;
    }

    @Override
    public void setLineMarkerColor(Color color) {
        assert (color != null) : "color is null";
        this.lineMarkerColorRed = color.r;
        this.lineMarkerColorGreen = color.g;
        this.lineMarkerColorBlue = color.b;
        this.lineMarkerColorTransparent = color.transparent;
    }

    @Override
    public void setLineMarkerFillColor(FillColor color) {
        assert (color != null) : "color is null";
        this.lineMarkerFillColorRed = color.foregroundColor.r;
        this.lineMarkerFillColorGreen = color.foregroundColor.g;
        this.lineMarkerFillColorBlue = color.foregroundColor.b;
        this.lineMarkerFillColorAlpha = color.foregroundAlpha;
    }

    @Override
    public void setLineMarkerStyle(LineMarker lineMarkerStyle) {
        assert (lineMarkerStyle != null) : "lineMarkerStyle is null";
        this.lineMarker = lineMarkerStyle;
    }

    @Override
    public LineMarker getLineMarkerStyle() {
        return this.lineMarker;
    }

    @Override
    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof ILineMarkerAppearanceRO)) {
            return;
        }
        ILineMarkerAppearanceRO marker = (ILineMarkerAppearanceRO)appearance;
        this.setLineMarkerColor(marker.getLineMarkerColor());
        this.setLineMarkerFillColor(marker.getLineMarkerFillColor());
        this.setLineMarkerSize(marker.getLineMarkerSize());
        this.setLineMarkerStyle(marker.getLineMarkerStyle());
    }

    @Override
    public IAppearanceRO getAppearanceAsCopy() {
        return new LineMarkerAppearance(this);
    }
}

