/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.FMCAPlanModelPlugin;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.IPlanElementFactory;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import de.plans.lib.eclipse.PlugInClassExtensionFactory;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import org.eclipse.core.runtime.CoreException;

public class PlanElementFactoryDispatcher {
    private static final String MODULE_EXTENSION_POINT_ID = "planelementtype";
    private static final String PROPERTY_NAME_FACTORY_CLASS = "factory-class";
    private static final String PROPERTY_NAME_ELEMENT_TYPE = "id";
    private static PlanElementFactoryDispatcher singletonInstance;
    private final PlugInClassExtensionFactory factoryFactory = new PlugInClassExtensionFactory(true, FMCAPlanModelPlugin.getPluginID(), "planelementtype", "id", "factory-class");

    private PlanElementFactoryDispatcher() throws PlugInClassExtensionFactoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlanElementFactoryDispatcher getInstance() throws PlugInClassExtensionFactoryException {
        Class<PlanElementFactoryDispatcher> clazz = PlanElementFactoryDispatcher.class;
        synchronized (PlanElementFactoryDispatcher.class) {
            if (singletonInstance == null) {
                singletonInstance = new PlanElementFactoryDispatcher();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    protected PMPlanElement create(PlanModelMgr planModelMgr, String type) throws EXPlanModelObjectFactoryException, CoreException, PlugInClassExtensionFactoryException {
        assert (planModelMgr != null) : "planModelMgr is null";
        assert (type != null) : "type is null";
        try {
            IPlanElementFactory factory = (IPlanElementFactory)this.factoryFactory.create(type);
            return factory.create(planModelMgr);
        }
        catch (ClassCastException e) {
            throw new EXPlanModelObjectFactoryException("Factory for plan element type " + type + " has unexpected type", e);
        }
    }

    protected PMPlanElement create(PlanModelMgr planModelMgr, EOPlanElement eo) throws PlugInClassExtensionFactoryException, CoreException, EXPlanModelObjectFactoryException {
        assert (planModelMgr != null) : "PlanModelMgr must not be null";
        assert (eo != null) : "EOGraphicalSupplement must not be null";
        String type = eo.getType();
        assert (type != null) : "Plan Element Type is null";
        try {
            IPlanElementFactory factory = (IPlanElementFactory)this.factoryFactory.create(type);
            return factory.create(planModelMgr, eo);
        }
        catch (ClassCastException e) {
            throw new EXPlanModelObjectFactoryException("Factory for type " + type + " has unexpected type", e);
        }
    }
}

