/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMGraphicalSupplement;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPlanObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.EOPointList;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PMPointList
extends PMPlanModelObject
implements IPMPointListRO,
IPMPointListRW {
    private boolean pointsCacheIsValid = false;
    private Points pointsCache = null;
    private Rectangle pointsBoundsCache = null;
    private Collection<PMPlanModelObject> pointsAndLinesCache = null;
    private PMPlanObject parent = null;
    private final ArrayList<PMPlanModelObject> points = new ArrayList();
    private final ArrayList<PMPlanModelObject> lines = new ArrayList();
    protected EOPointList persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOPointList.class, new PointListFactory());
    }

    protected PMPointList(PlanModelMgr planModelMgr, EOPointList eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOPointList getPersistentPointList() {
        return this.persistent;
    }

    @Override
    protected EOPlanModelObject getPersistentPlanModelObject() {
        return this.getPersistentPointList();
    }

    protected PMPointList(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOPointList();
    }

    @Override
    protected void linkToParent(PMPlanModelObject parentObj) {
        this.parent = (PMPlanObject)parentObj;
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
        if (child instanceof PMPoint) {
            this.points.add(child);
        } else if (child instanceof PMLine) {
            this.lines.add(child);
        }
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) {
        assert (this.getLineCount() == this.getPointCount() || this.getLineCount() == this.getPointCount() - 1) : "getPointCount() - 1 <= getLineCount <= getPointCount() is not fulfilled";
        boolean closedPointList = this.getLineCount() == this.getPointCount();
        int i = 0;
        while (i < this.getPointCount()) {
            PMPoint point = this.getPoint(i);
            PMLine line1st = i == 0 && closedPointList ? this.getLine(this.getLineCount() - 1) : (i > 0 ? this.getLine(i - 1) : null);
            PMLine line2nd = i < this.getPointCount() - 1 || closedPointList ? this.getLine(i) : null;
            point.linkCrossLinkToLines(line1st, line2nd);
            if (line1st != null) {
                line1st.linkCrossLinkToPoint2nd(point);
            }
            if (line2nd != null) {
                line2nd.linkCrossLinkToPoint1st(point);
            }
            ++i;
        }
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        ArrayList<PMPlanModelObject> children = new ArrayList<PMPlanModelObject>(0);
        int i = 0;
        while (i < this.getLineCount()) {
            children.add(this.getLine(i));
            ++i;
        }
        i = 0;
        while (i < this.getPointCount()) {
            children.add(this.getPoint(i));
            ++i;
        }
        return children;
    }

    public PMPlanObject getPlanObject() {
        return this.parent;
    }

    @Override
    public IPMPlanObjectRO getPlanObjectRO() {
        return this.getPlanObject();
    }

    @Override
    public IPMPlanObjectRW getPlanObjectRW() {
        return this.getPlanObject();
    }

    public void setPlanObject(PMPlanObject parent) {
        this.setPlanObject((Object)parent);
    }

    @Override
    public void setPlanObject(IPMPlanObjectRW parent) {
        this.setPlanObject((Object)parent);
    }

    public void setPlanObject(Object parent) {
        assert (parent == null || parent instanceof PMFigure || parent instanceof PMGraphicalSupplement) : "invalid parent type";
        this.parent = (PMPlanObject)parent;
    }

    @Override
    public int getPointCount() {
        return this.points.size();
    }

    public int getPointIndex(PMPoint point) {
        return this.getPointIndex((Object)point);
    }

    @Override
    public int getFirstPointIndex(IPMPointRO point) {
        return this.getPointIndex(point);
    }

    @Override
    public int getLastPointIndex(IPMPointRO point) {
        assert (point != null) : "point is null";
        assert (point instanceof PMPoint) : "point is not instance of PMPoint";
        return this.points.lastIndexOf(point);
    }

    @Override
    public int getPointIndex(IPMPointRW point) {
        return this.getPointIndex((Object)point);
    }

    private int getPointIndex(Object point) {
        assert (point != null) : "point is null";
        assert (point instanceof PMPoint) : "point is not instance of PMPoint";
        return this.points.indexOf(point);
    }

    public PMPoint getPoint(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.getPointCount()) : "index >= getPointCount()";
        return (PMPoint)this.points.get(index);
    }

    @Override
    public IPMPointRO getPointRO(int index) {
        return this.getPoint(index);
    }

    @Override
    public IPMPointRW getPointRW(int index) {
        return this.getPoint(index);
    }

    public void addPoint(PMPoint point, int i) {
        this.addPoint((Object)point, i);
    }

    @Override
    public void addPoint(IPMPointRW point, int i) {
        this.addPoint((Object)point, i);
    }

    private void addPoint(Object point, int i) {
        assert (point != null) : "point is null";
        assert (point instanceof PMPoint) : "point is not instance of PMPoint";
        assert (i >= 0) : "i<0";
        assert (i <= this.getPointCount()) : "i > getPointCount()";
        PMPoint pMPoint = (PMPoint)point;
        this.points.add(i, pMPoint);
        this.getPersistentPointList().addPoint(pMPoint.getPersistentPoint(), i);
        this.flushPointsAndLinesCache();
        this.flushPlanObjectsGeometryCaches();
    }

    @Override
    public void removePoint(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getPointCount()) : "i >= getPointCount()";
        this.points.remove(i);
        this.getPersistentPointList().removePoint(i);
        this.flushPointsAndLinesCache();
        this.flushPlanObjectsGeometryCaches();
    }

    @Override
    public int getLineCount() {
        return this.lines.size();
    }

    public int getLineIndex(PMLine line) {
        return this.getLineIndex((Object)line);
    }

    @Override
    public int getLineIndex(IPMLineRO line) {
        return this.getLineIndex((Object)line);
    }

    @Override
    public int getLineIndex(IPMLineRW line) {
        return this.getLineIndex((Object)line);
    }

    private int getLineIndex(Object line) {
        assert (line instanceof PMLine) : "line is not instance of PMLine";
        return this.lines.indexOf(line);
    }

    public PMLine getLine(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.getLineCount()) : "index >= getLineCount()";
        return (PMLine)this.lines.get(index);
    }

    @Override
    public IPMLineRO getLineRO(int index) {
        return this.getLine(index);
    }

    @Override
    public IPMLineRW getLineRW(int index) {
        return this.getLine(index);
    }

    public void addLine(PMLine line, int i) {
        this.addLine((Object)line, i);
    }

    @Override
    public void addLine(IPMLineRW line, int i) {
        this.addLine((Object)line, i);
    }

    private void addLine(Object line, int i) {
        assert (line != null) : "line is null";
        assert (line instanceof PMLine) : "line is not instance of PMLine";
        assert (i >= 0) : "i<0";
        assert (i <= this.getLineCount()) : "i > getLineCount()";
        PMLine pMLine = (PMLine)line;
        this.lines.add(i, pMLine);
        this.getPersistentPointList().addLine(pMLine.getPersistentLine(), i);
        this.flushPointsAndLinesCache();
        this.flushPlanObjectsGeometryCaches();
    }

    @Override
    public void removeLine(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getLineCount()) : "i >= getLineCount()";
        this.lines.remove(i);
        this.getPersistentPointList().removeLine(i);
        this.flushPointsAndLinesCache();
        this.flushPlanObjectsGeometryCaches();
    }

    protected PMPlanElement getPlanElement() {
        return this.getRelatedFigure().getPlanElement();
    }

    protected PMFigure getRelatedFigure() {
        PMFigure pmFigure = null;
        PMPlanObject parentObj = this.getPlanObject();
        if (parentObj instanceof PMFigure) {
            pmFigure = (PMFigure)parentObj;
        } else if (parentObj instanceof PMGraphicalSupplement) {
            pmFigure = ((PMGraphicalSupplement)parentObj).getFigure();
        } else assert (false) : "invalid type of PMPointList parent";
        return pmFigure;
    }

    @Override
    public IPMPlanElementRO getPlanElementRO() {
        return this.getPlanElement();
    }

    @Override
    public IPMPlanElementRW getPlanElementRW() {
        return this.getPlanElement();
    }

    protected void removeLinks() {
        while (this.getPointCount() > 0) {
            this.removePoint(0);
        }
        while (this.getLineCount() > 0) {
            this.removeLine(0);
        }
        this.setPlanObject(null);
    }

    protected PMPointList(PlanModelMgr planModelMgr, PMPlanObject parent) {
        super(planModelMgr);
        assert (parent instanceof PMFigure || parent instanceof PMGraphicalSupplement) : "invalid parent type";
        this.persistent = new EOPointList();
        this.setPlanObject(parent);
    }

    private void init() {
        while (this.getPointCount() > 0) {
            PMPoint point = this.getPoint(0);
            point.deleteAllChildren();
            point.removeLinks();
            this.removePoint(0);
        }
        while (this.getLineCount() > 0) {
            PMLine line = this.getLine(0);
            line.deleteAllChildren();
            line.removeLinks();
            this.removeLine(0);
        }
    }

    protected void add(PMPoint prevPoint, PMLine newLine, PMPoint newPoint) {
        assert (this.points.indexOf(prevPoint) >= 0) : "prevPoint is not related to this point list";
        assert (newLine != null) : "newLine is null";
        assert (newPoint != null) : "newPoint is null";
        int prevPointIndex = this.getPointIndex(prevPoint);
        this.addPoint(newPoint, prevPointIndex + 1);
        this.addLine(newLine, prevPointIndex);
    }

    public void populate(Points newPoints, boolean closedDraw) {
        this.init();
        if (newPoints != null) {
            int lastPointIndex = newPoints.size() - 1;
            PMPoint firstPoint = null;
            PMPoint prevPoint = null;
            int i = 0;
            while (i <= lastPointIndex) {
                PMPoint newPoint = new PMPoint(this.getPlanModelMgr(), this);
                newPoint.setPosition(newPoints.get(i));
                PMLine newLine = null;
                if (i == 0) {
                    firstPoint = newPoint;
                } else {
                    newLine = new PMLine(this.getPlanModelMgr(), this);
                    newLine.setPoint1st(prevPoint);
                    newLine.setPoint2nd(newPoint);
                    assert (prevPoint != null) : "previous point is null!";
                    prevPoint.setLine2nd(newLine);
                    newPoint.setLine1st(newLine);
                }
                if (i == 0) {
                    this.addPoint(newPoint, this.getPointCount());
                } else {
                    this.add(prevPoint, newLine, newPoint);
                }
                prevPoint = newPoint;
                ++i;
            }
            if (closedDraw && lastPointIndex > 0) {
                PMLine newLine = new PMLine(this.getPlanModelMgr(), this);
                newLine.setPoint1st(prevPoint);
                newLine.setPoint2nd(firstPoint);
                assert (prevPoint != null) : "previous point is null";
                assert (firstPoint != null) : "first point is null";
                prevPoint.setLine2nd(newLine);
                firstPoint.setLine1st(newLine);
                this.addLine(newLine, this.getLineCount());
            }
        }
    }

    public PMPoint insertPoint(PMLine line, double position) {
        assert (line != null) : "line is null";
        assert (position > -1.0E-10) : "position < 0";
        assert (position < 1.0000000001) : "position > 1";
        int lineForce = line.getForce();
        boolean createTwoPoints = lineForce != 1;
        PMPoint newPoint1 = new PMPoint(this.getPlanModelMgr(), null);
        PMPoint newPoint2 = null;
        if (createTwoPoints) {
            newPoint2 = new PMPoint(this.getPlanModelMgr(), null);
        }
        PMLine newLine1 = line.devide(position, newPoint1);
        if (createTwoPoints) {
            newLine1.devide(0.0, newPoint2);
        }
        if (createTwoPoints) {
            switch (lineForce) {
                case 2: {
                    newLine1.setForce(3);
                    break;
                }
                case 3: {
                    newLine1.setForce(2);
                    break;
                }
                default: {
                    assert (false) : "unknown line force type";
                    break;
                }
            }
        }
        return newPoint1;
    }

    protected void move(GeoVector v) {
        assert (v != null) : "v = null";
        int i = 0;
        while (i < this.getPointCount()) {
            this.getPoint(i).move(v);
            ++i;
        }
    }

    @Override
    public IPMSemanticalUnit getSemanticalUnit() {
        return this.getPlanElement();
    }

    protected Collection getSourceContributorsToAnchor() {
        return this.getPointsAndLines();
    }

    protected Collection getDestinationContributorsToAnchor() {
        return this.getPointsAndLines();
    }

    private Collection getPointsAndLines() {
        if (this.pointsAndLinesCache == null) {
            this.pointsAndLinesCache = new ArrayList<PMPlanModelObject>(this.lines.size() + this.points.size());
            this.pointsAndLinesCache.addAll(this.lines);
            this.pointsAndLinesCache.addAll(this.points);
        }
        return this.pointsAndLinesCache;
    }

    private void flushPointsAndLinesCache() {
        this.pointsAndLinesCache = null;
    }

    @Override
    public Points getPoints() {
        this.updatePointsCache();
        return this.pointsCache;
    }

    protected Rectangle getPointsBounds() {
        this.updatePointsCache();
        return this.pointsBoundsCache;
    }

    private void updatePointsCache() {
        if (!this.pointsCacheIsValid) {
            int size = this.getPointCount();
            this.pointsCache = new Points(size);
            int i = 0;
            while (i < size) {
                Point p = this.getPoint(i).getPosition();
                this.pointsCache.add(p);
                ++i;
            }
            this.pointsBoundsCache = this.pointsCache.getBounds();
            this.pointsCacheIsValid = true;
        }
    }

    protected void flushPlanObjectsGeometryCaches() {
        PMPlanObject planObject = this.getPlanObject();
        if (planObject != null) {
            planObject.flushGeometryCaches();
        }
    }

    protected void flushGeometryCaches() {
        this.flushPointsCache();
        int i = 0;
        while (i < this.getLineCount()) {
            PMLine line = this.getLine(i);
            line.flushGeometryCaches();
            ++i;
        }
        i = 0;
        while (i < this.getPointCount()) {
            PMPoint point = this.getPoint(i);
            point.flushGeometryCaches();
            ++i;
        }
    }

    protected void flushPointsCache() {
        this.pointsCacheIsValid = false;
    }

    @Override
    public String toString() {
        return "PMPointList " + this.points.toString();
    }

    static class PointListFactory
    extends PMPlanModelObject.PlanModelObjectFactory {
        PointListFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMPointList(planModelMgr, (EOPointList)eo);
        }

        @Override
        public List<? extends EOEncodableObject> getChildren(EncodableObjectBase eo) {
            EOPointList eoPointList = (EOPointList)eo;
            List<? extends EOEncodableObject> children = super.getChildren(eo);
            int pointIndex = 0;
            while (pointIndex < eoPointList.getPointCount()) {
                children.add((EOEncodableObject)eoPointList.getPoint(pointIndex));
                ++pointIndex;
            }
            int lineIndex = 0;
            while (lineIndex < eoPointList.getLineCount()) {
                children.add((EOEncodableObject)eoPointList.getLine(lineIndex));
                ++lineIndex;
            }
            return children;
        }
    }
}

