/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.access.readonly.IPMContainmentRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMContainmentRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectCrosslinkException;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectLinker;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOContainment;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.List;

public class PMContainment
extends PMPlanModelObject
implements IPMContainmentRO,
IPMContainmentRW {
    private PMPlanElement containingPlanElement = null;
    private PMPlanElement containedPlanElement = null;
    private final EOContainment persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOContainment.class, new ContainmentFactory());
    }

    protected PMContainment(PlanModelMgr planModelMgr, EOContainment eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOContainment getPersistentContainment() {
        return this.persistent;
    }

    @Override
    protected EOPlanModelObject getPersistentPlanModelObject() {
        return this.getPersistentContainment();
    }

    protected PMContainment(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOContainment();
    }

    @Override
    protected void linkToParent(PMPlanModelObject parent) {
        this.containingPlanElement = (PMPlanElement)parent;
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) throws EXPlanModelObjectCrosslinkException {
        PMPlanElement planElement = (PMPlanElement)LoadPlanModelObjectLinker.getObjectByUIDAndCheckType(objectList, this.getPersistentContainment().getPlanElementUid(), PMPlanElement.class, "planelement");
        planElement.linkCrossLinkToContainment(this);
        this.containedPlanElement = planElement;
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        ArrayList<PMPlanModelObject> children = new ArrayList<PMPlanModelObject>(0);
        return children;
    }

    @Override
    protected List<? extends Object> getCrosslinked() {
        ArrayList<PMPlanElement> crosslinked = new ArrayList<PMPlanElement>(1);
        crosslinked.add(this.containedPlanElement);
        return crosslinked;
    }

    public PMPlanElement getContainingPlanElement() {
        return this.containingPlanElement;
    }

    @Override
    public IPMPlanElementRO getContainingPlanElementRO() {
        return this.getContainingPlanElement();
    }

    @Override
    public IPMPlanElementRW getContainingPlanElementRW() {
        return this.getContainingPlanElement();
    }

    public void setContainingPlanElement(PMPlanElement planElement) {
        this.setContainingPlanElement((Object)planElement);
    }

    @Override
    public void setContainingPlanElement(IPMPlanElementRW planElement) {
        this.setContainingPlanElement((Object)planElement);
    }

    private void setContainingPlanElement(Object planElement) {
        assert (planElement == null || planElement instanceof PMPlanElement) : "planElement is not instance of PMPlanElement";
        this.containingPlanElement = (PMPlanElement)planElement;
    }

    public PMPlanElement getContainedPlanElement() {
        return this.containedPlanElement;
    }

    @Override
    public IPMPlanElementRO getContainedPlanElementRO() {
        return this.getContainedPlanElement();
    }

    @Override
    public IPMPlanElementRW getContainedPlanElementRW() {
        return this.getContainedPlanElement();
    }

    public void setContainedPlanElement(PMPlanElement planElement) {
        this.setContainedPlanElement((Object)planElement);
    }

    @Override
    public void setContainedPlanElement(IPMPlanElementRW planElement) {
        this.setContainedPlanElement((Object)planElement);
    }

    private void setContainedPlanElement(Object planElement) {
        PMPlanElement pMPlanElement;
        assert (planElement == null || planElement instanceof PMPlanElement) : "planElement is not instance of PMPlanElement";
        this.containedPlanElement = pMPlanElement = (PMPlanElement)planElement;
        if (pMPlanElement == null) {
            this.getPersistentContainment().setPlanElementUid(null);
        } else {
            this.getPersistentContainment().setPlanElementUid(pMPlanElement.getPersistentPlanElement().getUid());
        }
    }

    @Override
    public IPMSemanticalUnit getSemanticalUnit() {
        return this.getContainingPlanElement().getPlan();
    }

    static class ContainmentFactory
    extends PMPlanModelObject.PlanModelObjectFactory {
        ContainmentFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMContainment(planModelMgr, (EOContainment)eo);
        }

        @Override
        public List<? extends EOEncodableObject> getChildren(EncodableObjectBase eo) {
            return super.getChildren(eo);
        }
    }
}

