/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringLineToLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringLineToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectCrosslinkException;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectLinker;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMAnchoringLine;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOAnchoringLine;
import com.arcway.planagent.planmodel.persistent.EOAnchoringLineToLine;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.List;

public class PMAnchoringLineToLine
extends PMAnchoringLine
implements IPMAnchoringLineToLineRO,
IPMAnchoringLineToLineRW {
    private PMLine targetLine = null;
    private final EOAnchoringLineToLine persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOAnchoringLineToLine.class, new AnchoringLineToLineFactory());
    }

    protected PMAnchoringLineToLine(PlanModelMgr planModelMgr, EOAnchoringLineToLine eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOAnchoringLineToLine getPersistentAnchoringLineToLine() {
        return this.persistent;
    }

    @Override
    protected EOAnchoringLine getPersistentAnchoringLine() {
        return this.getPersistentAnchoringLineToLine();
    }

    protected PMAnchoringLineToLine(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOAnchoringLineToLine();
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) throws EXPlanModelObjectCrosslinkException {
        PMLine line = (PMLine)LoadPlanModelObjectLinker.getObjectByUIDAndCheckType(objectList, this.getPersistentAnchoringLineToLine().getLineUid(), PMLine.class, "line");
        line.linkCrossLinkToLineToLineAnchoring(this);
        this.targetLine = line;
    }

    @Override
    protected List<? extends Object> getCrosslinked() {
        List crosslinked = super.getCrosslinked();
        crosslinked.add(this.targetLine);
        return crosslinked;
    }

    public PMLine getTargetLine() {
        return this.targetLine;
    }

    @Override
    public IPMLineRO getTargetLineRO() {
        return this.getTargetLine();
    }

    @Override
    public IPMLineRW getTargetLineRW() {
        return this.getTargetLine();
    }

    public void setTargetLine(PMLine line) {
        this.setTargetLine((Object)line);
    }

    @Override
    public void setTargetLine(IPMLineRW line) {
        this.setTargetLine((Object)line);
    }

    private void setTargetLine(Object line) {
        assert (line == null || line instanceof PMLine) : "line is not instance of PMPoint";
        this.targetLine = (PMLine)line;
        if (line == null) {
            this.getPersistentAnchoringLineToLine().setLineUid(null);
        } else {
            this.getPersistentAnchoringLineToLine().setLineUid(this.targetLine.getPersistentLine().getUid());
        }
    }

    protected PMAnchoringLineToLine(PlanModelMgr planModelMgr, PMLine line, PMLine targetLine) {
        super(planModelMgr);
        this.persistent = new EOAnchoringLineToLine();
        this.constructPMAnchoring(line);
        this.setTargetLine(targetLine);
    }

    @Override
    protected void removeLinks() {
        super.removeLinks();
        this.setTargetLine(null);
    }

    @Override
    public void delete() {
        super.delete();
        if (this.getTargetLine() != null) {
            this.getTargetLine().setAnchoring(null);
            this.setTargetLine(null);
        }
    }

    @Override
    public IAnchoringDestination getAnchoringDestination() {
        return this.getAnchoringDestinationLine();
    }

    @Override
    public IAnchoringDestinationLine getAnchoringDestinationLine() {
        return this.getTargetLine();
    }

    @Override
    public boolean isDesirable() {
        return this.getLine().getPlanElement().getPlan().getAnchoringDecider().isDesirableAnchoring(this.getAnchoringSource(), this.getAnchoringDestination());
    }

    @Override
    public boolean isValid() {
        if (this.getLine() == null || this.getLine().getAnchoring() != this) {
            return false;
        }
        return this.getTargetLine() != null && this.getTargetLine().getLineToLineAnchoringIndex(this) >= 0;
    }

    static class AnchoringLineToLineFactory
    extends PMAnchoringLine.AnchoringLineFactory {
        AnchoringLineToLineFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMAnchoringLineToLine(planModelMgr, (EOAnchoringLineToLine)eo);
        }

        @Override
        public List getChildren(EncodableObjectBase eo) {
            return super.getChildren(eo);
        }
    }
}

